/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.engines.dbrep.FieldType;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.util.Logger;
import java.util.StringTokenizer;

public final class Field {
    private static final Logger logger = Logger.getLogger(Field.class);
    private String upperCaseName;
    private String javaClassName;
    private String javaVariableName;
    private FieldType fieldType;

    public Field(String string, String string2) {
        try {
            this.init(string, string2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public Field(String string) {
        try {
            this.init(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init(String string) throws Exception {
        StringTokenizer stringTokenizer = null;
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        stringTokenizer = new StringTokenizer(string, " ");
        this.init(stringTokenizer.nextToken(), stringTokenizer.nextToken());
    }

    private void init(String string, String string2) throws Exception {
        SimpleNameFormat simpleNameFormat = null;
        simpleNameFormat = new SimpleNameFormat(string);
        this.upperCaseName = string;
        this.javaClassName = simpleNameFormat.getCamelCase();
        this.javaVariableName = simpleNameFormat.getHungarian();
        this.fieldType = new FieldType(string2);
    }

    public String getUpperCaseName() {
        return this.upperCaseName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getJavaVariableName() {
        return this.javaVariableName;
    }

    public FieldType getType() {
        return this.fieldType;
    }

    public String toString() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append("this.upperCaseName: " + this.upperCaseName);
        stringBuffer.append("; this.javaClassName: " + this.javaClassName);
        stringBuffer.append("; this.javaVariableName: " + this.javaVariableName);
        stringBuffer.append("; this.fieldType: " + this.fieldType);
        return stringBuffer.toString();
    }
}

