/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.util;

import com.jronimo.engines.dataservice.ByteArray;
import com.jronimo.engines.dataservice.util.MySqlUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.Time;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.temporal.Timezone;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.math.BigDecimal;
import java.math.MathContext;

public final class FieldValueUtils {
    private static final Logger logger = Logger.getLogger(FieldValueUtils.class);

    private FieldValueUtils() {
    }

    public static String getStringValue(Constants.CodeType codeType, Object object) {
        String string = null;
        Assert.errorParam(codeType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "codeType"));
        if (object == null) {
            string = Constants.NullDirective.NULL.toString();
        } else {
            switch (codeType) {
                case BIG_DECIMAL: {
                    string = ((BigDecimal)object).toPlainString();
                    break;
                }
                case TIMEZONE: {
                    string = String.valueOf(((Timezone)object).getId());
                    break;
                }
                default: {
                    string = object.toString();
                }
            }
        }
        return string;
    }

    public static Object getCodeValue(DataType dataType, Constants.CodeType codeType, String string) {
        Object object = null;
        Assert.errorParam(dataType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataType"));
        Assert.errorParam(codeType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "codeType"));
        if (string == null || Constants.NullDirective.get(string) != null) {
            object = null;
        } else {
            switch (codeType) {
                case STRING: {
                    object = string;
                    break;
                }
                case LONG: {
                    object = Long.valueOf(string);
                    break;
                }
                case INTEGER: {
                    object = Integer.valueOf(string);
                    break;
                }
                case SHORT: {
                    object = Short.valueOf(string);
                    break;
                }
                case BYTE: {
                    object = Byte.valueOf(string);
                    break;
                }
                case BIG_DECIMAL: {
                    object = new BigDecimal(string);
                    break;
                }
                case DOUBLE: {
                    object = Double.valueOf(string);
                    break;
                }
                case FLOAT: {
                    object = Float.valueOf(string);
                    break;
                }
                case BOOLEAN: {
                    object = Boolean.valueOf(string);
                    break;
                }
                case DATE: {
                    object = new Date(string);
                    break;
                }
                case DATE_TIME: {
                    object = new DateTime(string);
                    break;
                }
                case TIME_OF_DAY: {
                    object = new TimeOfDay(string);
                    break;
                }
                case TIME: {
                    object = new Time(string);
                    break;
                }
                case TIMEZONE: {
                    object = Timezone.getTimezone(Integer.valueOf(string));
                    break;
                }
                case BYTE_ARRAY: {
                    object = new ByteArray(string);
                }
            }
        }
        return object;
    }

    public static Object getCodeValue(DataType dataType, Constants.CodeType codeType, DataSourceFieldType dataSourceFieldType, Object object) {
        Object object2 = null;
        Assert.errorParam(dataType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataType"));
        Assert.errorParam(codeType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "codeType"));
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        if (object != null && dataSourceFieldType.isMySqlType()) {
            object2 = MySqlUtils.getCodeValue(dataType, codeType, dataSourceFieldType, object);
        }
        return object2;
    }

    public static Object getPersistenceSetValue(DataType dataType, DataSourceFieldType dataSourceFieldType, Object object, Object object2) {
        Object object3 = null;
        Assert.errorParam(dataType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataType"));
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        if (object != null && dataSourceFieldType.isMySqlType()) {
            object3 = MySqlUtils.getPersistenceSetValue(dataType, dataSourceFieldType, object, object2);
        }
        return object3;
    }

    private static String nanosecondsToMilliseconds(String string) {
        String string2 = null;
        int n = 0;
        String string3 = null;
        String string4 = null;
        BigDecimal bigDecimal = null;
        if (string != null) {
            n = string.indexOf(".");
            if (n >= 0) {
                string3 = string.substring(0, n);
                string4 = string.substring(n);
                if (string4.length() == 1) {
                    string4 = ".000";
                }
                bigDecimal = new BigDecimal(string4).round(new MathContext(3));
                string4 = bigDecimal.toPlainString();
                string2 = string3 + string4.substring(string4.indexOf("."));
            } else {
                string2 = string;
            }
        }
        return string2;
    }
}

