/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.RecordPrimaryKey;
import com.jronimo.engines.dataservice.operationsengine.rdbms.ReadInitialQuery;
import com.jronimo.engines.dataservice.operationsengine.rdbms.ReadOperationSql;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.SecurityClauseSet;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

final class ReadResultsQuery {
    private static final Logger logger = Logger.getLogger(ReadResultsQuery.class);
    private EntityOperationDetails operationDetails;
    private ReadInitialQuery initialQuery;
    private ReadOperationSql operationSql;
    private SystemConfiguration system = null;
    private String tempTableName;
    private Connection connection;
    private Map<RecordPrimaryKey, RecordPrimaryKey> results = CollectionUtils.getOrderedMap(new HashMap());

    ReadResultsQuery(EntityOperationDetails entityOperationDetails, ReadInitialQuery readInitialQuery, ReadOperationSql readOperationSql) {
        this.operationDetails = entityOperationDetails;
        this.initialQuery = readInitialQuery;
        this.operationSql = readOperationSql;
        this.system = entityOperationDetails.getOperationContext().getDataServiceDeployment().getSystem();
        this.tempTableName = entityOperationDetails.getEntity().getName() + "_" + DateUtils.getUniqueTimestamp();
    }

    XmlElement execute() throws Exception {
        XmlElement xmlElement = null;
        this.connection = this.operationDetails.getOperationContext().getTransactionRdbmsConnection(this.operationDetails.getEntityDataSource().name);
        this.createTempTable();
        if (this.initialQuery.hasResults()) {
            this.selectIntoTempTable();
            this.marshalResults();
            this.applySecurityClauseSets();
        }
        xmlElement = Utils.createReturnXml(this.connection, this.operationDetails, this.tempTableName, this.results);
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempTable() throws Exception {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(this.operationSql.getCreateTempTableSql(this.tempTableName));
            this.operationDetails.getOperationContext().addTempTableForDeletion(this.connection, this.operationSql.getSchemaPortion() + this.tempTableName);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectIntoTempTable() throws Exception {
        String string = null;
        Statement statement = null;
        try {
            string = this.operationSql.getSelectIntoTempTableSql(this.tempTableName, this.initialQuery.getPrimaryKeyWhereClause());
            statement = this.connection.prepareStatement(string);
            statement.execute();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalResults() throws Exception {
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        RecordPrimaryKey recordPrimaryKey = null;
        try {
            string = "Select * From " + this.tempTableName;
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                recordPrimaryKey = new RecordPrimaryKey(resultSet, this.operationDetails);
                this.results.put(recordPrimaryKey, recordPrimaryKey);
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void applySecurityClauseSets() throws Exception {
        this.applySecurityClauseSet(this.operationDetails.getPrimarySecurityClauseSet(), true);
        if (this.operationDetails.returnSecurityClauseIds()) {
            this.applySecurityClauseSet(this.operationDetails.getOtherSecurityClauseSet(), false);
        }
    }

    private void applySecurityClauseSet(SecurityClauseSet securityClauseSet, boolean bl) throws Exception {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : securityClauseSet.getSecurityClauses()) {
            this.applySecurityClauseSet(entityPermissionSecurityClause, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySecurityClauseSet(EntityPermissionSecurityClause entityPermissionSecurityClause, boolean bl) throws Exception {
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        RecordPrimaryKey recordPrimaryKey = null;
        try {
            string = this.operationSql.getSelectFromTempTableSql(this.tempTableName, entityPermissionSecurityClause);
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                recordPrimaryKey = new RecordPrimaryKey(resultSet, this.operationDetails);
                recordPrimaryKey = this.results.get(recordPrimaryKey);
                if (bl) {
                    recordPrimaryKey.addSecurityClauseId(entityPermissionSecurityClause.getId());
                    continue;
                }
                for (Constants.EntityOperation entityOperation : entityPermissionSecurityClause.getSupportedOperations()) {
                    switch (entityOperation) {
                        case GET: 
                        case UPDATE: 
                        case DELETE: {
                            recordPrimaryKey.addOperationSecurityClauseId(entityOperation, entityPermissionSecurityClause.getId());
                        }
                    }
                }
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

