/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.ResourceTextIdentifiers;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.temporal.DateTime;
import com.jronimo.temporal.StringFormat;
import com.jronimo.text.ResourceText;
import com.jronimo.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RdbmsUtils {
    private static final Logger logger = Logger.getLogger(RdbmsUtils.class);

    private RdbmsUtils() {
    }

    static PreparedStatement getReadPreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        return RdbmsUtils.getPreparedStatement(entityOperationDetails, string, false);
    }

    static PreparedStatement getUpdateInitialPreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        return RdbmsUtils.getPreparedStatement(entityOperationDetails, string, true);
    }

    static PreparedStatement getDeletePreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        return RdbmsUtils.getPreparedStatement(entityOperationDetails, string, true);
    }

    static PreparedStatement getCreateSelectIntoPreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        Set<Field> set = null;
        ArrayList<FieldValue> arrayList = null;
        Long l = null;
        Field field = null;
        FieldValue fieldValue = null;
        set = entityOperationDetails.getEntity().getPrimaryKey().getFields(entityOperationDetails.getEntity());
        arrayList = new ArrayList<FieldValue>(set.size());
        switch (entityOperationDetails.getEntity().getPrimaryKey().getType()) {
            case SEQUENCE: 
            case AUTO_NUMBER: {
                l = entityOperationDetails.getNewCreateId();
                field = entityOperationDetails.getEntity().getPrimaryKey().getSingleField(entityOperationDetails.getEntity());
                fieldValue = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(entityOperationDetails.getEngine()), l.toString());
                arrayList.add(fieldValue);
                break;
            }
            case USER_ENTERED_IMMUTABLE: 
            case USER_ENTERED_MUTABLE: {
                for (Field field2 : set) {
                    arrayList.add(entityOperationDetails.getUpdateFieldValue(field2));
                }
                break;
            }
        }
        return RdbmsUtils.getPreparedStatement(entityOperationDetails, string, arrayList);
    }

    static PreparedStatement getCreatePreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        DateTime dateTime = null;
        String string2 = null;
        ArrayList<FieldValue> arrayList = null;
        Long l = null;
        Field field = null;
        FieldValue fieldValue = null;
        SystemField systemField = null;
        dateTime = DateTime.now(entityOperationDetails.getOperationContext().getSystemTimezone());
        string2 = dateTime.getString(new StringFormat(new StringFormat.TimezoneFormat(false)));
        arrayList = new ArrayList<FieldValue>(entityOperationDetails.getUpdateFieldValues().size() + 7);
        preparedStatement = entityOperationDetails.getOperationContext().getTransactionRdbmsConnection(entityOperationDetails.getEntityDataSource().name).prepareStatement(string);
        switch (entityOperationDetails.getEntity().getPrimaryKey().getType()) {
            case SEQUENCE: {
                l = RdbmsUtils.getIdFromSequence(entityOperationDetails);
                field = entityOperationDetails.getEntity().getPrimaryKey().getSingleField(entityOperationDetails.getEntity());
                fieldValue = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(entityOperationDetails.getEngine()), l.toString());
                arrayList.add(fieldValue);
            }
        }
        for (FieldValue fieldValue2 : entityOperationDetails.getUpdateFieldValues()) {
            arrayList.add(fieldValue2);
        }
        if (entityOperationDetails.getEntity().hasRecordStatusSystemField()) {
            field = entityOperationDetails.getEntity().getRecordStatusSystemField();
            fieldValue = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(entityOperationDetails.getEngine()), "-1");
            arrayList.add(fieldValue);
        }
        if (entityOperationDetails.getEntity().hasRecordVersionSystemField()) {
            systemField = entityOperationDetails.getEntity().getRecordVersionSystemField();
            if (systemField.getSystemFieldType().isRecordVersionWholeNumber()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), "1");
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isRecordVersionTimestamp()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isRecordVersionDateTime()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
                arrayList.add(fieldValue);
            }
        }
        if (entityOperationDetails.getEntity().hasCreateUserSystemField()) {
            systemField = entityOperationDetails.getEntity().getCreateUserSystemField();
            if (systemField.getSystemFieldType().isAuditCreateUserId()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUserId().toString());
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isAuditCreateUsername()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUsername().toString());
                arrayList.add(fieldValue);
            }
        }
        if (entityOperationDetails.getEntity().hasCreateTimestampSystemField()) {
            systemField = entityOperationDetails.getEntity().getCreateTimestampSystemField();
            fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
            arrayList.add(fieldValue);
        }
        if (entityOperationDetails.getEntity().hasUpdateUserSystemField()) {
            systemField = entityOperationDetails.getEntity().getUpdateUserSystemField();
            if (systemField.getSystemFieldType().isAuditUpdateUserId()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUserId().toString());
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isAuditUpdateUsername()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUsername().toString());
                arrayList.add(fieldValue);
            }
        }
        if (entityOperationDetails.getEntity().hasUpdateTimestampSystemField()) {
            systemField = entityOperationDetails.getEntity().getUpdateTimestampSystemField();
            fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
            arrayList.add(fieldValue);
        }
        preparedStatement = RdbmsUtils.getPreparedStatement(entityOperationDetails, string, arrayList);
        return preparedStatement;
    }

    static PreparedStatement getUpdatePreparedStatement(EntityOperationDetails entityOperationDetails, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        DateTime dateTime = null;
        String string2 = null;
        ArrayList<FieldValue> arrayList = null;
        SystemField systemField = null;
        String string3 = null;
        FieldValue fieldValue = null;
        dateTime = DateTime.now(entityOperationDetails.getOperationContext().getSystemTimezone());
        string2 = dateTime.getString(new StringFormat(new StringFormat.TimezoneFormat(false)));
        arrayList = new ArrayList<FieldValue>(entityOperationDetails.getUpdateFieldValues().size() + 4);
        preparedStatement = entityOperationDetails.getOperationContext().getTransactionRdbmsConnection(entityOperationDetails.getEntityDataSource().name).prepareStatement(string);
        for (FieldValue object : entityOperationDetails.getUpdateFieldValues()) {
            arrayList.add(object);
        }
        if (entityOperationDetails.getEntity().hasRecordVersionSystemField()) {
            systemField = entityOperationDetails.getEntity().getRecordVersionSystemField();
            if (systemField.getSystemFieldType().isRecordVersionWholeNumber()) {
                string3 = String.valueOf(Long.parseLong(entityOperationDetails.getSubmittedRecordVersion().getStringValue()) + 1L);
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string3);
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isRecordVersionTimestamp()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isRecordVersionDateTime()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
                arrayList.add(fieldValue);
            }
        }
        if (entityOperationDetails.getEntity().hasUpdateUserSystemField()) {
            systemField = entityOperationDetails.getEntity().getUpdateUserSystemField();
            if (systemField.getSystemFieldType().isAuditUpdateUserId()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUserId().toString());
                arrayList.add(fieldValue);
            } else if (systemField.getSystemFieldType().isAuditUpdateUsername()) {
                fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), entityOperationDetails.getOperationContext().getUserSecurityContext().getUsername().toString());
                arrayList.add(fieldValue);
            }
        }
        if (entityOperationDetails.getEntity().hasUpdateTimestampSystemField()) {
            systemField = entityOperationDetails.getEntity().getUpdateTimestampSystemField();
            fieldValue = FieldValue.createInstanceFromStringValue(systemField.getDataType(), systemField.getCodeType(), systemField.getDataSourceFieldType(entityOperationDetails.getEngine()), string2);
            arrayList.add(fieldValue);
        }
        for (Field field : entityOperationDetails.getPrimaryKeyFields()) {
            arrayList.add(entityOperationDetails.getWhereFieldValues().get(entityOperationDetails.getWhereFields().indexOf(field)));
        }
        preparedStatement = RdbmsUtils.getPreparedStatement(entityOperationDetails, string, arrayList);
        return preparedStatement;
    }

    private static PreparedStatement getPreparedStatement(EntityOperationDetails entityOperationDetails, String string, boolean bl) throws Exception {
        PreparedStatement preparedStatement = null;
        ArrayList<FieldValue> arrayList = null;
        arrayList = new ArrayList<FieldValue>(entityOperationDetails.getWhereFieldValues().size());
        preparedStatement = entityOperationDetails.getOperationContext().getTransactionRdbmsConnection(entityOperationDetails.getEntityDataSource().name).prepareStatement(string);
        int n = entityOperationDetails.getWhereFieldValues().size();
        for (int i = 0; i < n; ++i) {
            if (bl && !entityOperationDetails.getEntity().isPrimaryKeyField(entityOperationDetails.getWhereFields().get(i).getName())) continue;
            arrayList.add(entityOperationDetails.getWhereFieldValues().get(i));
        }
        preparedStatement = RdbmsUtils.getPreparedStatement(entityOperationDetails, string, arrayList);
        return preparedStatement;
    }

    private static PreparedStatement getPreparedStatement(EntityOperationDetails entityOperationDetails, String string, List<FieldValue> list) throws Exception {
        PreparedStatement preparedStatement = null;
        int n = 0;
        preparedStatement = entityOperationDetails.getOperationContext().getTransactionRdbmsConnection(entityOperationDetails.getEntityDataSource().name).prepareStatement(string, 1);
        for (FieldValue fieldValue : list) {
            ++n;
            if (fieldValue.isNullDirective()) continue;
            if (fieldValue == null) {
                preparedStatement.setNull(n, 0);
                continue;
            }
            preparedStatement.setObject(n, fieldValue.getPersistenceSetValue());
        }
        return preparedStatement;
    }

    private static Long getIdFromSequence(EntityOperationDetails entityOperationDetails) throws Exception {
        Long l = null;
        switch (entityOperationDetails.getSystemDataSource().getSequenceDetails().sequenceType) {
            case TABLE: {
                l = RdbmsUtils.getIdFromTableSequence(entityOperationDetails);
                break;
            }
            case DATABASE: {
                l = RdbmsUtils.getIdFromDatabaseSequence(entityOperationDetails);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getIdFromTableSequence(EntityOperationDetails entityOperationDetails) throws Exception {
        Long l = null;
        DataSource dataSource = null;
        String string = null;
        String string2 = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        dataSource = entityOperationDetails.getSystemDataSource();
        string = "Select NEXT_VALUE From " + dataSource.getDefaultSchema() + "." + dataSource.getSequenceDetails().sequenceTableName + " Where NAME = '" + entityOperationDetails.getEntity().getPersistenceIdentifier() + "'";
        try {
            block4: {
                connection = entityOperationDetails.getOperationContext().getStandaloneRdbmsConnection(entityOperationDetails.getSystemDataSource().getName());
                do {
                    if (!(resultSet = (statement = connection.createStatement()).executeQuery(string)).next()) {
                        throw new UnexpectedErrorException(ResourceText.getText((Object)com.jronimo.text.ResourceTextIdentifiers.ENUM_MEMBER_NOT_FOUND, (Object[])new String[]{entityOperationDetails.getEntity().getPersistenceIdentifier()}));
                    }
                    l = resultSet.getLong("NEXT_VALUE");
                    string2 = "Update " + dataSource.getDefaultSchema() + "." + dataSource.getSequenceDetails().sequenceTableName + " Set NEXT_VALUE = " + (l + 1L) + " Where NAME = '" + entityOperationDetails.getEntity().getPersistenceIdentifier() + "' And NEXT_VALUE = " + l;
                    n = statement.executeUpdate(string2);
                    if (n == 1) break block4;
                } while (n <= 1);
                throw new UnexpectedErrorException(ResourceText.getText((Object)ResourceTextIdentifiers.UNEXPECTED_MULTIPLE_SEQUENCE_UPDATE, (Object[])new String[]{entityOperationDetails.getEntity().getPersistenceIdentifier()}));
            }
            entityOperationDetails.setNewCreateId(l);
            connection.commit();
        }
        catch (Throwable throwable) {
            Utils.close(statement);
            entityOperationDetails.getOperationContext().returnStandaloneConnection(connection);
            throw throwable;
        }
        Utils.close(statement);
        entityOperationDetails.getOperationContext().returnStandaloneConnection(connection);
        return l;
    }

    private static Long getIdFromDatabaseSequence(EntityOperationDetails entityOperationDetails) throws Exception {
        Long l = null;
        return l;
    }
}

