/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SystemField;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OperationSql {
    private static final Logger logger = Logger.getLogger(OperationSql.class);
    protected EntityOperationDetails operationDetails;
    protected String schemaPortion;
    protected String selectClause;
    protected String whereFieldsWhereClause;
    protected String primaryKeyFieldsWhereClause;

    OperationSql(EntityOperationDetails entityOperationDetails) {
        this.operationDetails = entityOperationDetails;
        this.prepareSql();
    }

    protected String getSchemaPortion() {
        return this.schemaPortion;
    }

    protected String getCreateTempTableSql(String string, Set<Field> set) {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder("Create Temporary Table ");
        stringBuilder.append(this.schemaPortion);
        stringBuilder.append(string);
        stringBuilder.append(" (");
        for (Field field : set) {
            if (++n > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(field.getPersistenceIdentifier());
            stringBuilder.append(" ");
            stringBuilder.append(field.getTypeDetails().getDataSourceFieldType(this.operationDetails.getEngine()).getPersistenceDefinition());
        }
        if (this.operationDetails.getPrimaryKeyFields().size() > 0) {
            n = 0;
            stringBuilder.append(", Primary Key (");
            for (Field field : this.operationDetails.getPrimaryKeyFields()) {
                if (++n > 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(field.getPersistenceIdentifier());
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String getSelectIntoTempTableSql(String string, Set<Field> set, String string2) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        String string3 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions2 = null;
        string3 = this.getSelectFieldList(set);
        stringWrapperWithVoidRegions2 = new StringWrapperWithVoidRegions(this.selectClause);
        stringWrapperWithVoidRegions2.replaceAll("{field-list}", string3);
        stringWrapperWithVoidRegions2.replaceAll("{table-name}", this.operationDetails.getEntity().getPersistenceIdentifier());
        stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions();
        stringWrapperWithVoidRegions.append("Insert Into ");
        stringWrapperWithVoidRegions.append(this.schemaPortion);
        stringWrapperWithVoidRegions.append(string);
        stringWrapperWithVoidRegions.append(" (");
        stringWrapperWithVoidRegions.append(string3);
        stringWrapperWithVoidRegions.append(") ");
        stringWrapperWithVoidRegions.append(stringWrapperWithVoidRegions2);
        stringWrapperWithVoidRegions.append(string2);
        return stringWrapperWithVoidRegions.toString();
    }

    protected String getSelectFromTempTableSql(String string, EntityPermissionSecurityClause entityPermissionSecurityClause) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Set<Field> set = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions2 = null;
        set = this.operationDetails.getPrimaryKeyFields();
        stringWrapperWithVoidRegions2 = new StringWrapperWithVoidRegions(this.operationDetails.getOperationContext().getUserSecurityContext().doSecurityClauseSubstitutions(entityPermissionSecurityClause));
        if (!stringWrapperWithVoidRegions2.isEmpty()) {
            stringWrapperWithVoidRegions2.append(" Where ");
            stringWrapperWithVoidRegions2.append(stringWrapperWithVoidRegions2);
        }
        stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(this.selectClause);
        stringWrapperWithVoidRegions.replaceAll("{field-list}", this.getSelectFieldList(set));
        stringWrapperWithVoidRegions.replaceAll("{table-name}", string);
        stringWrapperWithVoidRegions.append(stringWrapperWithVoidRegions2);
        return stringWrapperWithVoidRegions.toString();
    }

    private void prepareSql() {
        this.schemaPortion = this.operationDetails.getEntityDataSource().schema + ".";
        this.prepareSqlSelectClause();
        this.whereFieldsWhereClause = this.prepareSqlWhereFieldWhereClause();
        this.primaryKeyFieldsWhereClause = this.prepareSqPrimaryKeyWhereClause();
    }

    private void prepareSqlSelectClause() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        stringBuilder.append("Select {field-list} From ");
        stringBuilder.append(this.schemaPortion);
        stringBuilder.append("{table-name}");
        this.selectClause = stringBuilder.toString();
    }

    private String prepareSqlWhereFieldWhereClause() {
        StringBuilder stringBuilder = null;
        FieldValue fieldValue = null;
        int n = -1;
        stringBuilder = new StringBuilder();
        if (this.operationDetails.getWhereFields().size() > 0) {
            stringBuilder.append(" Where (");
            for (Field field : this.operationDetails.getWhereFields()) {
                fieldValue = this.operationDetails.getWhereFieldValues().get(++n);
                if (n > 0) {
                    stringBuilder.append(" And ");
                }
                stringBuilder.append(field.getPersistenceIdentifier());
                if (fieldValue.isNullDirective()) {
                    if (fieldValue.isNullDirectiveNotNull()) {
                        stringBuilder.append(" Is Not Null");
                        continue;
                    }
                    if (!fieldValue.isNullDirectiveNull()) continue;
                    stringBuilder.append(" Is Null");
                    continue;
                }
                stringBuilder.append(" = ?");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String prepareSqPrimaryKeyWhereClause() {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder(" Where (");
        for (Field field : this.operationDetails.getEntity().getPrimaryKey().getFields(this.operationDetails.getEntity())) {
            if (++n > 1) {
                stringBuilder.append(" And ");
            }
            stringBuilder.append(field.getPersistenceIdentifier());
            stringBuilder.append(" = ?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String getSelectFieldList(Set<Field> set) {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder();
        for (Field field : set) {
            if (++n > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(field.getPersistenceIdentifier());
        }
        return stringBuilder.toString();
    }

    protected String getSecurityClauseSql() {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder();
        if (!this.operationDetails.getPrimarySecurityClauseSet().hasDefault()) {
            stringBuilder.append(" And (");
            for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.operationDetails.getPrimarySecurityClauseSet().getSecurityClauses()) {
                if (++n > 1) {
                    stringBuilder.append(" Or ");
                }
                stringBuilder.append(this.operationDetails.getOperationContext().getUserSecurityContext().doSecurityClauseSubstitutions(entityPermissionSecurityClause));
            }
            stringBuilder.append(")");
        }
        this.operationDetails.getPrimarySecurityClauseSet().getSecurityClauses();
        return stringBuilder.toString();
    }

    protected Set<Field> combine(Set<Field> set, Set<SystemField> set2) {
        Set set3 = null;
        set3 = CollectionUtils.getOrderedSet(new HashSet(set.size() + set2.size()));
        set3.addAll(set);
        set3.addAll(set2);
        return set3;
    }
}

