/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine.rdbms;

import com.jronimo.constraints.ValidationOutcomes;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.exceptions.RecordNotFoundException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedCreateFieldException;
import com.jronimo.engines.dataservice.exceptions.UnauthorizedRecordCreateException;
import com.jronimo.engines.dataservice.exceptions.ValidationException;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationUtils;
import com.jronimo.engines.dataservice.operationsengine.RecordPrimaryKey;
import com.jronimo.engines.dataservice.operationsengine.rdbms.CreateOperationSql;
import com.jronimo.engines.dataservice.operationsengine.rdbms.RdbmsUtils;
import com.jronimo.engines.dataservice.operationsengine.rdbms.Utils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class CreateQuery {
    private static final Logger logger = Logger.getLogger(CreateQuery.class);
    private EntityOperationDetails operationDetails;
    private CreateOperationSql operationSql;
    private SystemConfiguration system = null;
    private String tempTableName;
    private Connection connection;
    private RecordPrimaryKey recordPrimaryKey;
    private Map<Field, FieldValue> keyFieldValues = new HashMap<Field, FieldValue>(3);

    CreateQuery(EntityOperationDetails entityOperationDetails, CreateOperationSql createOperationSql) {
        this.operationDetails = entityOperationDetails;
        this.operationSql = createOperationSql;
        this.system = entityOperationDetails.getOperationContext().getDataServiceDeployment().getSystem();
        this.tempTableName = entityOperationDetails.getEntity().getName() + "_" + DateUtils.getUniqueTimestamp();
    }

    XmlElement execute() throws Exception {
        XmlElement xmlElement = null;
        this.connection = this.operationDetails.getOperationContext().getTransactionRdbmsConnection(this.operationDetails.getEntityDataSource().name);
        this.createTempTable();
        this.selectIntoTempTable();
        this.validate();
        this.marshalResults();
        this.applySecurityClauseSet();
        this.checkFieldPermissions();
        this.checkKeys();
        xmlElement = this.createReturnXml();
        return xmlElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempTable() throws Exception {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(this.operationSql.getCreateTempTableSql(this.tempTableName));
            this.operationDetails.getOperationContext().addTempTableForDeletion(this.connection, this.operationSql.getSchemaPortion() + this.tempTableName);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectIntoTempTable() throws Exception {
        String string = null;
        Statement statement = null;
        try {
            string = this.operationSql.getSelectIntoTempTableSql(this.tempTableName);
            statement = RdbmsUtils.getCreateSelectIntoPreparedStatement(this.operationDetails, string);
            statement.execute();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() throws Exception {
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<FieldValue> arrayList = null;
        FieldValue fieldValue = null;
        ValidationOutcomes validationOutcomes = null;
        try {
            string = "Select * From " + this.tempTableName;
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            arrayList = new ArrayList<FieldValue>(this.operationDetails.getEntity().getFields().size());
            if (resultSet.next()) {
                for (Field field : this.operationDetails.getEntity().getFields()) {
                    fieldValue = FieldValue.createInstanceFromPersistenceValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(this.operationDetails.getEngine()), resultSet.getObject(field.getPersistenceIdentifier()));
                    arrayList.add(fieldValue);
                }
                validationOutcomes = EntityOperationUtils.validate(this.operationDetails, this.operationDetails.getEntity().getFields(), arrayList);
                if (!validationOutcomes.passed()) {
                    throw new ValidationException(Utils.createReturnXmlFromValidationOutcomes(this.operationDetails, validationOutcomes));
                }
                if (this.operationDetails.getConstraintSet().hasValidator() && !(validationOutcomes = Utils.callValidator(this.operationDetails, this.operationDetails.getEntity().getFields(), arrayList)).passed()) {
                    throw new ValidationException(Utils.createReturnXmlFromValidationOutcomes(this.operationDetails, validationOutcomes));
                }
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalResults() throws Exception {
        block13: {
            String string = null;
            Statement statement = null;
            ResultSet resultSet = null;
            FieldValue fieldValue = null;
            try {
                string = "Select * From " + this.tempTableName;
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    this.recordPrimaryKey = new RecordPrimaryKey(resultSet, this.operationDetails);
                    for (Field field : this.operationDetails.getKeyFields()) {
                        fieldValue = FieldValue.createInstanceFromPersistenceValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(this.operationDetails.getEngine()), resultSet.getObject(field.getPersistenceIdentifier()));
                        this.keyFieldValues.put(field, fieldValue);
                    }
                    break block13;
                }
                throw new RecordNotFoundException(this.operationDetails);
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void applySecurityClauseSet() throws Exception {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.operationDetails.getPrimarySecurityClauseSet().getSecurityClauses()) {
            this.applySecurityClauseSet(entityPermissionSecurityClause, true);
        }
        if (this.recordPrimaryKey.getSecurityClauseSet(this.system).isEmpty()) {
            throw new UnauthorizedRecordCreateException(this.operationDetails);
        }
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.operationDetails.getOtherSecurityClauseSet().getSecurityClauses()) {
            this.applySecurityClauseSet(entityPermissionSecurityClause, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySecurityClauseSet(EntityPermissionSecurityClause entityPermissionSecurityClause, boolean bl) throws Exception {
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            string = this.operationSql.getSelectFromTempTableSql(this.tempTableName, entityPermissionSecurityClause);
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                if (bl) {
                    this.recordPrimaryKey.addSecurityClauseId(entityPermissionSecurityClause.getId());
                } else {
                    for (Constants.EntityOperation entityOperation : entityPermissionSecurityClause.getSupportedOperations()) {
                        switch (entityOperation) {
                            case GET: 
                            case UPDATE: 
                            case DELETE: {
                                this.recordPrimaryKey.addOperationSecurityClauseId(entityOperation, entityPermissionSecurityClause.getId());
                            }
                        }
                    }
                }
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private void checkFieldPermissions() {
        for (Field field : this.operationDetails.getUpdateFields()) {
            if (this.recordPrimaryKey.getSecurityClauseSet(this.system).hasCreateField(field.getName())) continue;
            throw new UnauthorizedCreateFieldException(this.operationDetails, field.getName());
        }
    }

    private void checkKeys() throws Exception {
    }

    private XmlElement createReturnXml() throws Exception {
        XmlElement xmlElement = null;
        HashMap<RecordPrimaryKey, RecordPrimaryKey> hashMap = null;
        hashMap = new HashMap<RecordPrimaryKey, RecordPrimaryKey>(1);
        hashMap.put(this.recordPrimaryKey, this.recordPrimaryKey);
        xmlElement = Utils.createReturnXml(this.connection, this.operationDetails, this.tempTableName, hashMap);
        return xmlElement;
    }
}

