/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice.operationsengine;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.operationsengine.EntityOperationDetails;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.SecurityClauseSet;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class RecordPrimaryKey {
    private static final Logger logger = Logger.getLogger(RecordPrimaryKey.class);
    private Map<String, FieldValue> fieldValues = CollectionUtils.getOrderedMap(new HashMap(1));
    private Set<Long> securityClauseIds = new HashSet<Long>(10);
    private Map<Constants.EntityOperation, Set<Long>> operationSecurityClauseIds = CollectionUtils.getOrderedMap(new HashMap(3));
    private Integer hashCode;

    public RecordPrimaryKey(ResultSet resultSet, EntityOperationDetails entityOperationDetails) throws Exception {
        FieldValue fieldValue = null;
        for (Field field : entityOperationDetails.getPrimaryKeyFields()) {
            fieldValue = FieldValue.createInstanceFromPersistenceValue(field.getDataType(), field.getCodeType(), field.getDataSourceFieldType(entityOperationDetails.getEngine()), resultSet.getObject(field.getPersistenceIdentifier()));
            this.addFieldValue(field.getName(), fieldValue);
        }
    }

    public void addFieldValue(String string, FieldValue fieldValue) {
        this.fieldValues.put(string, fieldValue);
    }

    public synchronized void addSecurityClauseId(long l) {
        if (!this.securityClauseIds.contains(l)) {
            this.securityClauseIds.add(l);
        }
    }

    public SecurityClauseSet getSecurityClauseSet(SystemConfiguration systemConfiguration) {
        SecurityClauseSet securityClauseSet = null;
        securityClauseSet = new SecurityClauseSet();
        for (long l : this.securityClauseIds) {
            securityClauseSet.add(systemConfiguration.getEntityPermissionSecurityClause(l));
        }
        return securityClauseSet;
    }

    public synchronized void addOperationSecurityClauseId(Constants.EntityOperation entityOperation, long l) {
        Set set = null;
        set = this.operationSecurityClauseIds.get((Object)entityOperation);
        if (set == null) {
            set = CollectionUtils.getOrderedSet(new HashSet(2));
            this.operationSecurityClauseIds.put(entityOperation, set);
        }
        if (!set.contains(l)) {
            set.add(l);
        }
    }

    public SecurityClauseSet getOperationSecurityClauseSet(SystemConfiguration systemConfiguration, Constants.EntityOperation entityOperation) {
        SecurityClauseSet securityClauseSet = null;
        securityClauseSet = new SecurityClauseSet();
        for (long l : this.operationSecurityClauseIds.get((Object)entityOperation)) {
            securityClauseSet.add(systemConfiguration.getEntityPermissionSecurityClause(l));
        }
        return securityClauseSet;
    }

    public String getWhereClauseIn() {
        String string;
        block1: {
            string = null;
            if (this.fieldValues.size() > 1) {
                throw new UnexpectedErrorException("This method should only be called when there is one primary key field.");
            }
            Iterator<String> iterator = this.fieldValues.keySet().iterator();
            if (!iterator.hasNext()) break block1;
            String string2 = iterator.next();
            string = this.fieldValues.get(string2).getDirectSqlValue();
        }
        return string;
    }

    public String getWhereClauseOr() {
        StringBuilder stringBuilder = null;
        FieldValue fieldValue = null;
        int n = 0;
        stringBuilder = new StringBuilder("(");
        for (String string : this.fieldValues.keySet()) {
            fieldValue = this.fieldValues.get(string);
            if (++n > 1) {
                stringBuilder.append(" And ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(fieldValue.getDirectSqlValue());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getPrimaryKeyValuesForXml() {
        StringBuilder stringBuilder = null;
        int n = 0;
        stringBuilder = new StringBuilder();
        if (this.fieldValues.size() > 1) {
            stringBuilder.append("(");
        }
        for (FieldValue fieldValue : this.fieldValues.values()) {
            if (++n > 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append(fieldValue);
        }
        if (this.fieldValues.size() > 1) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String getOperationSecurityClauseIdsAsString(Constants.EntityOperation entityOperation) {
        StringBuilder stringBuilder = null;
        Collection collection = null;
        int n = 0;
        stringBuilder = new StringBuilder();
        collection = this.operationSecurityClauseIds.get((Object)entityOperation);
        if (collection != null) {
            for (Long l : collection) {
                if (++n > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(l);
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.calculateHashCode();
        }
        return this.hashCode;
    }

    private synchronized void calculateHashCode() {
        if (this.hashCode == null) {
            this.hashCode = 17;
            for (FieldValue fieldValue : this.fieldValues.values()) {
                RecordPrimaryKey recordPrimaryKey = this;
                Integer.valueOf(recordPrimaryKey.hashCode * 37);
                recordPrimaryKey.hashCode = recordPrimaryKey.hashCode;
                if (fieldValue == null) continue;
                recordPrimaryKey = this;
                Integer.valueOf(recordPrimaryKey.hashCode + ((Object)fieldValue).hashCode());
                recordPrimaryKey.hashCode = recordPrimaryKey.hashCode;
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        RecordPrimaryKey recordPrimaryKey = null;
        Iterator<String> iterator = null;
        String string2 = null;
        if (object instanceof RecordPrimaryKey) {
            recordPrimaryKey = (RecordPrimaryKey)object;
            if (this.fieldValues.size() == recordPrimaryKey.fieldValues.size()) {
                bl = true;
                for (String string2 : this.fieldValues.keySet()) {
                    if (Methods.bothEqual(this.fieldValues.get(string2), this.fieldValues.get(string2))) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }
}

