/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.SecurityClause;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserSecurityContext {
    private static final Logger logger = Logger.getLogger(UserSecurityContext.class);
    private Long userId;
    private Set<SystemRole> systemRoles;
    private Map<String, String> securityProperties = new HashMap<String, String>();

    public UserSecurityContext(Long l, Set<SystemRole> set) {
        this.userId = l;
        this.systemRoles = set;
        this.securityProperties.put("userId", String.valueOf(l));
    }

    public boolean isAuthenticated() {
        boolean bl = false;
        for (SystemRole systemRole : this.systemRoles) {
            if (!systemRole.getName().equals("AuthenticatedUser")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUsername() {
        String string = null;
        return string;
    }

    public boolean hasSystemRole(long l) {
        boolean bl = false;
        for (SystemRole systemRole : this.systemRoles) {
            if (systemRole.getId() != l) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasSystemRole(String string) {
        boolean bl = false;
        for (SystemRole systemRole : this.systemRoles) {
            if (!systemRole.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Set<SystemRole> getSystemRoles() {
        return CollectionUtils.collectionToSet(this.systemRoles);
    }

    public void addSecurityProperty(String string, String string2) {
        this.securityProperties.put(string, string2);
    }

    public String getSecurityProperty(String string) {
        return this.securityProperties.get(string);
    }

    public Collection<String> getSecurityPropertyNames() {
        return CollectionUtils.collectionToSet(this.securityProperties.keySet());
    }

    public String doSecurityClauseSubstitutions(SecurityClause securityClause) {
        StringBuilder stringBuilder = null;
        int n = 0;
        String string = null;
        String string2 = null;
        stringBuilder = new StringBuilder();
        if (!securityClause.isDefault()) {
            stringBuilder.append("(" + securityClause.getClause() + ")");
            for (String string3 : securityClause.getSecurityProperties()) {
                string = this.getSecurityProperty(string3);
                string2 = "{" + string3 + "}";
                while ((n = stringBuilder.indexOf(string2)) >= 0) {
                    stringBuilder.replace(n, n + string2.length(), string);
                }
            }
        }
        return stringBuilder.toString();
    }

    public XmlElement getXml() {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.create("security-context");
        xmlElement.addElement("user-id").setLong(this.userId);
        xmlElement2 = xmlElement.addElement("system-roles");
        for (SystemRole systemRole : this.systemRoles) {
            xmlElement2.addElement("system-role").setText(systemRole.getName());
        }
        return xmlElement;
    }
}

