/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice;

import com.jronimo.engines.dataservice.Methods;
import com.jronimo.engines.dataservice.util.FieldValueUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSourceFieldType;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;

public final class FieldValue {
    private static final Logger logger = Logger.getLogger(FieldValue.class);
    private DataType dataType;
    private Constants.CodeType codeType;
    private DataSourceFieldType dataSourceFieldType;
    private String stringValue;
    private Object codeValue;
    private Object persistenceSetValue;
    private Constants.NullDirective nullDirective;

    private FieldValue(DataType dataType, Constants.CodeType codeType, DataSourceFieldType dataSourceFieldType, String string, Object object, Object object2) {
        this.dataType = dataType;
        this.codeType = codeType;
        this.dataSourceFieldType = dataSourceFieldType;
        this.stringValue = string;
        this.codeValue = object;
        this.persistenceSetValue = object2;
        this.nullDirective = Constants.NullDirective.get(string);
    }

    public static FieldValue createInstanceFromStringValue(DataType dataType, Constants.CodeType codeType, DataSourceFieldType dataSourceFieldType, String string) {
        FieldValue fieldValue = null;
        Object object = null;
        Object object2 = null;
        Assert.errorParam(dataType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataType"));
        Assert.errorParam(codeType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "codeType"));
        object = FieldValueUtils.getCodeValue(dataType, codeType, string);
        if (dataSourceFieldType != null) {
            object2 = FieldValueUtils.getPersistenceSetValue(dataType, dataSourceFieldType, object, null);
        }
        fieldValue = new FieldValue(dataType, codeType, dataSourceFieldType, string, object, object2);
        return fieldValue;
    }

    public static FieldValue createInstanceFromPersistenceValue(DataType dataType, Constants.CodeType codeType, DataSourceFieldType dataSourceFieldType, Object object) {
        FieldValue fieldValue = null;
        String string = null;
        Object object2 = null;
        Object object3 = null;
        Assert.errorParam(dataType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataType"));
        Assert.errorParam(codeType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "codeType"));
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        object2 = FieldValueUtils.getCodeValue(dataType, codeType, dataSourceFieldType, object);
        string = FieldValueUtils.getStringValue(codeType, object2);
        object3 = FieldValueUtils.getPersistenceSetValue(dataType, dataSourceFieldType, object2, object);
        fieldValue = new FieldValue(dataType, codeType, dataSourceFieldType, string, object2, object3);
        return fieldValue;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Constants.CodeType getCodeType() {
        return this.codeType;
    }

    public FieldValue setDataSourceFieldType(DataSourceFieldType dataSourceFieldType) {
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "value"));
        if (this.dataSourceFieldType != null) {
            this.dataSourceFieldType = dataSourceFieldType;
            this.persistenceSetValue = FieldValueUtils.getPersistenceSetValue(this.dataType, dataSourceFieldType, this.codeValue, null);
        }
        return this;
    }

    public boolean hasDataSourceFieldType() {
        return this.dataSourceFieldType != null;
    }

    public DataSourceFieldType getDataSourceFieldType() {
        return this.dataSourceFieldType;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Object getCodeValue() {
        return this.codeValue;
    }

    public Object getPersistenceSetValue() {
        Assert.errorState(this.dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "this.dataSourceFieldType"));
        return this.persistenceSetValue;
    }

    public Object getPersistenceSetValue(DataSourceFieldType dataSourceFieldType) {
        Object object = null;
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        object = this.dataSourceFieldType == null || !this.dataSourceFieldType.equals(dataSourceFieldType) ? FieldValueUtils.getPersistenceSetValue(this.dataType, dataSourceFieldType, this.codeValue, null) : this.persistenceSetValue;
        return object;
    }

    public boolean isNull() {
        return this.codeValue == null;
    }

    public Constants.NullDirective getNullDirective() {
        return this.nullDirective;
    }

    public boolean isNullDirective() {
        return this.nullDirective != null;
    }

    public boolean isNullDirectiveNull() {
        return this.nullDirective == Constants.NullDirective.NULL;
    }

    public boolean isNullDirectiveNotNull() {
        return this.nullDirective == Constants.NullDirective.NOT_NULL;
    }

    public String getDirectSqlValue() {
        Assert.errorState(this.dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        return this.dataSourceFieldType.getUnderlyingType().getDirectSqlValue(this.persistenceSetValue);
    }

    public String getDirectSqlValue(DataSourceFieldType dataSourceFieldType) {
        String string = null;
        Assert.errorParam(dataSourceFieldType == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "dataSourceFieldType"));
        string = dataSourceFieldType.getUnderlyingType().getDirectSqlValue(this.getPersistenceSetValue(dataSourceFieldType));
        return string;
    }

    public int hashCode() {
        int n = 17;
        if (this.stringValue != null) {
            n = n * 37 + this.stringValue.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        FieldValue fieldValue = null;
        if (object instanceof FieldValue) {
            fieldValue = (FieldValue)object;
            bl = Methods.bothEqual(this.stringValue, fieldValue.stringValue);
        }
        return bl;
    }

    public String toString() {
        return this.isNull() ? "null" : this.stringValue;
    }
}

