/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dataservice;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.UserSecurityContext;
import com.jronimo.engines.dataservice.operationsengine.OperationContext;
import com.jronimo.engines.dataservice.operationsengine.OperationsManager;
import com.jronimo.internationalization.Language;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.loader.xml.XmlLoader;
import com.jronimo.temporal.Timezone;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Session;
import com.jronimo.webappengines.core.SystemDeployment;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataService {
    private static final Logger logger = Logger.getLogger(DataService.class);
    private SystemDeployment overallSystemDeployment;
    private SystemConfiguration system;
    private Map<String, DataSourceConnectionDetails> dataSources;
    private File dataServiceRoot;
    private OperationsManager operationsManager;

    private DataService(SystemDeployment systemDeployment, SystemConfiguration systemConfiguration, Map<String, DataSourceConnectionDetails> map, File file) {
        this.overallSystemDeployment = systemDeployment;
        this.system = systemConfiguration;
        this.dataSources = map;
        this.dataServiceRoot = file;
        this.operationsManager = new OperationsManager();
    }

    public static DataService createInstance(SystemDeployment systemDeployment, File file) throws Exception {
        DataService dataService = null;
        XmlElement xmlElement = null;
        Map<String, DataSourceConnectionDetails> map = null;
        SystemConfiguration systemConfiguration = null;
        xmlElement = XmlElementFactory.load(new File(file, "DataService.xml"));
        map = DataService.getDataSources(xmlElement.getOptionalElements("data-sources/data-source"));
        systemConfiguration = new XmlLoader(new File(file, "System.xml")).execute();
        dataService = new DataService(systemDeployment, systemConfiguration, map, file);
        return dataService;
    }

    private static Map<String, DataSourceConnectionDetails> getDataSources(Collection<XmlElement> collection) throws Exception {
        HashMap<String, DataSourceConnectionDetails> hashMap = null;
        hashMap = new HashMap<String, DataSourceConnectionDetails>(3);
        for (XmlElement xmlElement : collection) {
            DataService.getDataSource(xmlElement, hashMap);
        }
        return hashMap;
    }

    private static void getDataSource(XmlElement xmlElement, Map<String, DataSourceConnectionDetails> map) throws Exception {
        DataSourceConnectionDetails dataSourceConnectionDetails = null;
        dataSourceConnectionDetails = new DataSourceConnectionDetails();
        dataSourceConnectionDetails.name = xmlElement.getText("name");
        dataSourceConnectionDetails.engine = Constants.DataSourceEngine.get(xmlElement.getText("engine"));
        dataSourceConnectionDetails.url = xmlElement.getText("url");
        dataSourceConnectionDetails.username = xmlElement.getText("username");
        dataSourceConnectionDetails.password = xmlElement.getText("password");
        map.put(dataSourceConnectionDetails.name, dataSourceConnectionDetails);
    }

    public SystemConfiguration getSystem() {
        return this.system;
    }

    public Constants.DataSourceEngine getDataSourceEngine(String string) {
        return this.dataSources.get((Object)string).engine;
    }

    public File getDataServiceRoot() {
        return this.dataServiceRoot;
    }

    public Timezone getSystemTimezone() {
        return this.overallSystemDeployment.getSystemTimezone();
    }

    public Language getDefaultLanguage() {
        return this.overallSystemDeployment.getDefaultLanguage();
    }

    public Locale getDefaultLocale() {
        return this.overallSystemDeployment.getDefaultLocale();
    }

    public UserSecurityContext authenticate(String string, String string2) {
        UserSecurityContext userSecurityContext = null;
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(3));
        set.add(this.system.getSystemRole("Anyone"));
        set.add(this.system.getSystemRole("AuthenticatedUser"));
        set.add(this.system.getSystemRole("Staff"));
        userSecurityContext = new UserSecurityContext(1L, set);
        return userSecurityContext;
    }

    public XmlElement processRequest(Session session, XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        xmlElement2 = this.operationsManager.processOperation(new OperationContext(this, session), xmlElement);
        return xmlElement2;
    }

    public Connection getRdbmsConnection(String string) throws Exception {
        Connection connection = null;
        DataSourceConnectionDetails dataSourceConnectionDetails = null;
        try {
            dataSourceConnectionDetails = this.dataSources.get(string);
            if (dataSourceConnectionDetails.engine.equals((Object)Constants.DataSourceEngine.MY_SQL)) {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
            }
            connection = DriverManager.getConnection(dataSourceConnectionDetails.url, dataSourceConnectionDetails.username, dataSourceConnectionDetails.password);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (Exception exception) {
            try {
                connection.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        return connection;
    }

    private static class DataSourceConnectionDetails {
        public String name;
        public Constants.DataSourceEngine engine;
        public String url;
        public String username;
        public String password;

        private DataSourceConnectionDetails() {
        }
    }
}

