/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.databasemetadata;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.databasemetadata.Column;
import com.jronimo.engines.databasemetadata.ForeignKey;
import com.jronimo.engines.databasemetadata.ForeignKeys;
import com.jronimo.engines.databasemetadata.PersistenceNameConverter;
import com.jronimo.engines.databasemetadata.PrimaryKey;
import com.jronimo.engines.databasemetadata.Table;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.util.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaMetaData {
    private static final Logger logger = Logger.getLogger(SchemaMetaData.class);
    private Connection connection;
    private Collection<String> ignoreTables;
    private Collection<String> ignoreColumns;
    private PersistenceNameConverter nameConverter;
    private Collection<Table> tables = new ArrayList<Table>();
    private ForeignKeys foreignKeys = new ForeignKeys();

    public SchemaMetaData(Connection connection, Collection<String> collection, Collection<String> collection2, PersistenceNameConverter persistenceNameConverter) {
        this.connection = connection;
        this.ignoreTables = collection;
        this.ignoreColumns = collection2;
        this.nameConverter = persistenceNameConverter;
    }

    public Collection<Table> getTables() {
        return this.tables;
    }

    public ForeignKeys getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isForeignKeyColumn(String string, String string2) {
        return this.foreignKeys.isForeignKeyColumn(string, string2);
    }

    public SchemaMetaData load() throws Exception {
        SchemaMetaData schemaMetaData = null;
        DatabaseMetaData databaseMetaData = null;
        schemaMetaData = this;
        databaseMetaData = this.connection.getMetaData();
        this.loadTables(databaseMetaData);
        return schemaMetaData;
    }

    private void loadTables(DatabaseMetaData databaseMetaData) throws Exception {
        ResultSet resultSet = null;
        String string = null;
        Table table = null;
        resultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
        while (resultSet.next()) {
            string = this.nameConverter.covertTableName(resultSet.getString("TABLE_NAME"));
            if (this.ignoreTables.contains(string)) continue;
            table = new Table(string, resultSet.getString("REMARKS"));
            this.tables.add(table);
            this.detectPrimaryKeyColumns(databaseMetaData, table);
            this.detectForeignKeys(databaseMetaData, table);
            this.loadColumns(databaseMetaData, table);
        }
        CollectionUtils.sortCollection(this.tables);
    }

    private void detectPrimaryKeyColumns(DatabaseMetaData databaseMetaData, Table table) throws Exception {
        PrimaryKey primaryKey = null;
        ResultSet resultSet = null;
        primaryKey = table.getPrimaryKey();
        resultSet = databaseMetaData.getPrimaryKeys(null, null, table.getName());
        while (resultSet.next()) {
            primaryKey.addColumn(this.nameConverter.covertColumnName(resultSet.getString("COLUMN_NAME")));
        }
    }

    private void detectForeignKeys(DatabaseMetaData databaseMetaData, Table table) throws Exception {
        ResultSet resultSet = null;
        ForeignKey foreignKey = null;
        ForeignKey.ColumnMapping columnMapping = null;
        resultSet = databaseMetaData.getExportedKeys(null, null, table.getName());
        while (resultSet.next()) {
            columnMapping = new ForeignKey.ColumnMapping();
            foreignKey = this.foreignKeys.getForeignKey(resultSet.getString("FK_NAME"), resultSet.getString("PKTABLE_NAME"), resultSet.getString("FKTABLE_NAME"));
            columnMapping.primaryKeyColumnName = this.nameConverter.covertColumnName(resultSet.getString("PKCOLUMN_NAME"));
            columnMapping.foreignKeyColumnName = this.nameConverter.covertColumnName(resultSet.getString("FKCOLUMN_NAME"));
            columnMapping.updateCascadeBehaviour = ForeignKey.getCascadeValue(resultSet.getInt("UPDATE_RULE"));
            columnMapping.deleteCascadeBehaviour = ForeignKey.getCascadeValue(resultSet.getInt("DELETE_RULE"));
            foreignKey.addColumnMapping(columnMapping);
        }
    }

    private void loadColumns(DatabaseMetaData databaseMetaData, Table table) throws Exception {
        ResultSet resultSet = null;
        String string = null;
        Column.Struct struct = null;
        Column column = null;
        int n = 0;
        int n2 = 0;
        DataType dataType = null;
        resultSet = databaseMetaData.getColumns(null, null, table.getName(), null);
        while (resultSet.next()) {
            string = this.nameConverter.covertColumnName(resultSet.getString("COLUMN_NAME"));
            if (this.ignoreColumns.contains(string)) continue;
            struct = new Column.Struct();
            struct.name = string;
            struct.index = resultSet.getInt("ORDINAL_POSITION");
            struct.sqlType = resultSet.getString("DATA_TYPE");
            struct.columnTypeDefinition = resultSet.getString("TYPE_NAME");
            struct.columnSize = resultSet.getInt("COLUMN_SIZE");
            struct.radix = resultSet.getInt("NUM_PREC_RADIX");
            struct.allowsNull = resultSet.getBoolean("IS_NULLABLE");
            struct.defaultValue = resultSet.getString("COLUMN_DEF");
            struct.comments = resultSet.getString("REMARKS");
            n = resultSet.getInt("COLUMN_SIZE");
            n2 = resultSet.getInt("DECIMAL_DIGITS");
            dataType = DataType.getDefaultMySqlDataType(struct.columnTypeDefinition);
            if (dataType.supportsCapacity()) {
                struct.columnTypeDefinition = struct.columnTypeDefinition + "(" + n + ")";
            } else if (dataType.supportsPrecisionAndScale()) {
                struct.columnTypeDefinition = struct.columnTypeDefinition + "(" + n + "," + n2 + ")";
            }
            column = new Column(struct);
            table.addColumn(column);
        }
        Collections.sort(table.getColumns());
    }

    public static class ConnectionDetailsStruct {
        public static String connectionUrl;
        public static String username;
        public static String password;
    }
}

