/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel.loader;

import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.loader.ProjectLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.io.File;
import java.util.ArrayList;

public final class SourceLoader {
    private static final Logger logger = Logger.getLogger(SourceLoader.class);
    private Documenter documenter;
    private XmlElement sourceElement;

    public SourceLoader(Documenter documenter, XmlElement xmlElement) {
        this.documenter = documenter;
        this.sourceElement = xmlElement;
    }

    public Source execute() {
        Source source = null;
        String string = null;
        Source.SourceType sourceType = null;
        String string2 = null;
        File file = null;
        ArrayList<Project> arrayList = null;
        Project project = null;
        try {
            source = new Source();
            string = this.sourceElement.getText("id");
            string2 = this.sourceElement.getText("name");
            sourceType = Source.SourceType.FILE_SYSTEM;
            file = new File(this.sourceElement.getText("path"));
            arrayList = new ArrayList<Project>(1);
            for (XmlElement xmlElement : this.sourceElement.getOptionalElements("projects/project")) {
                project = new ProjectLoader(source, new File(file, xmlElement.getText())).execute();
                if (project == null) continue;
                arrayList.add(project);
            }
            source.init(this.documenter, string, sourceType, string2, file, arrayList);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return source;
    }
}

