/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel.loader;

import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.Style;
import com.jronimo.documenter.objectmodel.loader.DocumentLoader;
import com.jronimo.documenter.objectmodel.loader.FootersLoader;
import com.jronimo.documenter.objectmodel.loader.HeadersLoader;
import com.jronimo.documenter.objectmodel.loader.StylesLoader;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectLoader {
    private static final Logger logger = Logger.getLogger(ProjectLoader.class);
    private Source source;
    private File rootDirectory;

    public ProjectLoader(Source source, File file) {
        this.source = source;
        this.rootDirectory = file;
    }

    public ProjectLoader(Source source, String string) {
        this.source = source;
        this.rootDirectory = new File(source.getRootDirectory(), string);
    }

    public Project execute() {
        Project project = null;
        File file = null;
        XmlElement xmlElement = null;
        String string = null;
        int n = 0;
        Constants.Orientation orientation = null;
        Margins margins = null;
        String string2 = null;
        String string3 = null;
        List<Style> list = null;
        List<HeaderFooter> list2 = null;
        List<HeaderFooter> list3 = null;
        List<Document> list4 = null;
        HeaderFooter headerFooter = null;
        HeaderFooter headerFooter2 = null;
        try {
            file = new File(this.rootDirectory, "DocumentationProject.xml");
            if (file.exists()) {
                project = new Project();
                xmlElement = XmlElementFactory.load(file);
                string = xmlElement.getAttributeText("id");
                n = xmlElement.getAttributeInteger("nextId");
                orientation = Constants.Orientation.valueOf(xmlElement.getAttributeText("orientation"));
                margins = new Margins(xmlElement.getAttributeText("margins"));
                string2 = xmlElement.getAttributeText("header");
                string3 = xmlElement.getAttributeText("footer");
                list = new StylesLoader(project, new File(this.rootDirectory, "Styles")).execute();
                list2 = new HeadersLoader(project, new File(this.rootDirectory, "Headers")).execute();
                list3 = new FootersLoader(project, new File(this.rootDirectory, "Footers")).execute();
                list4 = this.loadDocuments(project, xmlElement.getElement("documents"), new File(this.rootDirectory, "Documents"));
                headerFooter = this.getHeaderFooterWithName(list2, string2);
                headerFooter2 = this.getHeaderFooterWithName(list3, string3);
                project.init(this.source, this.rootDirectory.getName(), string, n, orientation, margins, headerFooter, headerFooter2, list, list2, list3, list4);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return project;
    }

    private List<Document> loadDocuments(Parent parent, XmlElement xmlElement, File file) throws Exception {
        ArrayList<Document> arrayList = null;
        Document document = null;
        arrayList = new ArrayList<Document>(1);
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("id")) {
            document = new DocumentLoader(parent, new File(file, xmlElement2.getText())).execute();
            arrayList.add(document);
        }
        return arrayList;
    }

    private HeaderFooter getHeaderFooterWithName(List<HeaderFooter> list, String string) {
        HeaderFooter headerFooter = null;
        for (HeaderFooter headerFooter2 : list) {
            if (!headerFooter2.getName().equals(string)) continue;
            headerFooter = headerFooter2;
            break;
        }
        return headerFooter;
    }
}

