/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel;

import com.jronimo.documenter.ResourceTextIdentifiers;
import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.loader.ProjectLoader;
import com.jronimo.nameformat.SimpleNameFormat;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source
implements Parent,
Comparable<Source> {
    private static final Logger logger = Logger.getLogger(Source.class);
    private Parent parent;
    private String id;
    private SourceType type;
    private String name;
    private File rootDirectory;
    private List<Project> projects;

    public void init(Parent parent, String string, SourceType sourceType, String string2, File file, List<Project> arrayList) {
        this.parent = parent;
        this.id = string;
        this.type = sourceType;
        this.name = string2;
        this.rootDirectory = file;
        this.projects = arrayList == null ? new ArrayList(1) : arrayList;
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String string) {
        this.name = string;
        this.parent.getDocumenter().fireSourceUpdated(this);
    }

    public String getName() {
        return this.name;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void loadProject(String string, boolean bl) {
        Project project = null;
        project = new ProjectLoader(this, new File(this.rootDirectory, string)).execute();
        if (project != null) {
            this.addProject(project, bl);
        }
    }

    public void loadProjects(List<String> list) {
        for (String string : list) {
            this.loadProject(string, false);
        }
        this.parent.getDocumenter().fireSourceUpdated(this);
    }

    public void unloadProject(String string, boolean bl) {
        this.removeProject(this.getProject(string), bl);
    }

    public void unloadProjects(List<String> list) {
        for (String string : list) {
            this.unloadProject(string, false);
        }
        this.parent.getDocumenter().fireSourceUpdated(this);
    }

    private void addProject(Project project, boolean bl) {
        Assert.errorParam(this.hasProject(project.getName()), new ResourceTextPointer((Object)ResourceTextIdentifiers.PROJECT_WITH_NAME_EXISTS, project.getName()));
        this.projects.add(project);
        Collections.sort(this.projects);
        if (bl) {
            this.parent.getDocumenter().fireSourceUpdated(this);
        }
    }

    public void removeProject(Project project, boolean bl) {
        this.projects.remove(project);
        if (bl) {
            this.parent.getDocumenter().fireSourceUpdated(this);
        }
    }

    public boolean hasProject(File file) {
        boolean bl = false;
        for (Project project : this.projects) {
            if (!project.getRootDirectory().equals(file)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasProject(String string) {
        boolean bl = false;
        for (Project project : this.projects) {
            if (!project.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Project getProject(String string) {
        Project project = null;
        for (Project project2 : this.projects) {
            if (!project2.getName().equals(string)) continue;
            project = project2;
            break;
        }
        return project;
    }

    public List<String> getLoadedProjectNames() {
        ArrayList<String> arrayList = null;
        arrayList = new ArrayList<String>(this.projects.size());
        for (Project project : this.projects) {
            arrayList.add(project.getName());
        }
        return arrayList;
    }

    public List<String> getUnloadedProjectNames() {
        ArrayList<String> arrayList = null;
        arrayList = new ArrayList<String>(2);
        for (File file : this.rootDirectory.listFiles()) {
            if (!file.isDirectory() || !new File(file, "DocumentationProject.xml").exists() || this.hasProject(file.getName())) continue;
            arrayList.add(file.getName());
        }
        return arrayList;
    }

    public void appendXmlElement(XmlElement xmlElement) {
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement2 = xmlElement.addElement("source");
        xmlElement2.addElement("type").setText(new SimpleNameFormat(this.type.toString()).getCamelCase());
        xmlElement2.addElement("name").setText(this.name);
        xmlElement2.addElement("path").setText(this.rootDirectory.getPath());
        xmlElement2.addElement("id").setText(this.id);
        xmlElement3 = xmlElement2.addElement("projects");
        for (Project project : this.projects) {
            xmlElement3.addElement("project").setText(project.getName());
        }
    }

    @Override
    public int compareTo(Source source) {
        return this.name.compareTo(source.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    public Documenter getDocumenter() {
        return this.parent.getDocumenter();
    }

    @Override
    public Source getSource() {
        return this;
    }

    @Override
    public Project getProject() {
        return null;
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public Constants.Orientation getOrientation() {
        return null;
    }

    @Override
    public Margins getMargins() {
        return null;
    }

    @Override
    public HeaderFooter getHeader() {
        return null;
    }

    @Override
    public HeaderFooter getFooter() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        FILE_SYSTEM,
        SERVER;

    }
}

