/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.objectmodel;

import com.jronimo.documenter.objectmodel.Constants;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.HeaderFooter;
import com.jronimo.documenter.objectmodel.Margins;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.documenter.objectmodel.loader.SectionLoader;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Section
implements Parent {
    private static final Logger logger = Logger.getLogger(Section.class);
    private File rootDirectory;
    private Parent parent;
    private int id;
    private boolean isChapter;
    private String title;
    private Constants.Orientation orientation;
    private Margins margins;
    private HeaderFooter header;
    private HeaderFooter footer;
    private boolean toc;
    private boolean newPage;
    private List<Section> sections;

    public void init(File file, Parent parent, int n, boolean bl, String string, Constants.Orientation orientation, Margins margins, HeaderFooter headerFooter, HeaderFooter headerFooter2, boolean bl2, boolean bl3, List<Section> list) {
        this.rootDirectory = file;
        this.parent = parent;
        this.id = n;
        this.isChapter = bl;
        this.title = string;
        this.orientation = orientation;
        this.margins = margins;
        this.header = headerFooter;
        this.footer = headerFooter2;
        this.toc = bl2;
        this.newPage = bl3;
        this.sections = list;
    }

    public File getFile() {
        return new File(this.getRootDirectory(), this.id + ".xml");
    }

    public void setId(int n) {
        if (this.id != n) {
            this.getFile().renameTo(new File(this.getFile().getParentFile(), n + ".xml"));
            this.id = n;
        }
    }

    public int getId() {
        return this.id;
    }

    public void isChapter(boolean bl, boolean bl2) {
        this.isChapter = bl;
        this.saveFile(bl2);
    }

    public boolean isChapter() {
        return this.isChapter;
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        this.saveFile(bl);
    }

    public String getTitle() {
        return this.title;
    }

    public void setOrientation(Constants.Orientation orientation) {
        this.orientation = orientation;
        this.saveFile(true);
    }

    @Override
    public Constants.Orientation getOrientation() {
        Constants.Orientation orientation = null;
        orientation = this.orientation == null ? this.parent.getOrientation() : this.orientation;
        return orientation;
    }

    public void setMargins(Margins margins) {
        this.margins = margins;
        this.saveFile(true);
    }

    @Override
    public Margins getMargins() {
        Margins margins = null;
        margins = this.margins == null ? this.parent.getMargins() : this.margins;
        return margins;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getHeader() {
        HeaderFooter headerFooter = null;
        headerFooter = this.header == null ? this.parent.getHeader() : this.header;
        return headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        this.saveFile(true);
    }

    @Override
    public HeaderFooter getFooter() {
        HeaderFooter headerFooter = null;
        headerFooter = this.footer == null ? this.parent.getFooter() : this.footer;
        return headerFooter;
    }

    public void setToc(boolean bl) {
        this.toc = bl;
        this.saveFile(true);
    }

    public boolean getToc() {
        return this.toc;
    }

    public void setNewPage(boolean bl) {
        this.newPage = bl;
        this.saveFile(true);
    }

    public boolean getNewPage() {
        return this.newPage;
    }

    public void setContent(String string, String string2) {
        if (string != null) {
            this.title = string;
        }
        if (string2 != null) {
            this.saveFile(string2, true);
        }
    }

    public String getContent() {
        return XmlElementFactory.load(this.getFile()).getText("content");
    }

    public boolean hasSections() {
        return !this.sections.isEmpty();
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public List<String> getSectionTitles() {
        ArrayList<String> arrayList = null;
        arrayList = new ArrayList<String>(this.sections.size());
        for (Section section : this.sections) {
            arrayList.add(section.getTitle());
        }
        return arrayList;
    }

    public void addSection(File file) {
        this.addSection(file, this.sections.size());
    }

    public void addSection(File file, int n) {
        String string = null;
        int n2 = 0;
        string = file.getName();
        string = string.substring(0, string.lastIndexOf("."));
        n2 = Integer.parseInt(string);
        this.addSection(new SectionLoader(this, file, this.parent.getDocument().getHeaders(), this.parent.getDocument().getFooters()).execute(), n);
    }

    private void addSection(Section section, int n) {
        this.sections.add(n, section);
        this.saveFile(true);
    }

    public void deleteSections(Collection<String> collection) {
        for (String string : collection) {
            this.deleteSection(this.getSection(string), false);
        }
        this.saveFile(true);
    }

    public void deleteSection(Section section) {
        this.sections.remove(section);
        section.delete();
        this.saveFile(true);
    }

    private void deleteSection(Section section, boolean bl) {
        this.sections.remove(section);
        section.delete();
        if (bl) {
            this.saveFile(true);
        }
    }

    public boolean hasSection(String string) {
        boolean bl = false;
        for (Section section : this.sections) {
            if (!section.getTitle().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Section getSection(String string) {
        Section section = null;
        for (Section section2 : this.sections) {
            if (!section2.getTitle().equals(string)) continue;
            section = section2;
            break;
        }
        return section;
    }

    public void changeSectionOrder(List<Section> list) {
        ArrayList<Section> arrayList = null;
        boolean bl = false;
        arrayList = new ArrayList<Section>(this.sections.size());
        for (Section section : list) {
            if (!this.sections.contains(section)) continue;
            arrayList.add(section);
        }
        this.sections.clear();
        for (Section section : arrayList) {
            this.sections.add(section);
        }
        this.saveFile(true);
    }

    public int hashCode() {
        return this.title.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return this.title;
    }

    public void saveFile(boolean bl) {
        this.saveFile(null, bl);
    }

    private void saveFile(String string, boolean bl) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        xmlElement = XmlElementFactory.load(this.getFile());
        xmlElement.setAttributeText("title", this.title);
        if (this.orientation == null) {
            xmlElement.removeAttribute("orientation");
        } else {
            xmlElement.setAttributeText("orientation", this.orientation.toString());
        }
        if (this.margins == null) {
            xmlElement.removeAttribute("margins");
        } else {
            xmlElement.setAttributeText("margins", this.margins.toString());
        }
        if (this.header == null) {
            xmlElement.removeAttribute("header");
        } else {
            xmlElement.setAttributeText("header", this.header.getName());
        }
        if (this.footer == null) {
            xmlElement.removeAttribute("footer");
        } else {
            xmlElement.setAttributeText("footer", this.footer.getName());
        }
        xmlElement.setAttributeBoolean("isChapter", this.isChapter);
        xmlElement.setAttributeBoolean("toc", this.toc);
        xmlElement.setAttributeBoolean("newPage", this.newPage);
        if (string != null) {
            xmlElement.getElement("content").setText(string);
        }
        xmlElement.removeElement("sections");
        xmlElement2 = xmlElement.addElement("sections");
        for (Section section : this.sections) {
            xmlElement2.addElement("id").setInteger(section.id);
        }
        xmlElement.save(this.getFile());
        if (bl) {
            this.parent.getDocumenter().fireSectionUpdated(this);
        }
    }

    public void delete() {
        File file = null;
        file = new File(this.parent.getDocument().getDeletionBinDirectory(), "DeletedSections/" + this.getFile().getName());
        FileMethods.copyFileTo(this.getFile(), file);
        this.getFile().delete();
        for (Section section : this.sections) {
            section.delete();
        }
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public File getRootDirectory() {
        File file = null;
        file = this.rootDirectory == null ? (this.parent instanceof Document ? new File(this.parent.getRootDirectory(), "Sections") : this.parent.getRootDirectory()) : this.rootDirectory;
        return file;
    }

    @Override
    public Documenter getDocumenter() {
        return this.parent.getDocumenter();
    }

    @Override
    public Source getSource() {
        return this.parent.getSource();
    }

    @Override
    public Project getProject() {
        return this.parent.getProject();
    }

    @Override
    public Document getDocument() {
        return this.parent.getDocument();
    }
}

