/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.BlankContentPanel;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.FileMethods;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.nodes.AbstractNode;
import com.jronimo.documenter.gui.nodes.Methods;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.nodes.ProjectNode;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public final class SourceNode
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(SourceNode.class);
    private Source source;
    private JMenuItem createProjectMenuItem;
    private JMenuItem loadProjectsMenuItem;
    private JMenuItem unloadProjectsMenuItem;
    private JMenuItem renameSourceMenuItem;
    private JMenuItem removeSourceMenuItem;
    private JPopupMenu popupMenu;

    public SourceNode(ContainerManager containerManager, Source source) {
        super(containerManager, source, "Source - " + source.getName(), true, new Class[]{ProjectNode.class});
        this.source = source;
        this.init();
    }

    private void init() {
        List<Project> list = null;
        ActionListenerImpl actionListenerImpl = null;
        list = this.source.getProjects();
        if (list.isEmpty()) {
            this.add(this.dummyChildNode);
        } else {
            for (Project project : list) {
                this.add(new ProjectNode(this.containerManager, project));
            }
        }
        actionListenerImpl = new ActionListenerImpl();
        this.createProjectMenuItem = new JMenuItem("Create new project...");
        this.createProjectMenuItem.addActionListener(actionListenerImpl);
        this.loadProjectsMenuItem = new JMenuItem("Add existing projects to display...");
        this.loadProjectsMenuItem.addActionListener(actionListenerImpl);
        this.unloadProjectsMenuItem = new JMenuItem("Remove projects from display...");
        this.unloadProjectsMenuItem.addActionListener(actionListenerImpl);
        this.renameSourceMenuItem = new JMenuItem("Rename source...");
        this.renameSourceMenuItem.addActionListener(actionListenerImpl);
        this.removeSourceMenuItem = new JMenuItem("Remove source...");
        this.removeSourceMenuItem.addActionListener(actionListenerImpl);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createProjectMenuItem);
        this.popupMenu.add(this.loadProjectsMenuItem);
        this.popupMenu.add(this.unloadProjectsMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.renameSourceMenuItem);
        this.popupMenu.add(this.removeSourceMenuItem);
        this.completeContextMenu(this.popupMenu);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
    }

    DefaultMutableTreeNode createChildNode(Object object) {
        return new ProjectNode(this.containerManager, (Project)object);
    }

    public String getIdPath() {
        return ((Node)((Object)this.getParent())).getIdPath() + "/" + this.source.getId();
    }

    public void setSelected() {
        if (this.containerManager.getCurrentNode() != this) {
            this.containerManager.setContentPanel(new BlankContentPanel(this, this.source.getName()));
        }
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void drop(TreeComponent.DropData dropData) {
    }

    private void createLocalProject() {
        String string = null;
        File file = null;
        File file2 = null;
        String string2 = null;
        string = Methods.getNewProjectNameFromUser(this.source, null);
        if (string != null) {
            file = new File(this.source.getRootDirectory(), string);
            FileMethods.copyDirectoryContentsTo(new File(ApplicationManager.getInstance().getApplicationFolder(), "templates/Project"), file);
            FileMethods.deleteSvnDirectories(file);
            file2 = new File(file, "DocumentationProject.xml");
            string2 = FileMethods.readTextFile(file2);
            ApplicationManager.getInstance().getDocumenter();
            string2 = string2.replace("projectId", Documenter.generateRandomId());
            FileMethods.writeTextFile(file2, string2);
            this.source.loadProject(string, true);
            ApplicationManager.getInstance().setStatusMessage("Project successfully created.");
        }
    }

    private void loadProjects() {
        List<String> list = null;
        String string = null;
        list = PopupFactory.showListSelectionPopup(Frame.getInstance(), "Select Projects To Show", 2, this.source.getUnloadedProjectNames(), null);
        if (list != null && list.size() > 0) {
            this.source.loadProjects(list);
            string = list.size() == 1 ? "Project" : "Projects";
            ApplicationManager.getInstance().setStatusMessage(string + " successfully loaded.");
        }
    }

    private void unloadProjects() {
        List<String> list = null;
        String string = null;
        list = PopupFactory.showListSelectionPopup(Frame.getInstance(), "Select Projects To Hide", 2, this.source.getLoadedProjectNames(), null);
        if (list != null && list.size() > 0) {
            this.source.unloadProjects(list);
            string = list.size() == 1 ? "Project" : "Projects";
            ApplicationManager.getInstance().setStatusMessage(string + " successfully removed.");
        }
    }

    private void removeSource() {
        boolean bl = true;
        bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Remove Source", "Are you sure you want to remove this Source \"" + this.source.getName() + "\" from the Navigation Tree?\n\nNo content will be deleted.\n");
        if (bl && ApplicationManager.getInstance().clearSelectionFromEditors(this, true, true)) {
            this.source.getDocumenter().removeSource(this.source);
            ApplicationManager.getInstance().setStatusMessage("Source successfully removed: " + this.source.getName());
        }
    }

    private void renameSource() {
        String string = null;
        string = PopupFactory.showUserInputPopup(Frame.getInstance(), "Rename Source", true, "Source Name", this.source.getName());
        if (string != null) {
            this.source.setName(string);
            ApplicationManager.getInstance().setStatusMessage("Source successfully renamed: " + string);
        }
    }

    private void sourceUpdated(Source source) {
        if (this.source == source) {
            this.setText("Source - " + source.getName());
            this.update(source.getProjects(), true);
        }
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == SourceNode.this.createProjectMenuItem) {
                SourceNode.this.createLocalProject();
            } else if (object == SourceNode.this.loadProjectsMenuItem) {
                SourceNode.this.loadProjects();
            } else if (object == SourceNode.this.unloadProjectsMenuItem) {
                SourceNode.this.unloadProjects();
            } else if (object == SourceNode.this.renameSourceMenuItem) {
                SourceNode.this.renameSource();
            } else if (object == SourceNode.this.removeSourceMenuItem) {
                SourceNode.this.removeSource();
            }
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void sourceUpdated(Documenter.Event event) {
            SourceNode.this.sourceUpdated(event.getSource());
        }
    }
}

