/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.EditorPane;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.nodes.AbstractNode;
import com.jronimo.documenter.gui.nodes.Methods;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.popups.DragAndDropPopup;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Parent;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.swing.DisplayOptions;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public final class SectionNode
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(SectionNode.class);
    private Section section;
    private JMenuItem createPeerSectionBeforeMenuItem;
    private JMenuItem createPeerSectionAfterMenuItem;
    private JMenuItem createChildSectionMenuItem;
    private JMenuItem reorderChildSectionsMenuItem;
    private JMenuItem deleteChildSectionsMenuItem;
    private JMenuItem deleteSectionMenuItem;
    private JPopupMenu popupMenu;

    public SectionNode(ContainerManager containerManager, Section section) {
        super(containerManager, section, section.isChapter() ? "Chapter - " + section.getTitle() : "Section - " + section.getTitle(), true, new Class[]{SectionNode.class});
        this.section = section;
        this.init();
    }

    private void init() {
        List<Section> list = null;
        String string = null;
        ActionListenerImpl actionListenerImpl = null;
        list = this.section.getSections();
        if (list.isEmpty()) {
            this.setAllowsChildren(false);
        } else {
            this.setAllowsChildren(true);
            for (Section section : list) {
                this.add(new SectionNode(this.containerManager, section));
            }
        }
        string = this.section.isChapter() ? "chapter" : "section";
        actionListenerImpl = new ActionListenerImpl();
        this.createPeerSectionBeforeMenuItem = new JMenuItem("Create peer " + string + " before...");
        this.createPeerSectionBeforeMenuItem.addActionListener(actionListenerImpl);
        this.createPeerSectionAfterMenuItem = new JMenuItem("Create peer " + string + " after...");
        this.createPeerSectionAfterMenuItem.addActionListener(actionListenerImpl);
        this.createChildSectionMenuItem = new JMenuItem("Create child section...");
        this.createChildSectionMenuItem.addActionListener(actionListenerImpl);
        this.reorderChildSectionsMenuItem = new JMenuItem("Reorder child sections...");
        this.reorderChildSectionsMenuItem.addActionListener(actionListenerImpl);
        this.deleteChildSectionsMenuItem = new JMenuItem("Delete child sections...");
        this.deleteChildSectionsMenuItem.addActionListener(actionListenerImpl);
        this.deleteSectionMenuItem = new JMenuItem("Delete " + string + "...");
        this.deleteSectionMenuItem.addActionListener(actionListenerImpl);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createPeerSectionBeforeMenuItem);
        this.popupMenu.add(this.createPeerSectionAfterMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createChildSectionMenuItem);
        this.popupMenu.add(this.reorderChildSectionsMenuItem);
        this.popupMenu.add(this.deleteChildSectionsMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.deleteSectionMenuItem);
        this.completeContextMenu(this.popupMenu);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
    }

    DefaultMutableTreeNode createChildNode(Object object) {
        return new SectionNode(this.containerManager, (Section)object);
    }

    public Section getChapter() {
        return this.section;
    }

    public Section getSection() {
        return this.section;
    }

    public String getIdPath() {
        return ((Node)((Object)this.getParent())).getIdPath() + "/" + this.section.getId();
    }

    public void setSelected() {
        Thread thread = null;
        if (this.containerManager.getCurrentNode() != this) {
            thread = new Thread(new Runnable(){

                public void run() {
                    SectionNode.this.containerManager.setContentPanel(new EditorPane(SectionNode.this, SectionNode.this.section));
                }
            });
            SwingUtilities.invokeLater(thread);
        }
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void drop(TreeComponent.DropData dropData) {
        SectionNode sectionNode = null;
        boolean bl = true;
        boolean bl2 = false;
        DragAndDropPopup.ConfigStruct configStruct = null;
        DragAndDropPopup.ResultStruct resultStruct = null;
        String string = null;
        boolean bl3 = false;
        Parent parent = null;
        int n = 0;
        if (dropData.getNode() instanceof SectionNode && (sectionNode = (SectionNode)dropData.getNode()).getContainerManager().saveCurrentContent()) {
            if (sectionNode.containsNode(this)) {
                bl = false;
            } else {
                bl2 = dropData.isMove();
            }
            configStruct = new DragAndDropPopup.ConfigStruct();
            configStruct.sourceValue = "Section - " + sectionNode.getSection().getTitle();
            configStruct.targetValue = "Section - " + this.section.getTitle();
            configStruct.nameLabelText = "Title";
            configStruct.nameValue = sectionNode.getSection().getTitle();
            configStruct.insertBeforeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.SHOW_UNSELECTED;
            configStruct.insertAfterDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.SHOW_SELECTED;
            configStruct.addAsChildDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.SHOW_UNSELECTED;
            configStruct.mergeDisplayChoice = DisplayOptions.RadioButtonDisplayOptions.HIDE;
            configStruct.deleteSourceDisplayOption = bl ? (bl2 ? DisplayOptions.CheckBoxDisplayOptions.SHOW_CHECKED : DisplayOptions.CheckBoxDisplayOptions.SHOW_UNCHECKED) : DisplayOptions.CheckBoxDisplayOptions.DISABLE_UNCHECKED;
            configStruct.goToDisplayOption = DisplayOptions.CheckBoxDisplayOptions.HIDE;
            resultStruct = PopupFactory.showDragAndDropPopup(Frame.getInstance(), configStruct);
            if (resultStruct != null) {
                string = resultStruct.name;
                bl3 = resultStruct.deleteSource;
                if (resultStruct.action == DragAndDropPopup.Action.ADD_AS_CHILD) {
                    parent = this.section;
                    n = this.section.getSections().size();
                } else {
                    parent = this.section.getParent();
                    n = this.section.isChapter() ? this.section.getDocument().getChapters().indexOf(this.section) : ((Section)this.section.getParent()).getSections().indexOf(this.section);
                    if (resultStruct.action == DragAndDropPopup.Action.INSERT_AFTER) {
                        ++n;
                    }
                }
                if (bl3 && ApplicationManager.getInstance().clearSelectionFromEditors(sectionNode, true, true)) {
                    Methods.moveSection(sectionNode.getSection(), parent, string, n);
                } else {
                    Methods.cloneSection(sectionNode.getSection(), parent, string, n);
                }
            }
        }
    }

    private void createPeerSectionBefore() {
        Document document = null;
        if (this.section.isChapter()) {
            document = this.section.getDocument();
            Methods.createChapter(document, document.getChapters().indexOf(this.section));
        } else {
            Methods.createSection((Section)this.section.getParent(), ((Section)this.section.getParent()).getSections().indexOf(this.section));
        }
    }

    private void createPeerSectionAfter() {
        Document document = null;
        if (this.section.isChapter()) {
            document = this.section.getDocument();
            Methods.createChapter(document, document.getChapters().indexOf(this.section) + 1);
        } else {
            Methods.createSection((Section)this.section.getParent(), ((Section)this.section.getParent()).getSections().indexOf(this.section) + 1);
        }
    }

    private void createChildSection() {
        Methods.createSection(this.section, this.section.getSections().size());
    }

    private void reorderSections() {
        List list = null;
        if (ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true) && (list = PopupFactory.showReorderPopup(Frame.getInstance(), "Reorder Sections", this.section.getSections())) != null && list.size() > 1) {
            this.section.changeSectionOrder(list);
            ApplicationManager.getInstance().setStatusMessage("Sections successfully reordered.");
        }
    }

    private void deleteSections() {
        List<String> list = null;
        String string = null;
        boolean bl = true;
        list = PopupFactory.showListSelectionPopup(Frame.getInstance(), "Select Sections To Delete", 2, this.section.getSectionTitles(), null);
        if (list != null && list.size() > 0) {
            string = list.size() == 1 ? "Section" : "Sections";
            bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Delete " + string, "Are you sure you want to delete the selected " + string + "?\n\nContent will be deleted and a copy will be placed in the document Deleted Bin.\n");
            if (bl) {
                bl = ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true);
            }
            if (bl) {
                this.section.deleteSections(list);
                ApplicationManager.getInstance().setStatusMessage(string + " successfully deleted.");
            }
        }
    }

    private void deleteSection() {
        String string = null;
        String string2 = null;
        boolean bl = true;
        if (this.section.isChapter()) {
            string = "Chapter";
            string2 = "chapter";
        } else {
            string = "Section";
            string2 = "section";
        }
        bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Delete " + string, "Are you sure you want to delete this " + string2 + " \"" + this.section.getTitle() + "\"?\n\nContent will be deleted and a copy will be placed in the document Deleted Bin.\n");
        if (bl && ApplicationManager.getInstance().clearSelectionFromEditors(this, true, true)) {
            if (this.section.isChapter()) {
                ((Document)this.section.getParent()).deleteChapter(this.section);
            } else {
                ((Section)this.section.getParent()).deleteSection(this.section);
            }
            ApplicationManager.getInstance().setStatusMessage(string + " successfully deleted: " + this.section.getTitle());
        }
    }

    private void sectionUpdated(Section section) {
        if (this.section == section) {
            if (this.section.isChapter()) {
                this.setText("Chapter - " + section.getTitle());
            } else {
                this.setText("Section - " + section.getTitle());
            }
            this.update(section.getSections(), false);
        }
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == SectionNode.this.createPeerSectionBeforeMenuItem) {
                SectionNode.this.createPeerSectionBefore();
            } else if (object == SectionNode.this.createPeerSectionAfterMenuItem) {
                SectionNode.this.createPeerSectionAfter();
            } else if (object == SectionNode.this.createChildSectionMenuItem) {
                SectionNode.this.createChildSection();
            } else if (object == SectionNode.this.reorderChildSectionsMenuItem) {
                SectionNode.this.reorderSections();
            } else if (object == SectionNode.this.deleteChildSectionsMenuItem) {
                SectionNode.this.deleteSections();
            } else if (object == SectionNode.this.deleteSectionMenuItem) {
                SectionNode.this.deleteSection();
            }
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void sectionUpdated(Documenter.Event event) {
            SectionNode.this.sectionUpdated(event.getSection());
        }
    }
}

