/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ApplicationProperties;
import com.jronimo.documenter.gui.BlankContentPanel;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.nodes.AbstractNode;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.nodes.SourceNode;
import com.jronimo.documenter.gui.popups.AddLocalSourcePopup;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class RootNode
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(RootNode.class);
    private JMenuItem addLocalMenuItem;
    private JMenuItem addRemoteMenuItem;
    private JPopupMenu popupMenu;

    public RootNode(ContainerManager containerManager) {
        super(containerManager, null, "Documentation Sources", true, null);
        this.init();
    }

    private void init() {
        List<Source> list = null;
        ActionListenerImpl actionListenerImpl = null;
        list = ApplicationManager.getInstance().getDocumenter().getSources();
        for (Source source : list) {
            this.add(new SourceNode(this.containerManager, source));
        }
        actionListenerImpl = new ActionListenerImpl();
        this.addLocalMenuItem = new JMenuItem("Add local source...");
        this.addLocalMenuItem.addActionListener(actionListenerImpl);
        this.addRemoteMenuItem = new JMenuItem("Add remote source...");
        this.addRemoteMenuItem.addActionListener(actionListenerImpl);
        this.addRemoteMenuItem.setEnabled(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.addLocalMenuItem);
        this.popupMenu.add(this.addRemoteMenuItem);
        this.completeContextMenu(this.popupMenu);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
    }

    DefaultMutableTreeNode createChildNode(Object object) {
        return new SourceNode(this.containerManager, (Source)object);
    }

    public Node findNodeWithIdPath(String string) {
        return this.findNodeWithIdPath(this, string);
    }

    private Node findNodeWithIdPath(Node node, String string) {
        Node node2 = null;
        Enumeration<TreeNode> enumeration = null;
        if (node.getIdPath().equals(string)) {
            node2 = node;
        } else {
            enumeration = ((DefaultMutableTreeNode)((Object)node)).children();
            while (enumeration.hasMoreElements() && (node2 = this.findNodeWithIdPath((Node)((Object)enumeration.nextElement()), string)) == null) {
            }
        }
        return node2;
    }

    public String getIdPath() {
        return "";
    }

    public void setSelected() {
        if (this.containerManager.getCurrentNode() != this) {
            this.containerManager.setContentPanel(new BlankContentPanel(this, "Editor"));
        }
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void drop(TreeComponent.DropData dropData) {
    }

    private void addLocalSource() {
        AddLocalSourcePopup.ResultStruct resultStruct = null;
        Source source = null;
        boolean bl = true;
        resultStruct = PopupFactory.showAddLocalSourcePopup(Frame.getInstance(), "Source Directory", ApplicationProperties.getInstance().getLastDirectoryVisited());
        if (resultStruct != null) {
            ApplicationProperties.getInstance().setLastDirectoryVisited(resultStruct.directory);
            if (ApplicationManager.getInstance().getDocumenter().hasSource(resultStruct.name)) {
                PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Source Already Exists", "A source with the name \"" + resultStruct.name + "\" is already loaded.");
                bl = false;
            } else if (ApplicationManager.getInstance().getDocumenter().hasSource(resultStruct.directory)) {
                source = ApplicationManager.getInstance().getDocumenter().getSource(resultStruct.directory);
                PopupFactory.showPopupErrorMessage(Frame.getInstance(), "Source Already Exists", "A source with the selected directory is already loaded.\n\n" + source.getName() + "\n\n" + resultStruct.directory.getPath());
                bl = false;
            }
            if (bl) {
                try {
                    ApplicationManager.getInstance().getDocumenter().addSource(Source.SourceType.FILE_SYSTEM, resultStruct.name, resultStruct.directory);
                    ApplicationManager.getInstance().setStatusMessage("Source successfully added: " + resultStruct.name);
                }
                catch (Exception exception) {
                    throw new UnexpectedErrorException(exception);
                }
            }
        }
    }

    private void addRemoteSource() {
    }

    private void sourcesUpdated() {
        this.update(ApplicationManager.getInstance().getDocumenter().getSources(), true);
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == RootNode.this.addLocalMenuItem) {
                RootNode.this.addLocalSource();
            } else if (object == RootNode.this.addRemoteMenuItem) {
                RootNode.this.addRemoteSource();
            }
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void sourcesUpdated(Documenter.Event event) {
            RootNode.this.sourcesUpdated();
        }
    }
}

