/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui.nodes;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.BlankContentPanel;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.Frame;
import com.jronimo.documenter.gui.PopupFactory;
import com.jronimo.documenter.gui.nodes.AbstractNode;
import com.jronimo.documenter.gui.nodes.DocumentNode;
import com.jronimo.documenter.gui.nodes.Methods;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.objectmodel.Document;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.documenter.objectmodel.Project;
import com.jronimo.documenter.objectmodel.Source;
import com.jronimo.swing.TreeComponent;
import com.jronimo.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public final class ProjectNode
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(ProjectNode.class);
    private Project project;
    private JMenuItem createDocumentMenuItem;
    private JMenuItem reorderDocumentsMenuItem;
    private JMenuItem deleteDocumentsMenuItem;
    private JMenuItem renameProjectMenuItem;
    private JMenuItem cloneProjectMenuItem;
    private JMenuItem removeProjectMenuItem;
    private JPopupMenu popupMenu;

    public ProjectNode(ContainerManager containerManager, Project project) {
        super(containerManager, project, "Project - " + project.getName(), true, new Class[]{DocumentNode.class});
        this.project = project;
        this.init();
    }

    private void init() {
        List<Document> list = null;
        ActionListenerImpl actionListenerImpl = null;
        list = this.project.getDocuments();
        if (list.isEmpty()) {
            this.add(this.dummyChildNode);
        } else {
            for (Document document : list) {
                this.add(new DocumentNode(this.containerManager, document));
            }
        }
        actionListenerImpl = new ActionListenerImpl();
        this.createDocumentMenuItem = new JMenuItem("Create new document...");
        this.createDocumentMenuItem.addActionListener(actionListenerImpl);
        this.reorderDocumentsMenuItem = new JMenuItem("Reorder documents...");
        this.reorderDocumentsMenuItem.addActionListener(actionListenerImpl);
        this.deleteDocumentsMenuItem = new JMenuItem("Delete documents...");
        this.deleteDocumentsMenuItem.addActionListener(actionListenerImpl);
        this.renameProjectMenuItem = new JMenuItem("Rename project...");
        this.renameProjectMenuItem.addActionListener(actionListenerImpl);
        this.cloneProjectMenuItem = new JMenuItem("Clone project...");
        this.cloneProjectMenuItem.addActionListener(actionListenerImpl);
        this.removeProjectMenuItem = new JMenuItem("Remove project from display...");
        this.removeProjectMenuItem.addActionListener(actionListenerImpl);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createDocumentMenuItem);
        this.popupMenu.add(this.reorderDocumentsMenuItem);
        this.popupMenu.add(this.deleteDocumentsMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.renameProjectMenuItem);
        this.popupMenu.add(this.cloneProjectMenuItem);
        this.popupMenu.add(this.removeProjectMenuItem);
        this.completeContextMenu(this.popupMenu);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
    }

    DefaultMutableTreeNode createChildNode(Object object) {
        return new DocumentNode(this.containerManager, (Document)object);
    }

    public Project getProject() {
        return this.project;
    }

    public String getIdPath() {
        return ((Node)((Object)this.getParent())).getIdPath() + "/" + this.project.getId();
    }

    public void setSelected() {
        if (this.containerManager.getCurrentNode() != this) {
            this.containerManager.setContentPanel(new BlankContentPanel(this, this.project.getName()));
        }
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void drop(TreeComponent.DropData dropData) {
    }

    private void createDocument() {
        Methods.createDocument(this.project, this.project.getDocuments().size());
    }

    private void reorderDocuments() {
        List list = null;
        if (ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true) && (list = PopupFactory.showReorderPopup(Frame.getInstance(), "Reorder Documents", this.project.getDocuments())) != null && list.size() > 1) {
            this.project.changeDocumentOrder(list);
            ApplicationManager.getInstance().setStatusMessage("Documents successfully reordered.");
        }
    }

    private void deleteDocuments() {
        List<String> list = null;
        String string = null;
        boolean bl = true;
        list = PopupFactory.showListSelectionPopup(Frame.getInstance(), "Select Documents To Delete", 2, this.project.getDocumentNames(), null);
        if (list != null && list.size() > 0) {
            string = list.size() == 1 ? "Document" : "Documents";
            bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Delete " + string, "Are you sure you want to delete the selected " + string + "?\n\nContent will be deleted and a copy will be placed in the project Deleted Bin.\n");
            if (bl) {
                bl = ApplicationManager.getInstance().clearSelectionFromEditors(this, false, true);
            }
            if (bl) {
                this.project.deleteDocuments(list, true);
                ApplicationManager.getInstance().setStatusMessage(string + " successfully deleted.");
            }
        }
    }

    private void renameProject() {
        Source source = null;
        String string = null;
        source = this.project.getSource();
        string = Methods.moveProject(this.project, source, true);
        if (string != null) {
            ApplicationManager.getInstance().setStatusMessage("Project successfully renamed: " + string);
        }
    }

    private void cloneProject() {
        String string = null;
        string = Methods.cloneProject(this.project, this.project.getSource(), true);
        if (string != null) {
            ApplicationManager.getInstance().setStatusMessage("Project successfully created: " + string);
        }
    }

    private void removeProject() {
        boolean bl = true;
        bl = PopupFactory.showPopupQuestionMessage(Frame.getInstance(), "Confirm - Remove Project", "Are you sure you want to remove the Project \"" + this.project.getName() + "\" from the display?\n\nNo content will be deleted.\n");
        if (bl && ApplicationManager.getInstance().clearSelectionFromEditors(this, true, true)) {
            ((Source)this.project.getParent()).unloadProject(this.project.getName(), true);
            ApplicationManager.getInstance().setStatusMessage("Project successfully removed.");
        }
    }

    private void projectUpdated(Project project) {
        if (this.project == project) {
            this.setText("Project - " + project.getName());
            this.update(project.getDocuments(), true);
        }
    }

    public class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            object = actionEvent.getSource();
            if (object == ProjectNode.this.createDocumentMenuItem) {
                ProjectNode.this.createDocument();
            } else if (object == ProjectNode.this.reorderDocumentsMenuItem) {
                ProjectNode.this.reorderDocuments();
            } else if (object == ProjectNode.this.deleteDocumentsMenuItem) {
                ProjectNode.this.deleteDocuments();
            } else if (object == ProjectNode.this.renameProjectMenuItem) {
                ProjectNode.this.renameProject();
            } else if (object == ProjectNode.this.cloneProjectMenuItem) {
                ProjectNode.this.cloneProject();
            } else if (object == ProjectNode.this.removeProjectMenuItem) {
                ProjectNode.this.removeProject();
            }
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void projectUpdated(Documenter.Event event) {
            ProjectNode.this.projectUpdated(event.getProject());
        }
    }
}

