/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ContainerManager;
import com.jronimo.documenter.gui.EditorPanel;
import com.jronimo.documenter.gui.Methods;
import com.jronimo.documenter.objectmodel.Documenter;
import com.jronimo.swing.FixedSizePanel;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.StatusMessage;
import com.jronimo.util.Logger;
import com.jronimo.util.MethodInvoker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class RootPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(RootPanel.class);
    private static final Cursor cursor = new Cursor(3);
    private ContainerManagerListener containerManagerListener;
    private ChangeListener changeListener;
    private JTabbedPane tabbedPane;
    private JPanel addPanel;
    private JPanel statusBarPanel;
    private JLabel statusLabel;
    private MethodInvoker.Thread statusMessageThread;

    public RootPanel() {
        this.initializeEventHandlers();
        this.initializeComponents();
        this.initializeContainers();
        ApplicationManager.getInstance().setRootPanel(this);
        ApplicationManager.getInstance().getDocumenter().addListener(new DocumenterListener());
        ApplicationManager.getInstance().addListener(new ApplicationManagerListener());
    }

    private void initializeEventHandlers() {
        this.containerManagerListener = new ContainerManagerListener();
        this.changeListener = new ChangeListenerImpl();
    }

    private void initializeComponents() {
        Object var1_1 = null;
        this.addPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this.changeListener);
        this.statusBarPanel = new FixedSizePanel(0, 25);
        this.statusBarPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setPreferredSize(new Dimension(0, 25));
        this.statusLabel.setBorder(BorderFactory.createBevelBorder(1));
    }

    private void initializeContainers() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.tabbedPane;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.statusLabel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    private void disableAll() {
        this.setCursor(cursor);
    }

    private void enableAll() {
        this.setCursor(null);
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        String string = null;
        MethodInvoker methodInvoker = null;
        if (this.statusMessageThread != null) {
            this.statusMessageThread.cancel();
            this.statusMessageThread = null;
        }
        if (statusMessage == null) {
            statusMessage = new StatusMessage();
        }
        if ((string = statusMessage.getMessage()) == null || string.length() == 0) {
            string = " ";
        }
        if (statusMessage.isError()) {
            this.statusLabel.setForeground(Color.RED);
        } else {
            this.statusLabel.setForeground(Color.BLACK);
        }
        this.statusLabel.setText(" " + string);
        if (statusMessage.beep()) {
            Methods.beep();
        }
        if (statusMessage.getFadeAfter() > 0L) {
            methodInvoker = new MethodInvoker(this.getClass(), this, "setStatusMessage", null, new Object[]{new StatusMessage()});
            this.statusMessageThread = new MethodInvoker.Thread(methodInvoker, statusMessage.getFadeAfter());
            this.statusMessageThread.start();
        }
    }

    public int getCurrentTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEditor(ContainerManager containerManager) {
        try {
            this.tabbedPane.removeChangeListener(this.changeListener);
            containerManager.addListener(this.containerManagerListener);
            this.tabbedPane.remove(this.addPanel);
            this.tabbedPane.add(containerManager.getEditorString(this.tabbedPane.getTabCount() + 1), containerManager.getEditorPanel());
            if (containerManager.isSelectedAtStartup()) {
                this.tabbedPane.setSelectedComponent(containerManager.getEditorPanel());
            }
        }
        finally {
            this.tabbedPane.add("Add", this.addPanel);
            this.tabbedPane.addChangeListener(this.changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewTab() {
        ContainerManager containerManager = null;
        try {
            this.tabbedPane.removeChangeListener(this.changeListener);
            containerManager = new ContainerManager();
            containerManager.addListener(this.containerManagerListener);
            this.tabbedPane.remove(this.addPanel);
            this.tabbedPane.add(containerManager.getEditorString(this.tabbedPane.getTabCount() + 1), containerManager.getEditorPanel());
            this.tabbedPane.setSelectedComponent(containerManager.getEditorPanel());
            ApplicationManager.getInstance().addContainerManager(containerManager);
        }
        finally {
            this.tabbedPane.add("Add", this.addPanel);
            this.tabbedPane.addChangeListener(this.changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentTab() {
        int n = 0;
        EditorPanel editorPanel = null;
        ContainerManager containerManager = null;
        Component component = null;
        if (this.tabbedPane.getTabCount() > 2) {
            try {
                this.tabbedPane.removeChangeListener(this.changeListener);
                n = this.tabbedPane.getSelectedIndex();
                editorPanel = (EditorPanel)this.tabbedPane.getSelectedComponent();
                containerManager = editorPanel.getContainerManager();
                if (ApplicationManager.getInstance().removeContainerManager(containerManager)) {
                    component = this.tabbedPane.getComponentAt(n == 0 ? 1 : --n);
                    this.tabbedPane.remove(editorPanel);
                    this.tabbedPane.setSelectedComponent(component);
                }
            }
            finally {
                this.tabbedPane.addChangeListener(this.changeListener);
            }
        }
    }

    private void checkForAddNewTab() {
        if (this.tabbedPane.getSelectedComponent() == this.addPanel) {
            this.addNewTab();
        }
    }

    private synchronized void updateTabText(ContainerManager containerManager) {
        int n = 0;
        n = this.tabbedPane.indexOfComponent(containerManager.getEditorPanel());
        if (n >= 0) {
            this.tabbedPane.setTitleAt(n, containerManager.getEditorString(n + 1));
        }
    }

    private synchronized void updateTabText() {
        Component component = null;
        ContainerManager containerManager = null;
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            component = this.tabbedPane.getComponent(i);
            if (!(component instanceof EditorPanel)) continue;
            containerManager = ((EditorPanel)component).getContainerManager();
            this.tabbedPane.setTitleAt(i, containerManager.getEditorString(i + 1));
        }
    }

    public class DocumenterListener
    extends Documenter.ListenerAdapter {
        private DocumenterListener() {
        }

        public void projectUpdated(Documenter.Event event) {
            RootPanel.this.updateTabText();
        }

        public void documentUpdated(Documenter.Event event) {
            RootPanel.this.updateTabText();
        }

        public void chapterAdded(Documenter.Event event) {
            RootPanel.this.updateTabText();
        }

        public void sectionUpdated(Documenter.Event event) {
            RootPanel.this.updateTabText();
        }
    }

    public class ContainerManagerListener
    extends ContainerManager.ListenerAdapter {
        public void nodeChanged(ContainerManager.Event event) {
            RootPanel.this.updateTabText(event.getContainerManager());
        }
    }

    public class ApplicationManagerListener
    extends ApplicationManager.ListenerAdapter {
        public void statusMessageChanged(ApplicationManager.Event event) {
            RootPanel.this.setStatusMessage(event.getStatusMessage());
        }
    }

    public class ChangeListenerImpl
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Thread thread = null;
            thread = new Thread(new Runnable(){

                public void run() {
                    RootPanel.this.checkForAddNewTab();
                }
            });
            GuiMethods.startEventThread(thread);
        }
    }
}

