/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ApplicationProperties;
import com.jronimo.documenter.gui.MenuBar;
import com.jronimo.documenter.gui.RootPanel;
import com.jronimo.documenter.gui.ShutdownManager;
import com.jronimo.swing.DisabledGlassPane;
import com.jronimo.swing.GuiMethods;
import com.jronimo.util.Logger;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public final class Frame
extends JFrame {
    private static final Frame instance = new Frame();
    private static final Logger logger = Logger.getLogger(Frame.class);
    private WindowListener windowListener = null;
    private ComponentListener componentListener = null;
    private RootPanel rootPanel;
    private DisabledGlassPane glassPane;

    private Frame() {
        this.initializeEventHandlers();
        this.initializeContainer();
    }

    public static Frame getInstance() {
        return instance;
    }

    public RootPanel getRootPanel() {
        return this.rootPanel;
    }

    private void initializeEventHandlers() {
        this.windowListener = new WindowListenerImpl();
        this.componentListener = new ComponentListenerImpl();
    }

    private void initializeContainer() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowListener);
        this.addComponentListener(this.componentListener);
        try {
            n = ApplicationProperties.getInstance().getWindowX();
            n2 = ApplicationProperties.getInstance().getWindowY();
            n3 = ApplicationProperties.getInstance().getWindowWidth();
            n4 = ApplicationProperties.getInstance().getWindowHeight();
        }
        catch (Exception exception) {
            n3 = 0;
            n4 = 0;
            exception.printStackTrace();
        }
        if (n3 == 0 && n4 == 0) {
            this.setSize(800, 600);
            GuiMethods.centerContainerOnScreen(this);
            this.setExtendedState(this.getExtendedState() | 6);
        } else {
            this.setLocation(n, n2);
            this.setSize(n3, n4);
        }
        this.setTitle(ApplicationProperties.getInstance().getApplicationTitle());
        this.rootPanel = new RootPanel();
        this.getContentPane().add(this.rootPanel);
        this.setJMenuBar(new MenuBar());
        this.glassPane = new DisabledGlassPane();
        this.setGlassPane(this.glassPane);
    }

    private void moved() {
        int n = 0;
        int n2 = 0;
        n = this.getLocation().x;
        n2 = this.getLocation().y;
        this.updateLocation(n, n2);
    }

    private void resized() {
        int n = 0;
        int n2 = 0;
        n = this.getSize().width;
        n2 = this.getSize().height;
        this.updateSize(n, n2);
    }

    private void updateLocation(int n, int n2) {
        try {
            ApplicationProperties.getInstance().setWindowX(n);
            ApplicationProperties.getInstance().setWindowY(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateSize(int n, int n2) {
        try {
            ApplicationProperties.getInstance().setWindowWidth(n);
            ApplicationProperties.getInstance().setWindowHeight(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showGlassPane() {
        this.setEnabled(false);
        this.glassPane.activate(null);
    }

    public void hideGlassPane() {
        this.setEnabled(true);
        this.glassPane.deactivate();
    }

    public class ComponentListenerImpl
    extends ComponentAdapter {
        private ComponentListenerImpl() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Thread thread = null;
            thread = new Thread(new Runnable(){

                public void run() {
                    Frame.this.moved();
                }
            });
            GuiMethods.startEventThread(thread);
        }

        public void componentResized(ComponentEvent componentEvent) {
            Thread thread = null;
            thread = new Thread(new Runnable(){

                public void run() {
                    Frame.this.resized();
                }
            });
            GuiMethods.startEventThread(thread);
        }
    }

    public class WindowListenerImpl
    extends WindowAdapter {
        private WindowListenerImpl() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            ApplicationManager.getInstance().guiLoaded();
        }

        public void windowClosing(WindowEvent windowEvent) {
            ShutdownManager.getInstance().shutdown();
        }
    }
}

