/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ContentPanel;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.objectmodel.Section;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.swing.HtmlEditorPane;
import com.jronimo.util.Logger;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JPanel;

public final class EditorPane
extends JPanel
implements ContentPanel {
    private static final Logger logger = Logger.getLogger(EditorPane.class);
    private Node node;
    private Section section;
    private HtmlEditorPane editorPane;

    public EditorPane(Node node, Section section) {
        this.node = node;
        this.section = section;
        this.init();
    }

    private void init() {
        HtmlEditorPane.Struct struct = null;
        try {
            ApplicationManager.getInstance().contentPanelLoading();
            struct = new HtmlEditorPane.Struct();
            struct.ckEditorUrl = new File(ApplicationManager.getInstance().getApplicationFolder(), "ckeditor/index.html").toURL().toString();
            struct.title = this.section.getTitle();
            struct.html = this.section.getContent();
            struct.listener = new HtmlEditorPaneListener();
            this.editorPane = new HtmlEditorPane(struct);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.editorPane);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public void autoSave() {
        try {
            this.editorPane.forceSave();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public boolean manualSave(boolean bl) {
        boolean bl2 = true;
        try {
            this.editorPane.forceSave();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        return bl2;
    }

    public void destroy() {
    }

    public Node getNode() {
        return this.node;
    }

    public String getEditorString() {
        String string = null;
        string = this.section.getDocument().getTitle() + "/" + this.section.getTitle();
        return string;
    }

    private void saveSectionContent(String string, String string2) {
        if (string2 != null) {
            this.section.setContent(string, string2);
        }
    }

    public class HtmlEditorPaneListener
    implements HtmlEditorPane.Listener {
        public void editorReady(HtmlEditorPane.Event event) {
            ApplicationManager.getInstance().contentPanelReady();
        }

        public void save(HtmlEditorPane.Event event) {
            EditorPane.this.saveSectionContent(event.getTitle(), event.getHtml());
        }
    }
}

