/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.ApplicationProperties;
import com.jronimo.documenter.gui.ContentPanel;
import com.jronimo.documenter.gui.EditorPanel;
import com.jronimo.documenter.gui.nodes.Node;
import com.jronimo.documenter.gui.nodes.RootNode;
import com.jronimo.swing.TreeState;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.EventFirer;
import com.jronimo.util.Logger;
import com.jronimo.util.MethodInvoker;
import com.jronimo.xml.XmlElement;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;

public final class ContainerManager {
    private static final Logger logger = Logger.getLogger(ContainerManager.class);
    private static int instanceCount = 0;
    private InitialState initialState;
    private EditorPanel editorPanel;
    private List<Listener> listeners = new ArrayList<Listener>(1);
    private Node currentNode;

    public ContainerManager() {
        this.loadEditor();
    }

    public ContainerManager(XmlElement xmlElement) {
        this.initialState = new InitialState(xmlElement);
    }

    void loadEditor() {
        this.editorPanel = new EditorPanel(this);
    }

    void setEditorState() {
        TreeState treeState = null;
        if (this.initialState != null) {
            if (this.initialState.hasInformation()) {
                treeState = new TreeState(this.editorPanel.getTree(), this.initialState.getExpandedNodes(), this.initialState.getSelectedNode());
                treeState.apply(false);
                this.editorPanel.setDividerLocation(this.initialState.getDividerLocation());
                this.editorPanel.setScrollLocation(this.initialState.getScrollLocation());
            } else {
                this.editorPanel.setInitialTreeState();
            }
        }
    }

    public boolean isSelectedAtStartup() {
        return this.initialState.isSelected();
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public EditorPanel getEditorPanel() {
        return this.editorPanel;
    }

    public JTree getTree() {
        return this.editorPanel.getTree();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public boolean clearSelection(Node node, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if ((node == this.currentNode && bl || node != this.currentNode) && this.currentNode != null && node.containsNode(this.currentNode)) {
            bl3 = this.clearSelection(bl2);
        }
        return bl3;
    }

    public boolean clearSelection(boolean bl) {
        boolean bl2 = false;
        bl2 = this._setContentPanel(null, bl);
        return bl2;
    }

    public boolean setContentPanel(ContentPanel contentPanel) {
        boolean bl = false;
        Assert.errorParam(contentPanel == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "contentPanel"));
        bl = this._setContentPanel(contentPanel, true);
        return bl;
    }

    private boolean _setContentPanel(ContentPanel contentPanel, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        ContentPanel contentPanel2 = null;
        if (this.editorPanel == null) {
            bl3 = false;
        } else if (this.editorPanel.getSplitPane().getRightComponent() instanceof ContentPanel) {
            contentPanel2 = (ContentPanel)((Object)this.editorPanel.getSplitPane().getRightComponent());
            bl3 = contentPanel2.manualSave(bl);
        }
        if (bl3 && contentPanel != null && ApplicationManager.getInstance().isNodeSelected(this, contentPanel.getNode())) {
            bl3 = false;
            ApplicationManager.getInstance().setStatusErrorMessage("Cannot load content", "The content is already loaded in another editor tab.");
        }
        if (bl3) {
            if (contentPanel2 != null) {
                contentPanel2.destroy();
            }
            if (contentPanel == null) {
                this.currentNode = null;
                this.editorPanel.getSplitPane().setRightComponent(new JPanel());
                this.editorPanel.getTree().clearSelection();
            } else {
                this.currentNode = contentPanel.getNode();
                this.editorPanel.getSplitPane().setRightComponent((Component)((Object)contentPanel));
            }
            ListenerAdapter.fireEvent(this.listeners, "nodeChanged", new Event(this.currentNode));
        } else if (contentPanel2 == null) {
            this.editorPanel.getTree().clearSelection();
        } else {
            this.editorPanel.getTree().setSelectionPath(contentPanel2.getNode().getTreePath());
        }
        bl2 = bl3;
        return bl2;
    }

    public String getEditorString(int n) {
        String string = null;
        if (this.editorPanel != null && this.editorPanel.getSplitPane().getRightComponent() instanceof ContentPanel) {
            string = ((ContentPanel)((Object)this.editorPanel.getSplitPane().getRightComponent())).getEditorString();
        }
        if (string == null || string.length() == 0) {
            string = "Editor";
        }
        string = n + ". " + string;
        return string;
    }

    public TreeState.Struct getNodeInfo() {
        TreeState.Struct struct = null;
        TreeState treeState = null;
        if (this.editorPanel != null) {
            treeState = new TreeState(this.getTree());
            struct = treeState.getStruct();
        }
        return struct;
    }

    public boolean saveCurrentContent() {
        boolean bl = true;
        ContentPanel contentPanel = null;
        if (this.editorPanel != null && this.editorPanel.getSplitPane().getRightComponent() instanceof ContentPanel) {
            contentPanel = (ContentPanel)((Object)this.editorPanel.getSplitPane().getRightComponent());
            if (ApplicationProperties.getInstance().getAutoSave()) {
                contentPanel.autoSave();
            } else {
                bl = contentPanel.manualSave(true);
            }
        }
        return bl;
    }

    public boolean prepareForDestroy() {
        return this.saveCurrentContent();
    }

    public void destroy() {
        ContentPanel contentPanel = null;
        if (this.editorPanel != null && this.editorPanel.getSplitPane().getRightComponent() instanceof ContentPanel) {
            contentPanel = (ContentPanel)((Object)this.editorPanel.getSplitPane().getRightComponent());
            contentPanel.autoSave();
            contentPanel.destroy();
        }
    }

    public static class ListenerAdapter
    implements Listener {
        private static void fireEvent(Collection collection, String string, Event event) {
            new EventFirer(collection, ListenerAdapter.getMethodInvoker(string, event)).execute(true);
        }

        private static MethodInvoker getMethodInvoker(String string, Event event) {
            return new MethodInvoker(Listener.class, null, string, null, new Object[]{event});
        }

        public void nodeChanged(Event event) {
        }
    }

    public static interface Listener {
        public void nodeChanged(Event var1);
    }

    public class Event {
        private ContainerManager containerManager;
        private Object subject;

        private Event(Object object) {
            this.containerManager = ContainerManager.this;
            this.subject = object;
        }

        public ContainerManager getContainerManager() {
            return this.containerManager;
        }

        public Object getSubject() {
            return this.subject;
        }

        public Node getCurrentNode() {
            return (Node)this.subject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitialState {
        private boolean hasInformation;
        private boolean isSelected;
        private Collection<String> expandedNodes = new HashSet<String>(1);
        private String selectedNode;
        private int dividerLocation;
        private int scrollLocation;

        private InitialState(XmlElement xmlElement) {
            this.init(xmlElement);
        }

        private void init(XmlElement xmlElement) {
            NullFreeCollection<XmlElement> nullFreeCollection = null;
            if (xmlElement.hasElement("expanded-nodes")) {
                this.hasInformation = true;
                nullFreeCollection = xmlElement.getOptionalElements("expanded-nodes/node");
                this.expandedNodes = new HashSet<String>(nullFreeCollection.size());
                this.isSelected = xmlElement.getOptionalAttributeBoolean("selected", false);
                for (XmlElement xmlElement2 : nullFreeCollection) {
                    this.expandedNodes.add(xmlElement2.getText());
                }
                this.selectedNode = xmlElement.getText("selected-node");
                if (this.selectedNode.length() == 0) {
                    this.selectedNode = null;
                }
                this.dividerLocation = xmlElement.getOptionalInteger("divider-location", "0");
                this.scrollLocation = xmlElement.getOptionalInteger("scroll-location", "0");
            } else {
                this.hasInformation = false;
            }
        }

        private String getNodePathFromIdPath(RootNode rootNode, String string) {
            String string2 = null;
            Node node = null;
            if (rootNode == null) {
                rootNode = (RootNode)ContainerManager.this.editorPanel.getTree().getModel().getRoot();
            }
            if ((node = rootNode.findNodeWithIdPath(string)) != null) {
                string2 = node.getTreePath().toString();
            }
            return string2;
        }

        boolean hasInformation() {
            return this.hasInformation;
        }

        boolean isSelected() {
            return this.isSelected;
        }

        Collection<String> getExpandedNodes() {
            HashSet<String> hashSet = null;
            RootNode rootNode = null;
            String string = null;
            rootNode = (RootNode)ContainerManager.this.editorPanel.getTree().getModel().getRoot();
            hashSet = new HashSet<String>(this.expandedNodes.size());
            for (String string2 : this.expandedNodes) {
                string = this.getNodePathFromIdPath(rootNode, string2);
                if (string == null) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        String getSelectedNode() {
            return this.selectedNode == null ? null : this.getNodePathFromIdPath(null, this.selectedNode);
        }

        int getDividerLocation() {
            return this.dividerLocation;
        }

        int getScrollLocation() {
            return this.scrollLocation;
        }
    }
}

