/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.documenter.gui;

import com.jronimo.documenter.gui.ApplicationManager;
import com.jronimo.documenter.gui.Constants;
import com.jronimo.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public final class ApplicationProperties {
    private static ApplicationProperties instance;
    private static final Logger logger;
    private File applicationPropertiesFile;
    private Properties applicationProperties;

    private ApplicationProperties(File file) {
        this.applicationPropertiesFile = file;
        this.loadApplicationProperties();
    }

    public static synchronized void createInstance(File file) {
        instance = new ApplicationProperties(new File(file, "application.properties"));
    }

    public static ApplicationProperties getInstance() {
        return instance;
    }

    public void setApplicationTitle(String string) {
        this.setApplicationProperty(Constants.ApplicationProperty.APPLICATION_TITLE, string);
    }

    public String getApplicationTitle() {
        return this.getApplicationProperty(Constants.ApplicationProperty.APPLICATION_TITLE);
    }

    public void setWindowX(int n) {
        this.setApplicationProperty(Constants.ApplicationProperty.WINDOW_X, String.valueOf(n));
    }

    public int getWindowX() {
        int n = 0;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.WINDOW_X);
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public void setWindowY(int n) {
        this.setApplicationProperty(Constants.ApplicationProperty.WINDOW_Y, String.valueOf(n));
    }

    public int getWindowY() {
        int n = 0;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.WINDOW_Y);
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public void setWindowWidth(int n) {
        this.setApplicationProperty(Constants.ApplicationProperty.WINDOW_WIDTH, String.valueOf(n));
    }

    public int getWindowWidth() {
        int n = 0;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.WINDOW_WIDTH);
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public void setWindowHeight(int n) {
        this.setApplicationProperty(Constants.ApplicationProperty.WINDOW_HEIGHT, String.valueOf(n));
    }

    public int getWindowHeight() {
        int n = 0;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.WINDOW_HEIGHT);
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public void setAutoSave(boolean bl) {
        this.setApplicationProperty(Constants.ApplicationProperty.AUTO_SAVE, String.valueOf(bl));
    }

    public boolean getAutoSave() {
        boolean bl = false;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.AUTO_SAVE);
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public void setLastDirectoryVisited(File file) {
        String string = null;
        string = file == null ? "" : file.getPath();
        this.setApplicationProperty(Constants.ApplicationProperty.LAST_DIRECTORY_VISITED, string);
    }

    public File getLastDirectoryVisited() {
        File file = null;
        String string = null;
        string = this.getApplicationProperty(Constants.ApplicationProperty.LAST_DIRECTORY_VISITED);
        file = string == null || string.length() == 0 ? ApplicationManager.getInstance().getDefaultDocumentsFolder() : new File(string);
        return file;
    }

    private synchronized void setApplicationProperty(Constants.ApplicationProperty applicationProperty, String string) {
        this.applicationProperties.put(applicationProperty.getText(), string);
        this.saveApplicationProperties();
    }

    private synchronized String getApplicationProperty(Constants.ApplicationProperty applicationProperty) {
        return (String)this.applicationProperties.get(applicationProperty.getText());
    }

    private void loadApplicationProperties() {
        try {
            this.applicationProperties = new Properties();
            this.applicationProperties.load(new FileInputStream(this.applicationPropertiesFile));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveApplicationProperties() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.applicationPropertiesFile);
            this.applicationProperties.store(fileOutputStream, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        logger = Logger.getLogger(ApplicationProperties.class);
    }
}

