/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.constraints;

import com.jronimo.constraints.Constraint;
import com.jronimo.constraints.Constraints;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

final class ConstraintsLoader {
    private static final Logger logger = Logger.getLogger(ConstraintsLoader.class);

    ConstraintsLoader() {
    }

    void execute() {
        XmlElement xmlElement = null;
        try {
            xmlElement = XmlElementFactory.load(ConstraintsLoader.class, "Constraints.xml");
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("constraints")) {
                this.loadConstraints(xmlElement2);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private void loadConstraints(XmlElement xmlElement) throws Exception {
        Constraint.ConstraintType constraintType = null;
        constraintType = Constraint.ConstraintType.valueOf(xmlElement.getText("type"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("constraint")) {
            this.loadConstraint(xmlElement2, constraintType);
        }
    }

    private void loadConstraint(XmlElement xmlElement, Constraint.ConstraintType constraintType) throws Exception {
        String string = null;
        Constraint.ValueMultiplicity valueMultiplicity = null;
        boolean bl = false;
        string = xmlElement.getText("name");
        valueMultiplicity = Constraint.ValueMultiplicity.valueOf(xmlElement.getText("constraint-value-multiplicity"));
        bl = xmlElement.getBoolean("requires-non-null-value");
        Constraints.getInstance().add(new Constraint(constraintType, string, valueMultiplicity, bl));
    }
}

