/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.constraints;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.constraints.Constraint;
import com.jronimo.constraints.ConstraintsLoader;
import com.jronimo.constraints.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.HashMap;
import java.util.Map;

public final class Constraints {
    private static final Logger logger = Logger.getLogger(Constraints.class);
    private static final Constraints instance = new Constraints();
    private Map<Constraint.ConstraintType, Map<String, Constraint>> constraints = CollectionUtils.getOrderedMap(new HashMap(8));

    private Constraints() {
    }

    public static Constraints getInstance() {
        return instance;
    }

    public Constraint getConstraint(Constraint.ConstraintType constraintType, String string) {
        Constraint constraint = null;
        Map<String, Constraint> map = null;
        Assert.errorParam(constraintType == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "type"));
        Assert.errorParam(string == null, new ResourceTextPointer((Object)com.jronimo.text.ResourceTextIdentifiers.MUST_NOT_BE_NULL, "constraintName"));
        map = this.constraints.get((Object)constraintType);
        Assert.unexpected(map == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_CONSTRAINT_TYPE, constraintType.toString()));
        constraint = map.get(string);
        Assert.unexpected(constraint == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.UNRECOGNIZED_CONSTRAINT_TYPE, constraintType.toString(), string));
        return constraint;
    }

    synchronized void add(Constraint constraint) {
        Map<String, Constraint> map = null;
        map = this.constraints.get((Object)constraint.getType());
        if (map == null) {
            map = new HashMap<String, Constraint>(5);
            this.constraints.put(constraint.getType(), map);
        }
        map.put(constraint.getName(), constraint);
    }

    static {
        new ConstraintsLoader().execute();
    }
}

