/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReverseCollectionIterator<E>
implements Iterator<E> {
    private static final Logger logger = Logger.getLogger(ReverseCollectionIterator.class);
    private Collection<E> collection;
    private int lastIndexUsed;
    private boolean nextCalled;

    ReverseCollectionIterator(Collection<E> collection) {
        this.collection = collection;
        this.lastIndexUsed = collection.size();
    }

    @Override
    public boolean hasNext() {
        return this.lastIndexUsed - 1 >= 0;
    }

    @Override
    public E next() {
        E e = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextCalled = true;
        e = this.collection.get(--this.lastIndexUsed);
        return e;
    }

    @Override
    public void remove() {
        Assert.errorState(!this.nextCalled, new ResourceTextPointer((Object)ResourceTextIdentifiers.ITERATOR_NEXT_PREVIOUS));
        this.collection.remove(this.lastIndexUsed);
    }
}

