/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.MutableSet;
import com.jronimo.collections.collection.CollectionData;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.OperationResult;
import com.jronimo.collections.collection.hidden.impl.AbstractCollection;
import com.jronimo.collections.collection.hidden.impl.CollectionIterator;
import com.jronimo.collections.collection.hidden.impl.ListIterator;
import com.jronimo.collections.collection.hidden.impl.ReverseCollectionIterator;
import com.jronimo.collections.collection.hidden.impl.Utils;
import com.jronimo.collections.collection.types.ListCollection;
import com.jronimo.collections.collection.types.SetCollection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedCollection<E>
extends AbstractCollection<E> {
    private static final Logger logger = Logger.getLogger(OrderedCollection.class);
    private OperationResult operationResult;
    private boolean trimToSizeCalled;

    public OrderedCollection(List<E> list, int n, Comparator comparator, boolean bl) {
        super(list, n, comparator, bl);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        com.jronimo.collections.collection.types.Collection collection = null;
        if (object instanceof com.jronimo.collections.collection.types.Collection && (collection = (com.jronimo.collections.collection.types.Collection)object).size() == this.list.size()) {
            bl = true;
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                if (this.bothEqual(collection.get(i), this.list.get(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void trimToSize() {
        ((ArrayList)this.list).trimToSize();
        this.trimToSizeCalled = true;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isValidValue(E e) {
        return true;
    }

    @Override
    public final boolean indexInBounds(int n, boolean bl) {
        return CollectionUtils.indexInBounds(n, 0, bl ? this.list.size() : this.list.size() - 1, false);
    }

    @Override
    public boolean inBoundsFromLast(int n) {
        return CollectionUtils.indexInBounds(this.list.size() - 1 - n, 0, this.list.size() - 1, false);
    }

    @Override
    public boolean isLastIndex(int n) {
        return !this.list.isEmpty() && n == this.size() - 1;
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int indexOf(Object object, int n) {
        int n2 = -1;
        if (CollectionUtils.indexInBounds(n, 0, this.list.size() - 1, false)) {
            int n3 = this.list.size();
            for (int i = n; i < n3; ++i) {
                if (!this.bothEqual(object, this.get(i))) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    @Override
    public int[] indexesOf(Object object) {
        return this.indexesOf(object, 0);
    }

    @Override
    public int[] indexesOf(Object object, int n) {
        int[] nArray = null;
        MutableList<Integer> mutableList = null;
        int n2 = 0;
        int n3 = -1;
        n2 = n - 1;
        mutableList = new MutableList<Integer>(this.getIdealCapacity(20, 2));
        while (true) {
            ++n2;
            if ((n2 = this.indexOf(object, n2)) < 0) break;
            mutableList.add(n2);
        }
        for (Integer n4 : mutableList) {
            nArray[++n3] = n4;
        }
        return nArray;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public int lastIndexOf(Object object, int n) {
        int n2 = -1;
        if (CollectionUtils.indexInBounds(n, 1, this.list.size(), false)) {
            for (int i = n - 1; i >= 0; --i) {
                if (!this.bothEqual(object, this.get(i))) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean containsAll(Object ... objectArray) {
        return this.containsAll(new MutableSet<Object>(objectArray));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        boolean bl = false;
        for (Object e : this.list) {
            if (!collection.contains(e)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean containsAny(Object ... objectArray) {
        return this.containsAny(new MutableSet<Object>(objectArray));
    }

    @Override
    public boolean containsOnly(Collection<?> collection) {
        boolean bl = true;
        for (Object e : this.list) {
            if (collection.contains(e)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean containsOnly(Object ... objectArray) {
        return this.containsOnly(new MutableSet<Object>(objectArray));
    }

    @Override
    public E get(int n) {
        return this.list.get(n);
    }

    @Override
    public E getFirst() {
        Object e = null;
        this.operationResult = new OperationResult();
        if (!this.list.isEmpty()) {
            e = this.list.get(0);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E getLast() {
        Object e = null;
        this.operationResult = new OperationResult();
        if (!this.list.isEmpty()) {
            e = this.list.get(this.list.size() - 1);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E getFromLast(int n) {
        return this.list.get(this.list.size() - 1 - n);
    }

    @Override
    public E get(Object object) {
        E e = null;
        int n = 0;
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "object"));
        n = this.list.indexOf(object);
        if (n >= 0) {
            e = this.list.get(n);
        }
        return e;
    }

    @Override
    public E getBefore(Object object) {
        Object e = null;
        int n = 0;
        this.operationResult = new OperationResult();
        if (this.list.size() > 1 && (n = this.list.indexOf(object) - 1) >= 0) {
            e = this.list.get(n);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E getAfter(Object object) {
        Object e = null;
        int n = 0;
        this.operationResult = new OperationResult();
        if (this.list.size() > 1 && (n = this.list.indexOf(object) + 1) < this.list.size()) {
            e = this.list.get(n);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public SetCollection<E> get(SetCollection<Object> setCollection) {
        SetCollection setCollection2 = null;
        MutableSet<E> mutableSet = null;
        int n = 0;
        Assert.errorParam(setCollection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        mutableSet = new MutableSet<E>(setCollection.size());
        for (Object e : setCollection) {
            n = this.indexOf(e);
            if (n < 0) continue;
            mutableSet.add(this.get(n));
        }
        setCollection2 = this.createSetReturnInstance(new CollectionData(mutableSet));
        return setCollection2;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(Object object) {
        com.jronimo.collections.collection.types.Collection collection = null;
        boolean bl = false;
        collection = new MutableList(this.getIdealCapacity(10, 5));
        for (Object e : this.list) {
            if (!this.bothEqual(object, e)) continue;
            collection.add(e);
        }
        collection = this.createReturnInstance(new CollectionData(collection));
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(SetCollection<Object> setCollection) {
        com.jronimo.collections.collection.types.Collection collection = null;
        Assert.errorParam(setCollection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        collection = new MutableList(this.getIdealCapacity(2, 5));
        for (Object e : this.list) {
            if (!setCollection.contains(e)) continue;
            collection.add(e);
        }
        collection = this.createReturnInstance(new CollectionData(collection));
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(Object ... objectArray) {
        com.jronimo.collections.collection.types.Collection<E> collection = null;
        Assert.errorParam(objectArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        collection = this.getAll(new MutableSet<Object>(objectArray));
        return collection;
    }

    @Override
    public boolean hasDuplicates() {
        return !this._getDuplicates().isEmpty();
    }

    @Override
    public SetCollection<E> getDuplicates() {
        return this.createSetReturnInstance(new CollectionData<E>(this._getDuplicates()));
    }

    private MutableSet<E> _getDuplicates() {
        MutableSet mutableSet = null;
        MutableSet mutableSet2 = null;
        MutableList mutableList = null;
        mutableSet2 = new MutableSet(this.list.size());
        if (this.list.size() > 1) {
            mutableList = new MutableList(this.getIdealCapacity(10, 2));
            for (Object e : this.list) {
                if (mutableSet2.add(e)) continue;
                mutableList.add(e);
            }
            mutableSet2.retainAll(mutableList);
        }
        mutableSet = mutableSet2;
        return mutableSet2;
    }

    @Override
    public ListCollection<E> getAllDuplicates() {
        ListCollection listCollection = null;
        if (this.list.size() > 1) {
            listCollection = new MutableList(this.list);
            listCollection.retainAll(this._getDuplicates());
        } else {
            listCollection = new MutableList();
        }
        listCollection = this.createListReturnInstance(new CollectionData(listCollection));
        return listCollection;
    }

    @Override
    public ListCollection<E> subList(int n, int n2) {
        return this.createListReturnInstance(new CollectionData(this.list.subList(n, n2)));
    }

    @Override
    public Iterator<E> iterator() {
        return new CollectionIterator(this);
    }

    @Override
    public Iterator<E> iterator(int n) {
        return new CollectionIterator(this, n, this.size());
    }

    @Override
    public Iterator<E> iterator(int n, int n2) {
        return new CollectionIterator(this, n, n2);
    }

    @Override
    public Iterator<E> reverseIterator() {
        return new ReverseCollectionIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListIterator(this, n);
    }

    @Override
    public ListIterator<E> listIterator(int n, int n2) {
        return new ListIterator(this, n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        bl = this.list.add(e);
        return bl;
    }

    @Override
    public void add(int n, E e) {
        this.operationResult = new OperationResult();
        this.list.add(n, e);
        this.operationResult.setOperationExecuted(true);
    }

    @Override
    public boolean addBefore(Object object, E e) {
        boolean bl = false;
        int n = 0;
        n = this.list.indexOf(object);
        if (n >= 0) {
            this.list.add(n, e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAfter(Object object, E e) {
        boolean bl = false;
        int n = 0;
        n = this.list.indexOf(object);
        if (n >= 0) {
            this.list.add(n + 1, e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.list.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.list.addAll(n, collection);
    }

    @Override
    public E set(int n, E e) {
        E e2 = null;
        this.operationResult = new OperationResult();
        e2 = this.list.set(n, e);
        this.operationResult.setOperationExecuted(true);
        this.operationResult.setElement(e2);
        return e2;
    }

    @Override
    public boolean set(Object object, E e) {
        boolean bl = false;
        int n = 0;
        n = this.list.indexOf(object);
        if (n >= 0) {
            this.list.set(n, e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean move(int n, int n2) {
        boolean bl = false;
        Object e = null;
        if (n != n2 && n2 - n != 1) {
            if (n < n2) {
                --n2;
            }
            e = this.list.remove(n);
            this.list.add(n2, e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean move(Object object, int n) {
        boolean bl = false;
        int n2 = 0;
        n2 = this.list.indexOf(object);
        if (n2 >= 0) {
            bl = this.move(n2, n);
        }
        return bl;
    }

    @Override
    public boolean moveBefore(Object object, Object object2) {
        boolean bl = false;
        int n = 0;
        n = this.list.indexOf(object);
        if (n >= 0) {
            bl = this.move(object2, n);
        }
        return bl;
    }

    @Override
    public boolean moveAfter(Object object, Object object2) {
        boolean bl = false;
        int n = 0;
        n = this.list.indexOf(object);
        if (n >= 0) {
            bl = this.move(object2, n + 1);
        }
        return bl;
    }

    @Override
    public boolean swap(int n, int n2) {
        boolean bl = false;
        E e = null;
        E e2 = null;
        int n3 = 0;
        int n4 = 0;
        if (n != n2) {
            if (n > n2) {
                n3 = n2;
                n4 = n;
                n = n3;
                n2 = n4;
            }
            e2 = this.remove(n2);
            e = this.set(n, e2);
            this.set(n2, e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean swap(Object object, Object object2) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (!this.bothEqual(object, object2)) {
            n = this.list.indexOf(object);
            if (n >= 0) {
                n2 = this.list.indexOf(object2);
            }
            if (n >= 0 && n2 >= 0) {
                bl = this.swap(n, n2);
            }
        }
        return bl;
    }

    @Override
    public boolean reverse() {
        boolean bl = false;
        if (this.list.size() > 1) {
            Collections.reverse(this.list);
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        if (!this.list.isEmpty()) {
            this.list.clear();
        }
    }

    @Override
    public E remove(int n) {
        E e = null;
        e = this.list.remove(n);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public E removeBefore(Object object) {
        Object e = null;
        int n = 0;
        this.operationResult = new OperationResult();
        n = this.list.indexOf(object);
        if (n > 0) {
            e = this.list.remove(n - 1);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E removeAfter(Object object) {
        Object e = null;
        int n = 0;
        this.operationResult = new OperationResult();
        n = this.list.indexOf(object);
        if (CollectionUtils.indexInBounds(n, 0, this.list.size() - 2, false)) {
            e = this.list.remove(n + 1);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean removeAll(Object ... objectArray) {
        return this.list.removeAll(new MutableSet<Object>(objectArray));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public boolean retainAll(Object ... objectArray) {
        return this.retainAll(new MutableList<Object>(objectArray));
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n) {
        return this.removeAllFrom(n, this.list.size());
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n, int n2) {
        com.jronimo.collections.collection.types.Collection<Object> collection = null;
        java.util.ListIterator listIterator = null;
        int n3 = 0;
        Object e = null;
        collection = new MutableList<Object>(n2 - n);
        listIterator = this.list.listIterator(n);
        n3 = n;
        while (listIterator.hasNext()) {
            e = listIterator.next();
            listIterator.remove();
            collection.add(e);
            if (++n3 != n2) continue;
        }
        collection = this.createReturnInstance(new CollectionData(collection));
        return collection;
    }

    @Override
    public E removeFirst() {
        Object e = null;
        this.operationResult = new OperationResult();
        if (!this.list.isEmpty()) {
            e = this.list.remove(0);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E removeLast() {
        Object e = null;
        this.operationResult = new OperationResult();
        if (!this.list.isEmpty()) {
            e = this.list.remove(this.list.size() - 1);
            this.operationResult.setOperationExecuted(true);
            this.operationResult.setElement(e);
        }
        return e;
    }

    @Override
    public E removeFromLast(int n) {
        E e = null;
        e = this.list.remove(this.list.size() - 1 - n);
        return e;
    }

    @Override
    public ListCollection<E> removeDuplicates() {
        ListCollection<Object> listCollection = null;
        listCollection = this.list.size() > 1 ? Utils.removeDuplicates(this.list) : new MutableList(0);
        listCollection = this.createListReturnInstance(new CollectionData((Collection<?>)listCollection));
        return listCollection;
    }

    @Override
    public ListCollection<E> removeAllDuplicates() {
        ListCollection<Object> listCollection = null;
        listCollection = this.list.size() > 1 ? Utils.removeAllDuplicates(this.list, this._getDuplicates()) : new MutableList(0);
        listCollection = this.createListReturnInstance(new CollectionData(listCollection));
        return listCollection;
    }

    @Override
    public final void sort() {
        if (this.list.size() > 1) {
            Collections.sort(this.list, this.getComparator());
        }
    }

    @Override
    public final void sort(Comparator comparator) {
        if (this.list.size() > 1) {
            Collections.sort(this.list, comparator);
        }
    }

    @Override
    public String toString(String string, int n, int n2) {
        StringWrapper stringWrapper = null;
        Object var5_5 = null;
        Assert.errorParamMustNotBeNull("delimiter", string);
        stringWrapper = new StringWrapper();
        for (int i = n; i < n2; ++i) {
            var5_5 = this.list.get(i);
            stringWrapper.append(String.valueOf(var5_5));
            stringWrapper.append(string);
        }
        if (n2 - n > 1) {
            stringWrapper.deleteLast(string.length());
        }
        return stringWrapper.toString();
    }

    @Override
    public String toString(String string) {
        return this.toString(string, 0, this.size());
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public void clearOperationResult() {
        this.operationResult = null;
    }

    public void setOperationResult(OperationResult<E> operationResult) {
        this.operationResult = operationResult;
    }

    @Override
    public OperationResult<E> getOperationResult() {
        return this.operationResult;
    }
}

