/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListIterator<E>
implements java.util.ListIterator<E> {
    private static final Logger logger = Logger.getLogger(ListIterator.class);
    private Collection<E> collection;
    private int fromIndex;
    private int toIndex;
    private int indexOfLastReturned = -1;
    private boolean addRemoveCalledAfterNextPrevious;
    private LastCall lastCall;

    public ListIterator(Collection<E> collection) {
        this(collection, 0, collection.size());
    }

    public ListIterator(Collection<E> collection, int n) {
        this(collection, n, collection.size());
    }

    public ListIterator(Collection<E> collection, int n, int n2) {
        Assert.errorParamMustNotBeNull("string", collection);
        int n3 = n < 0 ? 0 : (n = n > collection.size() ? collection.size() : n);
        int n4 = n2 < 0 ? 0 : (n2 = n2 > collection.size() ? collection.size() : n2);
        if (n2 < n) {
            n2 = n;
        }
        this.collection = collection;
        this.fromIndex = n;
        this.toIndex = n2;
        this.indexOfLastReturned = n - 1;
    }

    public int indexOfLastReturned() {
        return this.indexOfLastReturned;
    }

    @Override
    public int previousIndex() {
        int n = 0;
        if (this.lastCall == null) {
            n = this.toIndex - 1;
        } else if (this.lastCall == LastCall.PREVIOUS) {
            n = this.indexOfLastReturned - 1;
        } else if (this.lastCall == LastCall.NEXT) {
            n = this.indexOfLastReturned;
        }
        return n;
    }

    @Override
    public int nextIndex() {
        int n = 0;
        if (this.lastCall == null) {
            n = this.indexOfLastReturned + 1;
        } else if (this.lastCall == LastCall.PREVIOUS) {
            n = this.indexOfLastReturned;
        } else if (this.lastCall == LastCall.NEXT) {
            n = this.indexOfLastReturned + 1;
        }
        return n;
    }

    @Override
    public boolean hasPrevious() {
        boolean bl = false;
        int n = 0;
        n = this.previousIndex();
        bl = n >= this.fromIndex && n < this.toIndex;
        return bl;
    }

    @Override
    public boolean hasNext() {
        boolean bl = false;
        int n = 0;
        n = this.nextIndex();
        bl = n >= this.fromIndex && n < this.toIndex;
        return bl;
    }

    @Override
    public E previous() {
        E e = null;
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.indexOfLastReturned = this.previousIndex();
        e = this.collection.get(this.indexOfLastReturned);
        this.addRemoveCalledAfterNextPrevious = false;
        this.lastCall = LastCall.PREVIOUS;
        return e;
    }

    @Override
    public E next() {
        E e = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.indexOfLastReturned = this.nextIndex();
        e = this.collection.get(this.indexOfLastReturned);
        this.addRemoveCalledAfterNextPrevious = false;
        this.lastCall = LastCall.NEXT;
        return e;
    }

    @Override
    public void set(E e) {
        this.checkReplaceRemoveState();
        this.collection.set(this.indexOfLastReturned, e);
    }

    @Override
    public void add(E e) {
        this.indexOfLastReturned = this.nextIndex();
        this.collection.add(this.indexOfLastReturned, e);
        ++this.toIndex;
        if (this.lastCall == LastCall.PREVIOUS) {
            ++this.indexOfLastReturned;
        }
        this.addRemoveCalledAfterNextPrevious = true;
    }

    @Override
    public void remove() {
        this.checkReplaceRemoveState();
        this.collection.remove(this.indexOfLastReturned);
        --this.toIndex;
        if (this.lastCall == LastCall.NEXT) {
            --this.indexOfLastReturned;
        }
        this.addRemoveCalledAfterNextPrevious = true;
    }

    private void checkReplaceRemoveState() {
        Assert.errorState(this.lastCall == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.ITERATOR_NEXT_PREVIOUS));
        Assert.errorState(this.addRemoveCalledAfterNextPrevious, new ResourceTextPointer((Object)ResourceTextIdentifiers.ITERATOR_ADD_REMOVE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LastCall {
        NEXT,
        PREVIOUS;

    }
}

