/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.collection.CollectionData;
import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.impl.CollectionApi;
import com.jronimo.collections.collection.hidden.impl.OrderedCollection;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.collection.types.SetCollection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.ClassHierarchy;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstanceTypeBase<E>
extends CollectionApi<E> {
    private DecoratorChain<E> decoratorChain;

    protected InstanceTypeBase(CollectionData<E> collectionData, Class clazz) {
        super(InstanceTypeBase.prepare(collectionData, clazz));
        this.decoratorChain = (DecoratorChain)this.wrapped;
    }

    private static <E> Collection<E> prepare(CollectionData<E> collectionData, Class clazz) {
        DecoratorChain<E> decoratorChain = null;
        OrderedCollection<E> orderedCollection = null;
        CollectionParameters collectionParameters = null;
        CollectionParameters.ComparatorConfig comparatorConfig = null;
        Comparator comparator = null;
        Assert.errorParam(collectionData == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collectionData"));
        collectionData = collectionData.typeClone();
        collectionParameters = collectionData.getParameters();
        comparatorConfig = collectionParameters.getComparatorConfig();
        if (comparatorConfig != null) {
            comparator = comparatorConfig.getComparator();
        }
        orderedCollection = new OrderedCollection<E>(collectionData.getData(), collectionParameters.getCapacity(), comparator, new ClassHierarchy(clazz).hasClass(SetCollection.class));
        if (comparatorConfig != null && comparatorConfig.getDoConstructionSort()) {
            orderedCollection.sort();
            orderedCollection.clearOperationResult();
        }
        decoratorChain = new DecoratorChain<E>(orderedCollection, collectionParameters, clazz);
        return decoratorChain;
    }

    DecoratorChain<E> getDecoratorChain() {
        return this.decoratorChain;
    }
}

