/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.collection.types.Collection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionIterator<E>
implements Iterator<E> {
    private static final Logger logger = Logger.getLogger(CollectionIterator.class);
    private Collection<E> collection;
    private int toIndex;
    private int lastIndexUsed = -1;
    private boolean nextCalled;

    CollectionIterator(Collection<E> collection) {
        this(collection, 0, collection.size());
    }

    CollectionIterator(Collection<E> collection, int n, int n2) {
        Assert.errorParam(n2 < n, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "toIndex", n2, "fromIndex"), IndexOutOfBoundsException.class);
        this.collection = collection;
        this.lastIndexUsed = n - 1;
        this.toIndex = n2;
    }

    @Override
    public boolean hasNext() {
        return this.lastIndexUsed + 1 < this.toIndex;
    }

    @Override
    public E next() {
        E e = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextCalled = true;
        e = this.collection.get(++this.lastIndexUsed);
        return e;
    }

    @Override
    public void remove() {
        Assert.errorState(!this.nextCalled, new ResourceTextPointer((Object)com.jronimo.collections.text.ResourceTextIdentifiers.ITERATOR_NEXT_PREVIOUS));
        this.collection.remove(this.lastIndexUsed--);
    }
}

