/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.impl;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.MutableSet;
import com.jronimo.collections.collection.CollectionData;
import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.collection.types.ListCollection;
import com.jronimo.collections.collection.types.SetCollection;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection<E>
implements Collection<E> {
    private static final Logger logger = Logger.getLogger(AbstractCollection.class);
    protected Comparator comparator;
    protected List<E> list;
    private ReturnInstanceFactory<E> returnInstanceFactory;

    protected AbstractCollection(List<E> list, int n, Comparator comparator, boolean bl) {
        Assert.errorParam(list == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "data"));
        this.comparator = comparator;
        this.list = this.createDataList(list, n, bl);
    }

    private List<E> createDataList(List<E> list, int n, boolean bl) {
        ArrayList<E> arrayList = null;
        arrayList = new ArrayList<E>(n);
        for (E e : list) {
            if (bl) {
                if (arrayList.contains(e)) continue;
                arrayList.add(e);
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    @Override
    public final boolean isSynchronized() {
        return false;
    }

    @Override
    public final boolean isList() {
        return true;
    }

    @Override
    public final boolean isSet() {
        return false;
    }

    @Override
    public final boolean isMutable() {
        return true;
    }

    @Override
    public final boolean isImmutable() {
        return false;
    }

    @Override
    public final boolean isSorting() {
        return false;
    }

    @Override
    public final boolean isUnempty() {
        return false;
    }

    @Override
    public final boolean isRestricted() {
        return false;
    }

    @Override
    public final boolean isRestrictedTo() {
        return false;
    }

    @Override
    public final boolean isRestrictedFrom() {
        return false;
    }

    @Override
    public final boolean isFixedSize() {
        return false;
    }

    @Override
    public final boolean isNullFree() {
        return false;
    }

    @Override
    public final CollectionParameters getCollectionParameters() {
        return null;
    }

    @Override
    public final CollectionParameters.ComparatorConfig getComparatorConfig() {
        return null;
    }

    @Override
    public final Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public final CollectionParameters.Restrictions getRestrictions() {
        return null;
    }

    @Override
    public final CollectionParameters.FixedSize getFixedSize() {
        return null;
    }

    @Override
    public final boolean hasComparator() {
        return false;
    }

    @Override
    public final boolean hasRestrictions() {
        return false;
    }

    @Override
    public final boolean hasFixedSized() {
        return false;
    }

    public List<E> getList() {
        return this.list;
    }

    public void commitNewList(List<E> list) {
        this.list = list;
    }

    public final void setReturnInstanceFactory(ReturnInstanceFactory<E> returnInstanceFactory) {
        this.returnInstanceFactory = returnInstanceFactory;
    }

    public final Collection<E> createReturnInstance(CollectionData<E> collectionData) {
        return this.returnInstanceFactory == null ? new MutableList<E>(collectionData) : this.returnInstanceFactory.getInstanceForReturn(collectionData);
    }

    public final ListCollection<E> createListReturnInstance(CollectionData<E> collectionData) {
        return this.returnInstanceFactory == null ? new MutableList<E>(collectionData) : this.returnInstanceFactory.getListInstanceForReturn(collectionData);
    }

    public final SetCollection<E> createSetReturnInstance(CollectionData<E> collectionData) {
        return this.returnInstanceFactory == null ? new MutableSet<E>(collectionData) : this.returnInstanceFactory.getSetInstanceForReturn(collectionData);
    }

    public int getIdealCapacity(int n, int n2) {
        return CollectionUtils.getIdealCapacity(n, n2, this.size());
    }

    protected final boolean bothEqual(Object object, Object object2) {
        return Methods.bothEqual(object, object2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReturnInstanceFactory<E> {
        public Collection<E> getInstanceForReturn(CollectionData<E> var1);

        public ListCollection<E> getListInstanceForReturn(CollectionData<E> var1);

        public SetCollection<E> getSetInstanceForReturn(CollectionData<E> var1);
    }
}

