/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.hidden.decorators.AbstractSizeDecorator;
import com.jronimo.collections.collection.hidden.decorators.Decorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.collection.types.surf.UnemptyCollection;
import com.jronimo.collections.exceptions.UnemptyException;
import com.jronimo.collections.exceptions.UnsupportedOperationException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnemptyDecorator<E>
extends AbstractSizeDecorator<E>
implements UnemptyCollection<E> {
    UnemptyDecorator(Collection<E> collection, DecoratorChain<E> decoratorChain) {
        super(collection, decoratorChain);
        if (collection.size() == 0) {
            throw UnemptyException.createForConstruction();
        }
    }

    @Override
    protected void checkSize(int n) {
        if (n <= 0) {
            throw UnemptyException.createForOperation();
        }
    }

    @Override
    protected Decorator<E> getSuperClassInstance() {
        return this;
    }

    @Override
    public boolean isUnempty() {
        return true;
    }

    @Override
    public void clear() {
        throw UnsupportedOperationException.createForUnempty();
    }

    public static <E> Collection<E> decorate(Collection<E> collection) {
        Collection<E> collection2 = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        if (collection.isEmpty()) {
            throw UnemptyException.createForConstruction();
        }
        collection2 = DecoratorChain.decorate(collection, new DecoratorChain.DecorationStruct(DecoratorRegistry.getDecoratorConfig(UnemptyDecorator.class)));
        return collection2;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(UnemptyDecorator.class, UnemptyCollection.class));
    }
}

