/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.MutableSet;
import com.jronimo.collections.collection.CollectionData;
import com.jronimo.collections.collection.OperationResult;
import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.hidden.impl.OrderedCollection;
import com.jronimo.collections.collection.types.ListCollection;
import com.jronimo.collections.collection.types.SetCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetDecorator<E>
extends AbstractDecorator<E>
implements SetCollection<E> {
    private OrderedCollection<E> orderedCollection = this.getDecoratorChainInstance().getOrderedCollection();

    SetDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain) {
        super(collection, decoratorChain);
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> getAll(Object object) {
        com.jronimo.collections.collection.types.Collection collection = null;
        int n = 0;
        collection = new MutableSet(1);
        n = this.indexOf(object);
        if (n >= 0) {
            collection.add(this.get(n));
        }
        collection = this.orderedCollection.createReturnInstance(new CollectionData(collection));
        return collection;
    }

    @Override
    public boolean hasDuplicates() {
        return false;
    }

    @Override
    public SetCollection<E> getDuplicates() {
        return this.orderedCollection.createSetReturnInstance(new CollectionData());
    }

    @Override
    public ListCollection<E> getAllDuplicates() {
        return this.orderedCollection.createListReturnInstance(new CollectionData());
    }

    @Override
    public ListCollection<E> removeDuplicates() {
        return this.orderedCollection.createListReturnInstance(new CollectionData());
    }

    @Override
    public ListCollection<E> removeAllDuplicates() {
        return this.orderedCollection.createListReturnInstance(new CollectionData());
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            bl = this.wrapped.add(e);
        }
        return bl;
    }

    @Override
    public void add(int n, E e) {
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            this.wrapped.add(n, e);
        }
    }

    @Override
    public boolean addBefore(Object object, E e) {
        boolean bl = false;
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            bl = this.wrapped.addBefore(object, e);
        }
        return bl;
    }

    @Override
    public boolean addAfter(Object object, E e) {
        boolean bl = false;
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            bl = this.wrapped.addAfter(object, e);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.orderedCollection.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = false;
        bl = this.wrapped.addAll(n, this.returnNotContained(collection));
        return bl;
    }

    @Override
    public E set(int n, E e) {
        E e2 = null;
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            e2 = this.wrapped.set(n, e);
        }
        return e2;
    }

    @Override
    public boolean set(Object object, E e) {
        boolean bl = false;
        OperationResult operationResult = null;
        if (this.orderedCollection.contains(e)) {
            operationResult = new OperationResult();
            operationResult.setOperationExecuted(false);
            this.decoratorChain.getOrderedCollection().setOperationResult(operationResult);
        } else {
            bl = this.wrapped.set(object, e);
        }
        return bl;
    }

    private Set<E> returnNotContained(Collection<? extends E> collection) {
        Set set = null;
        set = SetUtils.orderedSet(new HashSet(collection.size()));
        for (E e : collection) {
            if (this.orderedCollection.contains(e)) continue;
            set.add(e);
        }
        return set;
    }

    private Set<?> returnContained(Collection<?> collection) {
        Set set = null;
        set = SetUtils.orderedSet(new HashSet(collection.size()));
        for (Object obj : collection) {
            if (!this.orderedCollection.contains(obj)) continue;
            set.add(obj);
        }
        return set;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(SetDecorator.class, SetCollection.class));
    }
}

