/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.collections.exceptions.NullFreeException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NullFreeDecorator<E>
extends AbstractDecorator<E> {
    NullFreeDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain, boolean bl) {
        super(collection, decoratorChain);
        Iterator<E> iterator = null;
        Object var5_5 = null;
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            var5_5 = iterator.next();
            if (bl) {
                if (var5_5 != null) continue;
                iterator.remove();
                continue;
            }
            this.failsValueNullFree(var5_5);
        }
    }

    private void failsValueNullFree(Object object) {
        if (object == null) {
            throw NullFreeException.createForValue();
        }
    }

    private void failsElementsNullFree(com.jronimo.collections.collection.types.Collection<?> collection) {
        for (Object obj : collection) {
            if (obj != null) continue;
            throw NullFreeException.createForCollection();
        }
    }

    @Override
    public boolean isNullFree() {
        return true;
    }

    @Override
    public boolean isValidValue(E e) {
        boolean bl = false;
        if (e != null) {
            bl = this.wrapped.isValidValue(e);
        }
        return bl;
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        this.failsValueNullFree(e);
        bl = this.wrapped.add(e);
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        this.failsElementsNullFree((com.jronimo.collections.collection.types.Collection)collection);
        bl = this.wrapped.addAll(collection);
        return bl;
    }

    @Override
    public void add(int n, E e) {
        this.failsValueNullFree(e);
        this.wrapped.add(n, e);
    }

    @Override
    public boolean addBefore(Object object, E e) {
        boolean bl = false;
        this.failsValueNullFree(e);
        bl = this.wrapped.addBefore(object, e);
        return bl;
    }

    @Override
    public boolean addAfter(Object object, E e) {
        boolean bl = false;
        this.failsValueNullFree(e);
        bl = this.wrapped.addAfter(object, e);
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = false;
        this.failsElementsNullFree((com.jronimo.collections.collection.types.Collection)collection);
        bl = this.wrapped.addAll(n, collection);
        return bl;
    }

    @Override
    public E set(int n, E e) {
        E e2 = null;
        this.failsValueNullFree(e);
        e2 = this.wrapped.set(n, e);
        return e2;
    }

    @Override
    public boolean set(Object object, E e) {
        boolean bl = false;
        this.failsValueNullFree(e);
        bl = this.wrapped.set(object, e);
        return bl;
    }

    public static <E> com.jronimo.collections.collection.types.Collection<E> decorate(com.jronimo.collections.collection.types.Collection<E> collection) {
        com.jronimo.collections.collection.types.Collection<E> collection2 = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        collection2 = DecoratorChain.decorate(collection, new DecoratorChain.DecorationStruct(DecoratorRegistry.getDecoratorConfig(NullFreeDecorator.class)));
        return collection2;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(NullFreeDecorator.class, NullFreeCollection.class));
    }
}

