/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.collection.hidden.decorators.AbstractSizeDecorator;
import com.jronimo.collections.collection.hidden.decorators.Decorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorRegistry;
import com.jronimo.collections.collection.types.surf.FixedSizeCollection;
import com.jronimo.collections.exceptions.MaxSizeException;
import com.jronimo.collections.exceptions.MinSizeException;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FixedSizeDecorator<E>
extends AbstractSizeDecorator<E>
implements FixedSizeCollection<E> {
    private CollectionParameters.FixedSize fixedSize;

    FixedSizeDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain, CollectionParameters.FixedSize fixedSize) {
        super(collection, decoratorChain);
        this.fixedSize = fixedSize;
        this.checkSize(collection.size());
    }

    @Override
    protected void checkSize(int n) {
        if (this.fixedSize != null) {
            if (this.fixedSize.failsMinSize(n)) {
                throw new MinSizeException(this.fixedSize.getMinSize());
            }
            if (this.fixedSize.failsMaxSize(n)) {
                throw new MaxSizeException(this.fixedSize.getMaxSize());
            }
        }
    }

    @Override
    protected Decorator<E> getSuperClassInstance() {
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        this.checkSize(this.orderedCollection.size() + 1);
        bl = this.wrapped.add(e);
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        this.checkSize(this.orderedCollection.size() + collection.size());
        bl = this.wrapped.addAll(collection);
        return bl;
    }

    @Override
    public void add(int n, E e) {
        this.checkSize(this.orderedCollection.size() + 1);
        this.wrapped.add(n, e);
    }

    @Override
    public boolean addBefore(Object object, E e) {
        boolean bl = false;
        if (this.orderedCollection.contains(object)) {
            this.checkSize(this.orderedCollection.size() + 1);
        }
        bl = this.wrapped.addBefore(object, e);
        return bl;
    }

    @Override
    public boolean addAfter(Object object, E e) {
        boolean bl = false;
        if (this.orderedCollection.contains(object)) {
            this.checkSize(this.orderedCollection.size() + 1);
        }
        bl = this.wrapped.addAfter(object, e);
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = false;
        this.checkSize(this.orderedCollection.size() + collection.size());
        bl = this.wrapped.addAll(n, collection);
        return bl;
    }

    public static <E> com.jronimo.collections.collection.types.Collection<E> decorate(com.jronimo.collections.collection.types.Collection<E> collection, CollectionParameters.FixedSize fixedSize) {
        com.jronimo.collections.collection.types.Collection<E> collection2 = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        Assert.errorParam(fixedSize == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "fixedSize"));
        if (fixedSize.failsMinSize(collection.size())) {
            throw new MinSizeException(fixedSize.getMinSize());
        }
        if (fixedSize.failsMaxSize(collection.size())) {
            throw new MaxSizeException(fixedSize.getMaxSize());
        }
        collection2 = DecoratorChain.decorate(collection, new DecoratorChain.DecorationStruct(DecoratorRegistry.getDecoratorConfig(FixedSizeDecorator.class)).setFixedSize(fixedSize));
        return collection2;
    }

    static {
        DecoratorRegistry.register(new DecoratorConfig(FixedSizeDecorator.class, FixedSizeCollection.class));
    }
}

