/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.collection.CollectionData;
import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.collections.collection.decorations.Factory;
import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.AssertDecorator;
import com.jronimo.collections.collection.hidden.decorators.Decorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorConfig;
import com.jronimo.collections.collection.hidden.decorators.DecoratorInstanceConfig;
import com.jronimo.collections.collection.hidden.decorators.FixedSizeDecorator;
import com.jronimo.collections.collection.hidden.decorators.ImmutableDecorator;
import com.jronimo.collections.collection.hidden.decorators.NullFreeDecorator;
import com.jronimo.collections.collection.hidden.decorators.RestrictedDecorator;
import com.jronimo.collections.collection.hidden.decorators.SetDecorator;
import com.jronimo.collections.collection.hidden.decorators.SortingDecorator;
import com.jronimo.collections.collection.hidden.decorators.SynchronizedDecorator;
import com.jronimo.collections.collection.hidden.decorators.TransactionDecorator;
import com.jronimo.collections.collection.hidden.decorators.UnemptyDecorator;
import com.jronimo.collections.collection.hidden.impl.AbstractCollection;
import com.jronimo.collections.collection.hidden.impl.InstanceTypeBase;
import com.jronimo.collections.collection.hidden.impl.OrderedCollection;
import com.jronimo.collections.collection.hidden.impl.PackageProxy;
import com.jronimo.collections.collection.types.Collection;
import com.jronimo.collections.collection.types.ImmutableCollection;
import com.jronimo.collections.collection.types.ListCollection;
import com.jronimo.collections.collection.types.MutableCollection;
import com.jronimo.collections.collection.types.SetCollection;
import com.jronimo.collections.collection.types.nullfree.NullFreeCollection;
import com.jronimo.collections.collection.types.surf.FixedSizeCollection;
import com.jronimo.collections.collection.types.surf.RestrictedCollection;
import com.jronimo.collections.collection.types.surf.SortingCollection;
import com.jronimo.collections.collection.types.surf.UnemptyCollection;
import com.jronimo.util.ClassHierarchy;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecoratorChain<E>
extends AbstractDecorator<E> {
    private OrderedCollection<E> orderedCollection;
    private CollectionParameters parameters;
    private Set<Class> classes;
    private Set<DecoratorInstanceConfig<E>> chainHierarchy;

    public DecoratorChain(OrderedCollection<E> orderedCollection, CollectionParameters collectionParameters, Class clazz) {
        super(DecoratorChain.class);
        this.commonInit(orderedCollection, collectionParameters, new ClassHierarchy(clazz).getClasses());
    }

    private DecoratorChain(OrderedCollection<E> orderedCollection, CollectionParameters collectionParameters, Set<Class> set) {
        super(DecoratorChain.class);
        this.commonInit(orderedCollection, collectionParameters, set);
    }

    private void commonInit(OrderedCollection<E> orderedCollection, CollectionParameters collectionParameters, Set<Class> set) {
        this.orderedCollection = orderedCollection;
        this.parameters = collectionParameters;
        this.classes = set;
        this.wrapped = this.decorateOrderedCollection();
        this.decoratorChain = this;
        this.chainHierarchy = this.assembleChainHierarchy();
    }

    private Collection<E> decorateOrderedCollection() {
        Collection<E> collection = null;
        this.orderedCollection.setReturnInstanceFactory(new ReturnInstanceFactory(this.parameters, this.classes));
        collection = this.orderedCollection;
        if (this.classes.contains(UnemptyCollection.class)) {
            collection = new UnemptyDecorator<E>(collection, this);
        }
        if (this.classes.contains(FixedSizeCollection.class)) {
            collection = new FixedSizeDecorator<E>(collection, this, this.parameters.getFixedSize());
        }
        if (this.classes.contains(SetCollection.class)) {
            collection = new SetDecorator<E>(collection, this);
        }
        if (this.classes.contains(RestrictedCollection.class)) {
            collection = new RestrictedDecorator<E>(collection, this, this.parameters.getRestrictions());
        }
        if (this.classes.contains(NullFreeCollection.class)) {
            collection = new NullFreeDecorator<E>(collection, this, this.parameters.getConstructionFailSilentNullFree());
        }
        if (this.classes.contains(SortingCollection.class)) {
            collection = new SortingDecorator<E>(collection, this);
        }
        collection = new AssertDecorator<E>(collection, this);
        if (this.classes.contains(ImmutableCollection.class)) {
            collection = new ImmutableDecorator<E>(collection, this);
        }
        collection = new TransactionDecorator<E>(collection, this);
        if (this.parameters.getUseSynchronization()) {
            collection = new SynchronizedDecorator<E>(collection, this);
        }
        return collection;
    }

    OrderedCollection<E> getOrderedCollection() {
        return this.orderedCollection;
    }

    boolean hasDecorator(Class clazz) {
        return this.getDecoratorClasses().contains(clazz);
    }

    private Set<Class> getDecoratorClasses() {
        HashSet<Class> hashSet = null;
        hashSet = new HashSet<Class>(this.chainHierarchy.size());
        for (DecoratorInstanceConfig<E> decoratorInstanceConfig : this.chainHierarchy) {
            hashSet.add(decoratorInstanceConfig.getDecoratorClass());
        }
        return hashSet;
    }

    private Set<Class> getAssociatedTypes() {
        HashSet<Class> hashSet = null;
        hashSet = new HashSet<Class>(this.chainHierarchy.size());
        for (DecoratorInstanceConfig<E> decoratorInstanceConfig : this.chainHierarchy) {
            hashSet.add(decoratorInstanceConfig.getAssociatedType());
        }
        return hashSet;
    }

    private Set<DecoratorInstanceConfig<E>> assembleChainHierarchy() {
        Set set = null;
        Collection collection = null;
        Decorator decorator = null;
        set = SetUtils.orderedSet(new HashSet());
        collection = this.wrapped;
        while (collection instanceof Decorator) {
            decorator = (Decorator)collection;
            set.add(decorator.getDecoratorInstanceConfig());
            collection = decorator.getDecorated();
        }
        return set;
    }

    static <E> Collection<E> decorate(Collection<E> collection, DecorationStruct decorationStruct) {
        DecoratorChain<E> decoratorChain = null;
        DecoratorChain decoratorChain2 = null;
        OrderedCollection<E> orderedCollection = null;
        CollectionParameters collectionParameters = null;
        Set<Class> set = null;
        if (collection instanceof InstanceTypeBase) {
            decoratorChain2 = PackageProxy.extractDecoratorChain((InstanceTypeBase)collection);
            set = new ClassHierarchy(collection.getClass()).getClasses();
        } else {
            decoratorChain2 = (DecoratorChain)collection;
            set = super.getAssociatedTypes();
        }
        orderedCollection = decoratorChain2.orderedCollection;
        collectionParameters = decoratorChain2.parameters;
        if (decorationStruct.decoratorConfig.getAssociatedType() != null) {
            set.add(decorationStruct.decoratorConfig.getAssociatedType());
        }
        if (decorationStruct.decoratorConfig.getDecoratorClass().equals(SynchronizedDecorator.class)) {
            collectionParameters.setUseSynchronization(true);
        }
        if (decorationStruct.restrictions != null) {
            collectionParameters.setRestrictions(decorationStruct.restrictions);
        }
        if (decorationStruct.fixedSize != null) {
            collectionParameters.setFixedSize(decorationStruct.fixedSize);
        }
        decoratorChain = new DecoratorChain<E>(orderedCollection, collectionParameters, set);
        return decoratorChain;
    }

    @Override
    public CollectionParameters getCollectionParameters() {
        CollectionParameters collectionParameters = null;
        collectionParameters = this.parameters;
        return collectionParameters;
    }

    @Override
    public CollectionParameters.ComparatorConfig getComparatorConfig() {
        CollectionParameters.ComparatorConfig comparatorConfig = null;
        comparatorConfig = this.parameters.getComparatorConfig();
        return comparatorConfig;
    }

    @Override
    public Comparator getComparator() {
        Comparator comparator = null;
        comparator = this.parameters.getComparatorConfig().getComparator();
        return comparator;
    }

    @Override
    public CollectionParameters.Restrictions getRestrictions() {
        CollectionParameters.Restrictions restrictions = null;
        restrictions = this.parameters.getRestrictions();
        return restrictions;
    }

    @Override
    public CollectionParameters.FixedSize getFixedSize() {
        CollectionParameters.FixedSize fixedSize = null;
        fixedSize = this.parameters.getFixedSize();
        return fixedSize;
    }

    @Override
    public boolean hasComparator() {
        boolean bl = false;
        bl = this.getComparator() != null;
        return bl;
    }

    @Override
    public boolean hasRestrictions() {
        boolean bl = false;
        bl = this.getRestrictions() != null && this.getRestrictions().hasRestrictions();
        return bl;
    }

    @Override
    public boolean hasFixedSized() {
        boolean bl = false;
        bl = this.getFixedSize() != null && this.getFixedSize().hasFixedSize();
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecorationStruct<E> {
        public DecoratorConfig<E> decoratorConfig;
        public CollectionParameters.Restrictions restrictions;
        public CollectionParameters.FixedSize fixedSize;

        public DecorationStruct(DecoratorConfig<E> decoratorConfig) {
            this.decoratorConfig = decoratorConfig;
        }

        public DecorationStruct setRestrictions(CollectionParameters.Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public DecorationStruct setFixedSize(CollectionParameters.FixedSize fixedSize) {
            this.fixedSize = fixedSize;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReturnInstanceFactory<E>
    implements AbstractCollection.ReturnInstanceFactory<E> {
        private CollectionParameters parameters;
        private String collectionClassString;
        private String listClassString;
        private String setClassString;

        private ReturnInstanceFactory(CollectionParameters collectionParameters, Set<Class> set) {
            this.parameters = collectionParameters.typeClone();
            this.parameters.setFixedSize(null);
            this.createClassString(set);
        }

        private void createClassString(Set<Class> set) {
            StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
            String string = null;
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions();
            if (set.contains(NullFreeCollection.class)) {
                stringWrapperWithVoidRegions.append("NullFree");
            }
            if (set.contains(MutableCollection.class)) {
                stringWrapperWithVoidRegions.append("Mutable");
            }
            if (set.contains(ImmutableCollection.class)) {
                stringWrapperWithVoidRegions.append("Immutable");
            }
            stringWrapperWithVoidRegions.append("Xxx_");
            if (set.contains(SortingCollection.class)) {
                stringWrapperWithVoidRegions.append("S");
            }
            if (set.contains(RestrictedCollection.class)) {
                stringWrapperWithVoidRegions.append("R");
            }
            if (stringWrapperWithVoidRegions.endsWith("_")) {
                stringWrapperWithVoidRegions.deleteLast();
            }
            if (set.contains(ListCollection.class)) {
                string = "List";
            } else if (set.contains(SetCollection.class)) {
                string = "Set";
            }
            this.collectionClassString = stringWrapperWithVoidRegions.spawn().replace("Xxx", string).toString();
            this.listClassString = stringWrapperWithVoidRegions.spawn().replace("Xxx", "List").toString();
            this.setClassString = stringWrapperWithVoidRegions.spawn().replace("Xxx", "Set").toString();
        }

        @Override
        public Collection<E> getInstanceForReturn(CollectionData<E> collectionData) {
            return Factory.createInstance(this.collectionClassString, collectionData);
        }

        @Override
        public ListCollection<E> getListInstanceForReturn(CollectionData<E> collectionData) {
            return (ListCollection)Factory.createInstance(this.collectionClassString, collectionData);
        }

        @Override
        public SetCollection<E> getSetInstanceForReturn(CollectionData<E> collectionData) {
            return (SetCollection)Factory.createInstance(this.collectionClassString, collectionData);
        }
    }
}

