/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection.hidden.decorators;

import com.jronimo.collections.MutableList;
import com.jronimo.collections.MutableSet;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.hidden.decorators.AbstractDecorator;
import com.jronimo.collections.collection.hidden.decorators.Decorator;
import com.jronimo.collections.collection.hidden.decorators.DecoratorChain;
import com.jronimo.collections.collection.hidden.decorators.FixedSizeDecorator;
import com.jronimo.collections.collection.hidden.impl.OrderedCollection;
import com.jronimo.collections.collection.hidden.impl.Utils;
import com.jronimo.collections.collection.types.ListCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSizeDecorator<E>
extends AbstractDecorator<E> {
    private static List<?> listCopy;
    private static com.jronimo.collections.collection.types.Collection<?> removedCollection;
    protected OrderedCollection<E> orderedCollection = this.getDecoratorChainInstance().getOrderedCollection();

    AbstractSizeDecorator(com.jronimo.collections.collection.types.Collection<E> collection, DecoratorChain<E> decoratorChain) {
        super(collection, decoratorChain);
    }

    protected abstract void checkSize(int var1);

    protected abstract Decorator<E> getSuperClassInstance();

    @Override
    public void clear() {
        this.checkSize(0);
        this.wrapped.clear();
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = false;
        if (this.orderedCollection.contains(object)) {
            this.checkSize(this.orderedCollection.size() - 1);
        }
        bl = this.wrapped.remove(object);
        return bl;
    }

    @Override
    public E removeBefore(Object object) {
        E e = null;
        if (this.orderedCollection.indexOf(object) > 0) {
            this.checkSize(this.orderedCollection.size() - 1);
        }
        e = this.wrapped.removeBefore(object);
        return e;
    }

    @Override
    public E removeAfter(Object object) {
        E e = null;
        if (CollectionUtils.indexInBounds(this.orderedCollection.indexOf(object), 0, this.orderedCollection.size() - 2, false)) {
            this.checkSize(this.orderedCollection.size() - 1);
        }
        e = this.wrapped.removeAfter(object);
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        ComplexAction_RemoveAll complexAction_RemoveAll = null;
        complexAction_RemoveAll = new ComplexAction_RemoveAll();
        this.doComplexAction(complexAction_RemoveAll, collection);
        bl = complexAction_RemoveAll.getBooleanReturnValue();
        return bl;
    }

    @Override
    public boolean removeAll(Object ... objectArray) {
        boolean bl = false;
        ComplexAction_RemoveAll complexAction_RemoveAll = null;
        complexAction_RemoveAll = new ComplexAction_RemoveAll();
        this.doComplexAction(complexAction_RemoveAll, new MutableList<Object>(objectArray));
        bl = complexAction_RemoveAll.getBooleanReturnValue();
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        ComplexAction_RetainAll complexAction_RetainAll = null;
        complexAction_RetainAll = new ComplexAction_RetainAll();
        this.doComplexAction(complexAction_RetainAll, collection);
        bl = complexAction_RetainAll.getBooleanReturnValue();
        return bl;
    }

    @Override
    public boolean retainAll(Object ... objectArray) {
        boolean bl = false;
        ComplexAction_RetainAll complexAction_RetainAll = null;
        complexAction_RetainAll = new ComplexAction_RetainAll();
        this.doComplexAction(complexAction_RetainAll, new MutableSet<Object>(objectArray));
        bl = complexAction_RetainAll.getBooleanReturnValue();
        return bl;
    }

    @Override
    public ListCollection<E> removeDuplicates() {
        ListCollection listCollection = null;
        ComplexAction_RemoveDuplicates complexAction_RemoveDuplicates = null;
        complexAction_RemoveDuplicates = new ComplexAction_RemoveDuplicates();
        this.doComplexAction(complexAction_RemoveDuplicates, null);
        listCollection = complexAction_RemoveDuplicates.getRemovedCollection();
        return listCollection;
    }

    @Override
    public ListCollection<E> removeAllDuplicates() {
        ListCollection listCollection = null;
        ComplexAction_RemoveAllDuplicates complexAction_RemoveAllDuplicates = null;
        complexAction_RemoveAllDuplicates = new ComplexAction_RemoveAllDuplicates();
        this.doComplexAction(complexAction_RemoveAllDuplicates, null);
        listCollection = complexAction_RemoveAllDuplicates.getRemovedCollection();
        return listCollection;
    }

    @Override
    public E remove(int n) {
        E e = null;
        this.checkSize(this.orderedCollection.size() - 1);
        e = this.wrapped.remove(n);
        return e;
    }

    @Override
    public E removeFromLast(int n) {
        E e = null;
        this.checkSize(this.orderedCollection.size() - 1);
        e = this.wrapped.removeFromLast(n);
        return e;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n) {
        com.jronimo.collections.collection.types.Collection collection = null;
        this.checkSize(n);
        collection = this.wrapped.removeAllFrom(n);
        return collection;
    }

    @Override
    public com.jronimo.collections.collection.types.Collection<E> removeAllFrom(int n, int n2) {
        com.jronimo.collections.collection.types.Collection collection = null;
        this.checkSize(this.orderedCollection.size() - (n2 - n));
        collection = this.wrapped.removeAllFrom(n, n2);
        return collection;
    }

    @Override
    public E removeFirst() {
        E e = null;
        this.checkSize(this.orderedCollection.size() - 1);
        e = this.wrapped.removeFirst();
        return e;
    }

    @Override
    public E removeLast() {
        E e = null;
        this.checkSize(this.orderedCollection.size() - 1);
        e = this.wrapped.removeLast();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doComplexAction(ComplexAction<E> complexAction, Collection<?> collection) {
        List<?> list = null;
        list = listCopy;
        if (list == null) {
            list = new ArrayList(this.orderedCollection.getList());
            complexAction.processListCopy(list, collection);
            listCopy = list;
            removedCollection = complexAction.getRemovedCollection();
        } else {
            complexAction.setRemovedCollection((ListCollection)removedCollection);
        }
        this.checkSize(list.size());
        try {
            if (list.size() != this.orderedCollection.size()) {
                if (this.getSuperClassInstance() instanceof FixedSizeDecorator) {
                    this.orderedCollection.commitNewList(list);
                    complexAction.setBooleanReturnValue(true);
                } else {
                    complexAction.propagate(collection);
                }
            }
        }
        finally {
            listCopy = null;
            removedCollection = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComplexAction_RemoveAllDuplicates<E>
    extends AbstractComplexAction<E> {
        ComplexAction_RemoveAllDuplicates() {
        }

        @Override
        public void processListCopy(List<E> list, Collection<?> collection) {
            this.removedCollection = list.size() > 1 ? Utils.removeAllDuplicates(list, AbstractSizeDecorator.this.orderedCollection.getDuplicates()) : new MutableList(0);
        }

        @Override
        public void propagate(Collection<?> collection) {
            this.removedCollection = AbstractSizeDecorator.this.wrapped.removeAllDuplicates();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComplexAction_RemoveDuplicates<E>
    extends AbstractComplexAction<E> {
        ComplexAction_RemoveDuplicates() {
        }

        @Override
        public void processListCopy(List<E> list, Collection<?> collection) {
            this.removedCollection = list.size() > 1 ? Utils.removeDuplicates(list) : new MutableList(0);
        }

        @Override
        public void propagate(Collection<?> collection) {
            this.removedCollection = AbstractSizeDecorator.this.wrapped.removeDuplicates();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComplexAction_RetainAll<E>
    extends AbstractComplexAction<E> {
        ComplexAction_RetainAll() {
        }

        @Override
        public void processListCopy(List<E> list, Collection<?> collection) {
            list.retainAll(collection);
        }

        @Override
        public void propagate(Collection<?> collection) {
            this.booleanReturnValue = AbstractSizeDecorator.this.wrapped.retainAll(collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComplexAction_RemoveAll<E>
    extends AbstractComplexAction<E> {
        ComplexAction_RemoveAll() {
        }

        @Override
        public void processListCopy(List<E> list, Collection<?> collection) {
            list.removeAll(collection);
        }

        @Override
        public void propagate(Collection<?> collection) {
            this.booleanReturnValue = AbstractSizeDecorator.this.wrapped.removeAll(collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractComplexAction<E>
    implements ComplexAction<E> {
        protected boolean booleanReturnValue;
        protected ListCollection<E> removedCollection;

        AbstractComplexAction() {
        }

        @Override
        public void setBooleanReturnValue(boolean bl) {
            this.booleanReturnValue = bl;
        }

        @Override
        public boolean getBooleanReturnValue() {
            return this.booleanReturnValue;
        }

        @Override
        public void setRemovedCollection(ListCollection<E> listCollection) {
            this.removedCollection = listCollection;
        }

        @Override
        public ListCollection<E> getRemovedCollection() {
            return this.removedCollection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ComplexAction<E> {
        public void processListCopy(List<E> var1, Collection<?> var2);

        public void propagate(Collection<?> var1);

        public void setBooleanReturnValue(boolean var1);

        public boolean getBooleanReturnValue();

        public void setRemovedCollection(ListCollection<E> var1);

        public ListCollection<E> getRemovedCollection();
    }
}

