/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection;

import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static final Logger logger = Logger.getLogger(CollectionUtils.class);

    private CollectionUtils() {
    }

    public static List<Object>[] split(List<Object> list, int n) {
        int n2;
        ArrayList[] arrayListArray = null;
        arrayListArray = new ArrayList[]{new ArrayList(n - 0), new ArrayList(list.size() - n)};
        for (n2 = 0; n2 < n; ++n2) {
            arrayListArray[0].add(list.get(n2));
        }
        for (n2 = n; n2 < list.size(); ++n2) {
            arrayListArray[1].add(list.get(n2));
        }
        return arrayListArray;
    }

    public static Set arrayToSet(Object[] objectArray) {
        Set set = null;
        if (objectArray != null) {
            set = CollectionUtils.getOrderedSet(new HashSet(objectArray.length));
            for (Object object : objectArray) {
                set.add(object);
            }
        }
        return CollectionUtils.arrayToSet(objectArray, false);
    }

    public static Set arrayToSet(Object[] objectArray, boolean bl) {
        Set set = null;
        if (objectArray == null && bl) {
            objectArray = new Object[]{};
        }
        if (objectArray != null) {
            set = CollectionUtils.getOrderedSet(new HashSet(objectArray.length));
            for (Object object : objectArray) {
                set.add(object);
            }
        }
        return set;
    }

    public static List arrayToList(Object[] objectArray) {
        ArrayList<Object> arrayList = null;
        if (objectArray != null) {
            arrayList = new ArrayList<Object>(objectArray.length);
            for (Object object : objectArray) {
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public static Set collectionToSet(Collection collection) {
        Set set = null;
        if (collection != null) {
            set = CollectionUtils.getOrderedSet(collection.size());
            set.addAll(collection);
        }
        return set;
    }

    public static List collectionToList(Collection collection) {
        ArrayList arrayList = null;
        if (collection != null) {
            arrayList = new ArrayList(collection.size());
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static void reverseCollection(Collection collection) {
        ArrayList arrayList = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        if (collection != null) {
            arrayList = new ArrayList(collection.size());
            for (Object e : collection) {
                arrayList.add(0, e);
            }
            collection.clear();
            collection.addAll(arrayList);
        }
    }

    public static boolean containsOnly(Collection collection, Object[] objectArray) {
        boolean bl = true;
        Set set = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        Assert.errorParam(Methods.isEmpty(objectArray), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "allowables"));
        if (collection.size() == 0) {
            bl = false;
        } else {
            set = CollectionUtils.arrayToSet(objectArray);
            for (Object e : collection) {
                if (set.contains(e)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static Object getRandomMember(Collection collection) {
        Object object = null;
        int n = 0;
        int n2 = -1;
        Assert.errorParam(Methods.isEmpty(collection), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "collection"));
        if (collection.size() == 1) {
            object = CollectionUtils.getCollectionElement(collection, 0);
        } else {
            n = (int)Methods.getRandomNumber(0L, collection.size() - 1);
            if (collection instanceof List) {
                object = ((List)collection).get(n);
            } else {
                for (Object e : collection) {
                    if (++n2 != n) continue;
                    object = e;
                    break;
                }
            }
        }
        return object;
    }

    public static Object getFromCollection(Collection collection, Object object) {
        Object var2_2 = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        Assert.errorParam(object == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "searchObject"));
        for (Object e : collection) {
            if (!object.equals(e)) continue;
            var2_2 = e;
            break;
        }
        return var2_2;
    }

    public static boolean hasDuplicate(Collection collection) {
        boolean bl = false;
        ArrayList arrayList = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        arrayList = new ArrayList();
        for (Object e : collection) {
            if (arrayList.contains(e)) {
                bl = true;
                break;
            }
            arrayList.add(e);
        }
        return bl;
    }

    public static Object getDuplicate(Collection collection) {
        Object var1_1 = null;
        ArrayList arrayList = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        arrayList = new ArrayList();
        for (Object e : collection) {
            if (arrayList.contains(e)) {
                var1_1 = e;
                break;
            }
            arrayList.add(e);
        }
        return var1_1;
    }

    public static String collectionToCommaDelimitedList(Collection collection) {
        StringBuilder stringBuilder = null;
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        stringBuilder = new StringBuilder();
        for (Object e : collection) {
            stringBuilder.append(e);
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static byte[] concatArrays(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        byte[] byArray3 = null;
        int n4 = 0;
        Assert.errorParam(byArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "master"));
        Assert.errorParam(byArray2 == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "moreBytes"));
        Assert.errorParam(n < 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "offset", String.valueOf(n), "0"));
        Assert.errorParam(n >= byArray2.length, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_LESS_THAN_LENGTH_OF, "offset", String.valueOf(n), "moreBytes"));
        Assert.errorParam(n2 < 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_GREATER_THAN_OR_EQUAL_TO, "length", String.valueOf(n2), "0"));
        Assert.errorParam(n2 >= byArray2.length, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_LESS_THAN_LENGTH_OF, "length", String.valueOf(n2), "moreBytes"));
        Assert.errorParam(n + n2 >= byArray2.length, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_BE_LESS_THAN_LENGTH_OF, "offset + length", String.valueOf(n + n2), "moreBytes"));
        byArray3 = new byte[byArray.length + n2];
        n4 = byArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            byArray3[n3] = byArray[n3];
        }
        int n5 = n + n2;
        for (n3 = n; n3 < n5; ++n3) {
            byArray3[n4 + n3] = byArray2[n3];
        }
        return byArray3;
    }

    public static Map getImmutableMap() {
        return MapUtils.unmodifiableMap(new HashMap());
    }

    public static Map getImmutableMap(Map map) {
        Map map2 = null;
        Assert.errorParam(map == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "map"));
        map2 = MapUtils.unmodifiableMap((Map)CollectionUtils.copyOrderedMap(map));
        return map2;
    }

    public static Map getOrderedMap() {
        return MapUtils.orderedMap(new HashMap());
    }

    public static Map getOrderedMap(int n) {
        return MapUtils.orderedMap(new HashMap(n));
    }

    public static Map getOrderedMap(Map map) {
        Map map2 = null;
        Assert.errorParam(map == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "map"));
        map2 = MapUtils.orderedMap((Map)map);
        return map2;
    }

    public static Set getOrderedSet() {
        return SetUtils.orderedSet(new HashSet());
    }

    public static Set getOrderedSet(int n) {
        return SetUtils.orderedSet(new HashSet(n));
    }

    public static Set getOrderedSet(Set set) {
        Set set2 = null;
        Assert.errorParam(set == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "set"));
        set2 = SetUtils.orderedSet((Set)set);
        return set2;
    }

    public static Set getOrderedSet(Object[] objectArray) {
        Set set = null;
        Assert.errorParam(objectArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "array"));
        set = CollectionUtils.getOrderedSet(new HashSet(objectArray.length));
        CollectionUtils.addAll(set, objectArray);
        return set;
    }

    public static Map copyOrderedMap(Map map) {
        return map == null ? null : CollectionUtils.getOrderedMap(new HashMap(map));
    }

    public static Set copyOrderedSet(Set set) {
        return set == null ? null : CollectionUtils.getOrderedSet(new HashSet(set));
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        Assert.errorParam(objectArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "array"));
        for (Object object : objectArray) {
            collection.add(object);
        }
    }

    public static List setToList(Set set) {
        ArrayList arrayList = null;
        Iterator iterator = null;
        arrayList = new ArrayList(set.size());
        iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static void sortCollection(Collection collection) {
        ArrayList arrayList = null;
        if (collection instanceof List) {
            Collections.sort((List)collection);
        } else {
            arrayList = new ArrayList(collection.size());
            arrayList.addAll(collection);
            Collections.sort(arrayList);
            collection.clear();
            collection.addAll(arrayList);
        }
    }

    public static Object getCollectionElement(Collection collection, int n) {
        Object var2_2 = null;
        int n2 = -1;
        if (!Methods.isEmpty(collection)) {
            Assert.errorParam(n < 0 || n >= collection.size(), new ResourceTextPointer((Object)ResourceTextIdentifiers.INDEX_OUT_OF_BOUNDS, n, 0, collection.size() - 1));
            for (Object e : collection) {
                if (++n2 != n) continue;
                var2_2 = e;
                break;
            }
        }
        return var2_2;
    }

    public static boolean indexInBounds(int n, int n2, int n3, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = bl2 = n >= n2 && n <= n3;
        if (bl) {
            Assert.errorParam(!bl2, new ResourceTextPointer((Object)ResourceTextIdentifiers.INDEX_OUT_OF_BOUNDS, n, n2, n3), IndexOutOfBoundsException.class);
        }
        return bl2;
    }

    public static boolean indexInBounds(boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = bl3 = !bl;
        if (bl2) {
            Assert.errorParam(!bl3, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY_CURRENT_INSTANCE), IndexOutOfBoundsException.class);
        }
        return bl3;
    }

    public static int getIdealCapacity(int n, int n2, int n3) {
        return Math.max(n2, n3 / n);
    }

    public static boolean areIdentical(Collection collection, Collection collection2) {
        boolean bl = false;
        if (collection == null && collection2 == null) {
            bl = true;
        } else if (collection != null && collection2 != null && collection.size() == collection2.size()) {
            bl = true;
            for (Object e : collection) {
                if (collection2.contains(e)) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (Object e : collection2) {
                    if (collection.contains(e)) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }
}

