/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.collections.collection;

import com.jronimo.collections.collection.CollectionParameters;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionData<E> {
    private List<E> data;
    private CollectionParameters parameters = new CollectionParameters();

    public CollectionData() {
        this.data = new ArrayList(0);
    }

    public CollectionData(Collection<E> collection) {
        Assert.errorParam(collection == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "collection"));
        this.data = new ArrayList<E>(collection);
    }

    public CollectionData(E ... EArray) {
        ArrayList<E> arrayList = null;
        Assert.errorParam(EArray == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "array"));
        arrayList = new ArrayList<E>(EArray.length);
        for (E e : EArray) {
            arrayList.add(e);
        }
        this.data = arrayList;
    }

    private CollectionData(List<E> list) {
        this.data = list;
    }

    public List<E> getData() {
        return new ArrayList<E>(this.data);
    }

    public CollectionData<E> setCapacity(int n) {
        this.parameters.setCapacity(n);
        return this;
    }

    public CollectionData<E> setParameters(CollectionParameters collectionParameters) {
        Assert.errorParamMustNotBeNull("value", collectionParameters);
        this.parameters = collectionParameters;
        return this;
    }

    public CollectionParameters getParameters() {
        return this.parameters;
    }

    public Object clone() {
        return this.typeClone();
    }

    public CollectionData<E> typeClone() {
        CollectionData<E> collectionData = null;
        collectionData = new CollectionData<E>(this.data);
        collectionData.data = this.data;
        collectionData.parameters = (CollectionParameters)this.parameters.clone();
        return collectionData;
    }
}

