/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.chores.objectmodel;

import com.jronimo.chores.Constants;
import com.jronimo.temporal.Date;
import com.jronimo.temporal.TimeOfDay;
import com.jronimo.util.Logger;

public final class Chore
implements Comparable {
    private static final Logger logger = Logger.getLogger(Chore.class);
    private Long id;
    private String description;
    private Constants.Frequency frequency;
    private Object dayNumber;
    private int daysBetween;
    private TimeOfDay doneBy;
    private String dayPart;
    private boolean optional;
    private Date lastCompleted;
    private boolean active;

    public Chore(Long l, String string, Constants.Frequency frequency, Object object, int n, TimeOfDay timeOfDay, String string2, boolean bl, Date date, boolean bl2) {
        this.id = l;
        this.description = string;
        this.frequency = frequency;
        this.dayNumber = object;
        this.daysBetween = n;
        this.doneBy = timeOfDay;
        this.dayPart = string2;
        this.optional = bl;
        this.lastCompleted = date;
        this.active = bl2;
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasFrequency() {
        return this.frequency != null;
    }

    public Constants.Frequency getFrequency() {
        return this.frequency;
    }

    public boolean hasDayNumber() {
        return this.dayNumber != null;
    }

    public int getDayNumberAsInt() {
        return (Integer)this.dayNumber;
    }

    public Date getDayNumberAsDate() {
        return (Date)this.dayNumber;
    }

    public String getDayNumberAsString() {
        String string = null;
        string = this.dayNumber == null ? "0" : this.dayNumber.toString();
        return string;
    }

    public boolean hasDaysBetween() {
        return this.daysBetween > 0;
    }

    public int getDaysBetween() {
        return this.daysBetween;
    }

    public boolean hasDoneBy() {
        return this.doneBy != null;
    }

    public TimeOfDay getDoneBy() {
        return this.doneBy;
    }

    public String getDayPart() {
        return this.dayPart;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public void setLastCompleted(Date date) {
        this.lastCompleted = date;
    }

    public Date getLastCompleted() {
        return this.lastCompleted;
    }

    public boolean getActive() {
        return this.active;
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Chore chore = null;
        if (object instanceof Chore) {
            chore = (Chore)object;
            if (chore.description.equalsIgnoreCase(this.description)) {
                bl = true;
            }
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = 0;
        Chore chore = null;
        int n2 = 0;
        int n3 = 0;
        if (object instanceof Chore) {
            chore = (Chore)object;
            if (this.dayPart.equals("AM") && chore.dayPart.equals("PM")) {
                n = -1;
            } else if (this.dayPart.equals("PM") && chore.dayPart.equals("AM")) {
                n = 1;
            } else {
                if (this.frequency != null) {
                    n2 = this.frequency.getId();
                }
                if (chore.frequency != null) {
                    n3 = chore.frequency.getId();
                }
                n = n2 == 0 && n3 != 0 ? 1 : (n2 != 0 && n3 == 0 ? -1 : n2 - n3);
            }
        }
        return n;
    }
}

