/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.apache.xerces.dom3.ls.DOMImplementationLS;
import org.apache.xerces.dom3.ls.DOMWriter;
import org.apache.xerces.dom3.ls.DocumentLS;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends CoreDocumentImpl
implements DocumentTraversal,
DocumentEvent,
DocumentRange,
DocumentLS {
    static final long serialVersionUID = 515687835542616694L;
    protected Vector iterators;
    protected Vector ranges;
    protected Hashtable eventListeners;
    protected boolean mutationEvents = false;
    EnclosingAttr savedEnclosingAttr;

    public DocumentImpl() {
    }

    public DocumentImpl(boolean grammarAccess) {
        super(grammarAccess);
    }

    public DocumentImpl(DocumentType doctype) {
        super(doctype);
    }

    public DocumentImpl(DocumentType doctype, boolean grammarAccess) {
        super(doctype, grammarAccess);
    }

    public Node cloneNode(boolean deep) {
        DocumentImpl newdoc = new DocumentImpl();
        this.callUserDataHandlers(this, newdoc, (short)1);
        this.cloneNode(newdoc, deep);
        newdoc.mutationEvents = this.mutationEvents;
        return newdoc;
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public NodeIterator createNodeIterator(Node root, short whatToShow, NodeFilter filter) {
        return this.createNodeIterator(root, whatToShow, filter, true);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        NodeIteratorImpl iterator = new NodeIteratorImpl(this, root, whatToShow, filter, entityReferenceExpansion);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(iterator);
        return iterator;
    }

    public TreeWalker createTreeWalker(Node root, short whatToShow, NodeFilter filter) {
        return this.createTreeWalker(root, whatToShow, filter, true);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) {
        if (root == null) {
            throw new DOMException(9, "DOM007 Not supported");
        }
        return new TreeWalkerImpl(root, whatToShow, filter, entityReferenceExpansion);
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.iterators.removeElement(nodeIterator);
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl range = new RangeImpl(this);
        this.ranges.addElement(range);
        return range;
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.ranges.removeElement(range);
    }

    void replacedText(NodeImpl node) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveReplacedText(node);
            }
        }
    }

    void deletedText(NodeImpl node, int offset, int count) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveDeletedText(node, offset, count);
            }
        }
    }

    void insertedText(NodeImpl node, int offset, int count) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveInsertedText(node, offset, count);
            }
        }
    }

    void splitData(Node node, Node newNode, int offset) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveSplitData(node, newNode, offset);
            }
        }
    }

    public Event createEvent(String type) throws DOMException {
        if (type.equalsIgnoreCase("Events") || "Event".equals(type)) {
            return new EventImpl();
        }
        if (type.equalsIgnoreCase("MutationEvents") || "MutationEvent".equals(type)) {
            return new MutationEventImpl();
        }
        throw new DOMException(9, "DOM007 Not supported");
    }

    void setMutationEvents(boolean set) {
        this.mutationEvents = set;
    }

    boolean getMutationEvents() {
        return this.mutationEvents;
    }

    protected void setEventListeners(NodeImpl n, Vector listeners) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        if (listeners == null) {
            this.eventListeners.remove(n);
            if (this.eventListeners.isEmpty()) {
                this.mutationEvents = false;
            }
        } else {
            this.eventListeners.put(n, listeners);
            this.mutationEvents = true;
        }
    }

    protected Vector getEventListeners(NodeImpl n) {
        if (this.eventListeners == null) {
            return null;
        }
        return (Vector)this.eventListeners.get(n);
    }

    protected void addEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
        if (type == null || type.equals("") || listener == null) {
            return;
        }
        this.removeEventListener(node, type, listener, useCapture);
        Vector<LEntry> nodeListeners = this.getEventListeners(node);
        if (nodeListeners == null) {
            nodeListeners = new Vector<LEntry>();
            this.setEventListeners(node, nodeListeners);
        }
        nodeListeners.addElement(new LEntry(type, listener, useCapture));
        LCount lc = LCount.lookup(type);
        if (useCapture) {
            ++lc.captures;
        } else {
            ++lc.bubbles;
        }
    }

    protected void removeEventListener(NodeImpl node, String type, EventListener listener, boolean useCapture) {
        if (type == null || type.equals("") || listener == null) {
            return;
        }
        Vector nodeListeners = this.getEventListeners(node);
        if (nodeListeners == null) {
            return;
        }
        int i = nodeListeners.size() - 1;
        while (i >= 0) {
            LEntry le = (LEntry)nodeListeners.elementAt(i);
            if (le.useCapture == useCapture && le.listener == listener && le.type.equals(type)) {
                nodeListeners.removeElementAt(i);
                if (nodeListeners.size() == 0) {
                    this.setEventListeners(node, null);
                }
                LCount lc = LCount.lookup(type);
                if (useCapture) {
                    --lc.captures;
                    break;
                }
                --lc.bubbles;
                break;
            }
            --i;
        }
    }

    protected boolean dispatchEvent(NodeImpl node, Event event) {
        LEntry le;
        Vector nl;
        if (event == null) {
            return false;
        }
        EventImpl evt = (EventImpl)event;
        if (!evt.initialized || evt.type == null || evt.type.equals("")) {
            throw new EventException(0, "DOM010 Unspecified event type");
        }
        LCount lc = LCount.lookup(evt.getType());
        if (lc.captures + lc.bubbles + lc.defaults == 0) {
            return evt.preventDefault;
        }
        evt.target = node;
        evt.stopPropagation = false;
        evt.preventDefault = false;
        Vector<Node> pv = new Vector<Node>(10, 10);
        Node p = node;
        Node n = p.getParentNode();
        while (n != null) {
            pv.addElement(n);
            p = n;
            n = n.getParentNode();
        }
        if (lc.captures > 0) {
            evt.eventPhase = 1;
            int j = pv.size() - 1;
            while (j >= 0) {
                if (evt.stopPropagation) break;
                NodeImpl nn = (NodeImpl)pv.elementAt(j);
                evt.currentTarget = nn;
                Vector nodeListeners = this.getEventListeners(nn);
                if (nodeListeners != null) {
                    nl = (Vector)nodeListeners.clone();
                    int i = nl.size() - 1;
                    while (i >= 0) {
                        le = (LEntry)nl.elementAt(i);
                        if (le.useCapture && le.type.equals(evt.type) && nodeListeners.contains(le)) {
                            try {
                                le.listener.handleEvent(evt);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                --j;
            }
        }
        if (lc.bubbles > 0) {
            evt.eventPhase = (short)2;
            evt.currentTarget = node;
            Vector nodeListeners = this.getEventListeners(node);
            if (!evt.stopPropagation && nodeListeners != null) {
                Vector nl2 = (Vector)nodeListeners.clone();
                int i = nl2.size() - 1;
                while (i >= 0) {
                    LEntry le2 = (LEntry)nl2.elementAt(i);
                    if (!le2.useCapture && le2.type.equals(evt.type) && nodeListeners.contains(le2)) {
                        try {
                            le2.listener.handleEvent(evt);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    --i;
                }
            }
            if (evt.bubbles) {
                evt.eventPhase = (short)3;
                int j = 0;
                while (j < pv.size()) {
                    if (evt.stopPropagation) break;
                    NodeImpl nn = (NodeImpl)pv.elementAt(j);
                    evt.currentTarget = nn;
                    nodeListeners = this.getEventListeners(nn);
                    if (nodeListeners != null) {
                        nl = (Vector)nodeListeners.clone();
                        int i = nl.size() - 1;
                        while (i >= 0) {
                            le = (LEntry)nl.elementAt(i);
                            if (!le.useCapture && le.type.equals(evt.type) && nodeListeners.contains(le)) {
                                try {
                                    le.listener.handleEvent(evt);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            --i;
                        }
                    }
                    ++j;
                }
            }
        }
        if (lc.defaults <= 0 || !evt.cancelable || !evt.preventDefault) {
            // empty if block
        }
        return evt.preventDefault;
    }

    protected void dispatchEventToSubtree(NodeImpl node, Node n, Event e) {
        Vector nodeListeners = this.getEventListeners(node);
        if (nodeListeners == null || n == null) {
            return;
        }
        ((NodeImpl)n).dispatchEvent(e);
        if (n.getNodeType() == 1) {
            NamedNodeMap a = n.getAttributes();
            int i = a.getLength() - 1;
            while (i >= 0) {
                this.dispatchEventToSubtree(node, a.item(i), e);
                --i;
            }
        }
        this.dispatchEventToSubtree(node, n.getFirstChild(), e);
        this.dispatchEventToSubtree(node, n.getNextSibling(), e);
    }

    protected void dispatchAggregateEvents(NodeImpl node, EnclosingAttr ea) {
        if (ea != null) {
            this.dispatchAggregateEvents(node, ea.node, ea.oldvalue, (short)1);
        } else {
            this.dispatchAggregateEvents(node, null, null, (short)0);
        }
    }

    protected void dispatchAggregateEvents(NodeImpl node, AttrImpl enclosingAttr, String oldvalue, short change) {
        MutationEventImpl me;
        LCount lc;
        NodeImpl owner = null;
        if (enclosingAttr != null) {
            lc = LCount.lookup("DOMAttrModified");
            owner = (NodeImpl)((Object)enclosingAttr.getOwnerElement());
            if (lc.captures + lc.bubbles + lc.defaults > 0 && owner != null) {
                me = new MutationEventImpl();
                me.initMutationEvent("DOMAttrModified", true, false, enclosingAttr, oldvalue, enclosingAttr.getNodeValue(), enclosingAttr.getNodeName(), change);
                owner.dispatchEvent(me);
            }
        }
        lc = LCount.lookup("DOMSubtreeModified");
        if (lc.captures + lc.bubbles + lc.defaults > 0) {
            me = new MutationEventImpl();
            me.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            if (enclosingAttr != null) {
                this.dispatchEvent(enclosingAttr, me);
                if (owner != null) {
                    this.dispatchEvent(owner, me);
                }
            } else {
                this.dispatchEvent(node, me);
            }
        }
    }

    protected void saveEnclosingAttr(NodeImpl node) {
        this.savedEnclosingAttr = null;
        LCount lc = LCount.lookup("DOMAttrModified");
        if (lc.captures + lc.bubbles + lc.defaults > 0) {
            NodeImpl eventAncestor = node;
            while (true) {
                if (eventAncestor == null) {
                    return;
                }
                short type = eventAncestor.getNodeType();
                if (type == 2) {
                    EnclosingAttr retval = new EnclosingAttr();
                    retval.node = (AttrImpl)eventAncestor;
                    retval.oldvalue = retval.node.getNodeValue();
                    this.savedEnclosingAttr = retval;
                    return;
                }
                if (type != 5) break;
                eventAncestor = eventAncestor.parentNode();
            }
            return;
        }
    }

    void modifyingCharacterData(NodeImpl node) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(node);
        }
    }

    void modifiedCharacterData(NodeImpl node, String oldvalue, String value) {
        if (this.mutationEvents) {
            LCount lc = LCount.lookup("DOMCharacterDataModified");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                MutationEventImpl me = new MutationEventImpl();
                me.initMutationEvent("DOMCharacterDataModified", true, false, null, oldvalue, value, null, (short)0);
                this.dispatchEvent(node, me);
            }
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void insertingNode(NodeImpl node, boolean replace) {
        if (this.mutationEvents && !replace) {
            this.saveEnclosingAttr(node);
        }
    }

    void insertedNode(NodeImpl node, NodeImpl newInternal, boolean replace) {
        if (this.mutationEvents) {
            LCount lc = LCount.lookup("DOMNodeInserted");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                MutationEventImpl me = new MutationEventImpl();
                me.initMutationEvent("DOMNodeInserted", true, false, node, null, null, null, (short)0);
                this.dispatchEvent(newInternal, me);
            }
            lc = LCount.lookup("DOMNodeInsertedIntoDocument");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                NodeImpl eventAncestor = node;
                if (this.savedEnclosingAttr != null) {
                    eventAncestor = (NodeImpl)((Object)this.savedEnclosingAttr.node.getOwnerElement());
                }
                if (eventAncestor != null) {
                    NodeImpl p = eventAncestor;
                    while (p != null) {
                        eventAncestor = p;
                        p = p.getNodeType() == 2 ? (NodeImpl)((Object)((AttrImpl)p).getOwnerElement()) : p.parentNode();
                    }
                    if (eventAncestor.getNodeType() == 9) {
                        MutationEventImpl me = new MutationEventImpl();
                        me.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                        this.dispatchEventToSubtree(node, newInternal, me);
                    }
                }
            }
            if (!replace) {
                this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
            }
        }
    }

    void removingNode(NodeImpl node, NodeImpl oldChild, boolean replace) {
        Enumeration enumeration;
        if (this.iterators != null) {
            enumeration = this.iterators.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration.nextElement()).removeNode(oldChild);
            }
        }
        if (this.ranges != null) {
            enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).removeNode(oldChild);
            }
        }
        if (this.mutationEvents) {
            if (!replace) {
                this.saveEnclosingAttr(node);
            }
            LCount lc = LCount.lookup("DOMNodeRemoved");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                MutationEventImpl me = new MutationEventImpl();
                me.initMutationEvent("DOMNodeRemoved", true, false, node, null, null, null, (short)0);
                this.dispatchEvent(oldChild, me);
            }
            lc = LCount.lookup("DOMNodeRemovedFromDocument");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                NodeImpl eventAncestor = this;
                if (this.savedEnclosingAttr != null) {
                    eventAncestor = (NodeImpl)((Object)this.savedEnclosingAttr.node.getOwnerElement());
                }
                if (eventAncestor != null) {
                    NodeImpl p = eventAncestor.parentNode();
                    while (p != null) {
                        eventAncestor = p;
                        p = p.parentNode();
                    }
                    if (eventAncestor.getNodeType() == 9) {
                        MutationEventImpl me = new MutationEventImpl();
                        me.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                        this.dispatchEventToSubtree(node, oldChild, me);
                    }
                }
            }
        }
    }

    void removedNode(NodeImpl node, boolean replace) {
        if (this.mutationEvents && !replace) {
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void replacingNode(NodeImpl node) {
        if (this.mutationEvents) {
            this.saveEnclosingAttr(node);
        }
    }

    void replacedNode(NodeImpl node) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(node, this.savedEnclosingAttr);
        }
    }

    void modifiedAttrValue(AttrImpl attr, String oldvalue) {
        if (this.mutationEvents) {
            this.dispatchAggregateEvents(attr, attr, oldvalue, (short)1);
        }
    }

    void setAttrNode(AttrImpl attr, AttrImpl previous) {
        if (this.mutationEvents) {
            if (previous == null) {
                this.dispatchAggregateEvents(attr.ownerNode, attr, null, (short)2);
            } else {
                this.dispatchAggregateEvents(attr.ownerNode, attr, previous.getNodeValue(), (short)1);
            }
        }
    }

    void removedAttrNode(AttrImpl attr, NodeImpl oldOwner, String name) {
        if (this.mutationEvents) {
            LCount lc = LCount.lookup("DOMAttrModified");
            if (lc.captures + lc.bubbles + lc.defaults > 0) {
                MutationEventImpl me = new MutationEventImpl();
                me.initMutationEvent("DOMAttrModified", true, false, null, attr.getNodeValue(), null, name, (short)3);
                this.dispatchEvent(oldOwner, me);
            }
            this.dispatchAggregateEvents(oldOwner, null, null, (short)0);
        }
    }

    public boolean getAsync() {
        return false;
    }

    public void setAsync(boolean async) {
        if (async) {
            throw new DOMException(9, "Asynchronous mode is not supported");
        }
    }

    public void abort() {
    }

    public boolean load(String uri) {
        return false;
    }

    public boolean loadXML(String source) {
        return false;
    }

    public String saveXML(Node snode) throws DOMException {
        if (snode != null && this.getOwnerDocument() != snode.getOwnerDocument()) {
            throw new DOMException(4, "Node " + snode.getNodeName() + " does not belongs to this Document.");
        }
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation());
        DOMWriter xmlWriter = domImplLS.createDOMWriter();
        if (snode == null) {
            snode = this;
        }
        return xmlWriter.writeToString(snode);
    }

    class EnclosingAttr {
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
        }
    }

    class LEntry {
        String type;
        EventListener listener;
        boolean useCapture;

        LEntry(String type, EventListener listener, boolean useCapture) {
            this.type = type;
            this.listener = listener;
            this.useCapture = useCapture;
        }
    }
}

