/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.trax.TransformerImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;

public class TransformerHandlerImpl
implements TransformerHandler,
DeclHandler {
    private TransformerImpl _transformer;
    private AbstractTranslet _translet = null;
    private String _systemId;
    private DOMImpl _dom = null;
    private DOMBuilder _handler = null;
    private DTDMonitor _dtd = null;
    private Result _result = null;
    private boolean _done = false;

    protected TransformerHandlerImpl(TransformerImpl transformer) {
        this._transformer = transformer;
        this._translet = this._transformer.getTranslet();
        this._dom = new DOMImpl();
        this._handler = this._dom.getBuilder();
        this._dtd = new DTDMonitor();
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String id) {
        this._systemId = id;
    }

    public Transformer getTransformer() {
        return this._transformer;
    }

    public void setResult(Result result) throws IllegalArgumentException {
        this._result = result;
        if (this._done) {
            try {
                this._transformer.setDOM(this._dom);
                this._transformer.transform(null, this._result);
            }
            catch (TransformerException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._handler.characters(ch, start, length);
    }

    public void startDocument() throws SAXException {
        if (this._result == null) {
            ErrorMsg err = new ErrorMsg(64);
            throw new SAXException(err.toString());
        }
        this._dom.setDocumentURI(this._systemId);
        this._handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this._handler.endDocument();
        if (this._result != null) {
            try {
                this._transformer.setDOM(this._dom);
                this._transformer.setDTDMonitor(this._dtd);
                this._transformer.transform(null, this._result);
            }
            catch (TransformerException e) {
                throw new SAXException(e);
            }
        }
        this._done = true;
        this._transformer.setDOM(this._dom);
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        this._handler.startElement(uri, localName, qname, attributes);
    }

    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        this._handler.endElement(namespaceURI, localName, qname);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this._handler.processingInstruction(target, data);
    }

    public void startCDATA() throws SAXException {
        this._handler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this._handler.endCDATA();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this._handler.comment(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this._handler.ignorableWhitespace(ch, start, length);
    }

    public void setDocumentLocator(Locator locator) {
        this._handler.setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this._handler.skippedEntity(name);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this._handler.endPrefixMapping(prefix);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this._handler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this._handler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this._handler.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this._handler.endEntity(name);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this._dtd.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this._dtd.notationDecl(name, publicId, systemId);
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        this._dtd.attributeDecl(eName, aName, type, valueDefault, value);
    }

    public void elementDecl(String name, String model) throws SAXException {
        this._dtd.elementDecl(name, model);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this._dtd.externalEntityDecl(name, publicId, systemId);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        this._dtd.internalEntityDecl(name, value);
    }
}

