/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.DOMCache;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMAdapter;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.apache.xalan.xsltc.dom.KeyIndex;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.apache.xalan.xsltc.runtime.MessageHandler;
import org.apache.xalan.xsltc.runtime.Parameter;
import org.apache.xalan.xsltc.runtime.StringValueHandler;
import org.apache.xalan.xsltc.runtime.output.TransletOutputHandlerFactory;

public abstract class AbstractTranslet
implements Translet {
    public String _version = "1.0";
    public String _method = null;
    public String _encoding = "UTF-8";
    public boolean _omitHeader = false;
    public String _standalone = null;
    public String _doctypePublic = null;
    public String _doctypeSystem = null;
    public boolean _indent = false;
    public String _mediaType = null;
    public Hashtable _cdata = null;
    protected String[] namesArray;
    protected String[] namespaceArray;
    protected StringValueHandler stringValueHandler = new StringValueHandler();
    private static final String EMPTYSTRING = "";
    protected int vbase = 0;
    protected int vframe = 0;
    protected ArrayList varsStack = new ArrayList();
    protected int pbase = 0;
    protected int pframe = 0;
    protected ArrayList paramsStack = new ArrayList();
    private MessageHandler _msgHandler = null;
    public Hashtable _formatSymbols = null;
    public Hashtable _unparsedEntities = null;
    private Hashtable _keyIndexes = null;
    private KeyIndex _emptyKeyIndex = new KeyIndex(1);
    private int _indexSize = 0;
    private DOMCache _domCache = null;
    private Hashtable _auxClasses = null;

    public void printInternalState() {
        System.out.println("-------------------------------------");
        System.out.println("AbstractTranslet this = " + this);
        System.out.println("vbase = " + this.vbase);
        System.out.println("vframe = " + this.vframe);
        System.out.println("varsStack.size() = " + this.varsStack.size());
        System.out.println("pbase = " + this.pbase);
        System.out.println("vframe = " + this.pframe);
        System.out.println("paramsStack.size() = " + this.paramsStack.size());
        System.out.println("namesArray.size = " + this.namesArray.length);
        System.out.println("namespaceArray.size = " + this.namespaceArray.length);
        System.out.println(EMPTYSTRING);
        System.out.println("Total memory = " + Runtime.getRuntime().totalMemory());
    }

    public final DOMAdapter makeDOMAdapter(DOM dom) throws TransletException {
        if (dom instanceof DOMImpl) {
            return new DOMAdapter((DOMImpl)dom, this.namesArray, this.namespaceArray);
        }
        BasisLibrary.runTimeError(13);
        return null;
    }

    public final void pushParamFrame() {
        this.paramsStack.add(this.pframe, new Integer(this.pbase));
        this.pbase = ++this.pframe;
    }

    public final void popParamFrame() {
        if (this.pbase > 0) {
            int oldpbase = (Integer)this.paramsStack.get(--this.pbase);
            int i = this.pframe - 1;
            while (i >= this.pbase) {
                this.paramsStack.remove(i);
                --i;
            }
            this.pframe = this.pbase;
            this.pbase = oldpbase;
        }
    }

    public final Object addParameter(String name, Object value) {
        name = BasisLibrary.replace(name, ".-", new String[]{"$dot$", "$dash$"});
        return this.addParameter(name, value, false);
    }

    public final Object addParameter(String name, Object value, boolean isDefault) {
        int i = this.pframe - 1;
        while (i >= this.pbase) {
            Parameter param = (Parameter)this.paramsStack.get(i);
            if (param._name.equals(name)) {
                if (param._isDefault || !isDefault) {
                    param._value = value;
                    param._isDefault = isDefault;
                    return value;
                }
                return param._value;
            }
            --i;
        }
        this.paramsStack.add(this.pframe++, new Parameter(name, value, isDefault));
        return value;
    }

    public void clearParameters() {
        this.pframe = 0;
        this.pbase = 0;
        this.paramsStack.clear();
    }

    public final Object getParameter(String name) {
        int i = this.pframe - 1;
        while (i >= this.pbase) {
            Parameter param = (Parameter)this.paramsStack.get(i);
            if (param._name.equals(name)) {
                return param._value;
            }
            --i;
        }
        return null;
    }

    public final void pushVarFrame(int frameSize) {
        this.varsStack.add(this.vframe, new Integer(this.vbase));
        this.vbase = ++this.vframe;
        this.vframe += frameSize;
        int i = this.vbase;
        while (i <= this.vframe + 1) {
            this.varsStack.add(i, null);
            ++i;
        }
    }

    public final void popVarFrame() {
        if (this.vbase > 0) {
            int oldvbase = (Integer)this.varsStack.get(--this.vbase);
            int i = this.vbase;
            while (i < this.vframe) {
                this.varsStack.set(i, null);
                ++i;
            }
            this.vframe = this.vbase;
            this.vbase = oldvbase;
        }
    }

    public final Object getVariable(int vindex) {
        return this.varsStack.get(this.vbase + vindex);
    }

    public final void addVariable(int vindex, Object value) {
        this.varsStack.set(this.vbase + vindex, value);
    }

    public final void setMessageHandler(MessageHandler handler) {
        this._msgHandler = handler;
    }

    public final void displayMessage(String msg) {
        if (this._msgHandler == null) {
            System.err.println(msg);
        } else {
            this._msgHandler.displayMessage(msg);
        }
    }

    public void addDecimalFormat(String name, DecimalFormatSymbols symbols) {
        if (this._formatSymbols == null) {
            this._formatSymbols = new Hashtable();
        }
        if (name == null) {
            name = EMPTYSTRING;
        }
        DecimalFormat df = new DecimalFormat();
        if (symbols != null) {
            df.setDecimalFormatSymbols(symbols);
        }
        this._formatSymbols.put(name, df);
    }

    public final DecimalFormat getDecimalFormat(String name) {
        if (this._formatSymbols != null) {
            DecimalFormat df;
            if (name == null) {
                name = EMPTYSTRING;
            }
            if ((df = (DecimalFormat)this._formatSymbols.get(name)) == null) {
                df = (DecimalFormat)this._formatSymbols.get(EMPTYSTRING);
            }
            return df;
        }
        return null;
    }

    public final String getUnparsedEntity(String name) {
        String uri = (String)this._unparsedEntities.get(name);
        return uri == null ? EMPTYSTRING : uri;
    }

    public final void addUnparsedEntity(String name, String uri) {
        if (this._unparsedEntities == null) {
            this._unparsedEntities = new Hashtable();
        }
        if (!this._unparsedEntities.containsKey(name)) {
            this._unparsedEntities.put(name, uri);
        }
    }

    public final void setUnparsedEntityURIs(Hashtable table) {
        if (this._unparsedEntities == null) {
            this._unparsedEntities = table;
        } else {
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                this._unparsedEntities.put(name, table.get(name));
            }
        }
    }

    public final void setDTDMonitor(DTDMonitor monitor) {
        this.setUnparsedEntityURIs(monitor.getUnparsedEntityURIs());
    }

    public void setIndexSize(int size) {
        if (size > this._indexSize) {
            this._indexSize = size;
        }
    }

    public KeyIndex createKeyIndex() {
        return new KeyIndex(this._indexSize);
    }

    public void buildKeyIndex(String name, int node, Object value) {
        KeyIndex index;
        if (this._keyIndexes == null) {
            this._keyIndexes = new Hashtable();
        }
        if ((index = (KeyIndex)this._keyIndexes.get(name)) == null) {
            index = new KeyIndex(this._indexSize);
            this._keyIndexes.put(name, index);
        }
        index.add(value, node);
    }

    public KeyIndex getKeyIndex(String name) {
        if (this._keyIndexes == null) {
            return this._emptyKeyIndex;
        }
        KeyIndex index = (KeyIndex)this._keyIndexes.get(name);
        if (index == null) {
            return this._emptyKeyIndex;
        }
        return index;
    }

    public void buildKeys(DOM document, NodeIterator iterator, TransletOutputHandler handler, int root) throws TransletException {
    }

    public void setDOMCache(DOMCache cache) {
        this._domCache = cache;
    }

    public DOMCache getDOMCache() {
        return this._domCache;
    }

    public TransletOutputHandler openOutputHandler(String filename) throws TransletException {
        try {
            TransletOutputHandlerFactory factory = TransletOutputHandlerFactory.newInstance();
            factory.setEncoding(this._encoding);
            factory.setOutputMethod(this._method);
            factory.setWriter(new FileWriter(filename));
            factory.setOutputType(0);
            TransletOutputHandler handler = factory.getTransletOutputHandler();
            this.transferOutputSettings(handler);
            handler.startDocument();
            return handler;
        }
        catch (Exception e) {
            throw new TransletException(e);
        }
    }

    public void closeOutputHandler(TransletOutputHandler handler) {
        try {
            handler.endDocument();
            handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void transform(DOM var1, NodeIterator var2, TransletOutputHandler var3) throws TransletException;

    public final void transform(DOM document, TransletOutputHandler handler) throws TransletException {
        this.transform(document, document.getIterator(), handler);
    }

    public final void characters(String string, TransletOutputHandler handler) throws TransletException {
        int length = string.length();
        handler.characters(string.toCharArray(), 0, length);
    }

    public void addCdataElement(String name) {
        if (this._cdata == null) {
            this._cdata = new Hashtable();
        }
        this._cdata.put(name, name);
    }

    protected void transferOutputSettings(TransletOutputHandler handler) {
        if (this._method != null) {
            if (this._method.equals("xml")) {
                if (this._standalone != null) {
                    handler.setStandalone(this._standalone);
                }
                if (this._omitHeader) {
                    handler.omitHeader(true);
                }
                handler.setCdataElements(this._cdata);
                if (this._version != null) {
                    handler.setVersion(this._version);
                }
                handler.setIndent(this._indent);
                if (this._doctypeSystem != null) {
                    handler.setDoctype(this._doctypeSystem, this._doctypePublic);
                }
            } else if (this._method.equals("html")) {
                handler.setIndent(this._indent);
                handler.setDoctype(this._doctypeSystem, this._doctypePublic);
                if (this._mediaType != null) {
                    handler.setMediaType(this._mediaType);
                }
            }
        } else {
            handler.setCdataElements(this._cdata);
            if (this._version != null) {
                handler.setVersion(this._version);
            }
            if (this._standalone != null) {
                handler.setStandalone(this._standalone);
            }
            if (this._omitHeader) {
                handler.omitHeader(true);
            }
            handler.setIndent(this._indent);
            handler.setDoctype(this._doctypeSystem, this._doctypePublic);
        }
    }

    public void addAuxiliaryClass(Class auxClass) {
        if (this._auxClasses == null) {
            this._auxClasses = new Hashtable();
        }
        this._auxClasses.put(auxClass.getName(), auxClass);
    }

    public Class getAuxiliaryClass(String className) {
        if (this._auxClasses == null) {
            return null;
        }
        return (Class)this._auxClasses.get(className);
    }

    public abstract void transform(DOM var1, TransletOutputHandler[] var2) throws TransletException;
}

