/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.StripFilter;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.Axis;
import org.apache.xalan.xsltc.dom.BitArray;
import org.apache.xalan.xsltc.dom.DOMBuilder;
import org.apache.xalan.xsltc.dom.DupFilterIterator;
import org.apache.xalan.xsltc.dom.Filter;
import org.apache.xalan.xsltc.dom.FilterIterator;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.dom.SingletonIterator;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.apache.xalan.xsltc.runtime.SAXAdapter;
import org.apache.xalan.xsltc.util.IntegerArray;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class DOMImpl
implements DOM,
Externalizable {
    private static final String EMPTYSTRING = "";
    private static final NodeIterator EMPTYITERATOR = new NodeIterator(){

        public NodeIterator reset() {
            return this;
        }

        public NodeIterator setStartNode(int node) {
            return this;
        }

        public int next() {
            return 0;
        }

        public void setMark() {
        }

        public void gotoMark() {
        }

        public int getLast() {
            return 0;
        }

        public int getPosition() {
            return 0;
        }

        public NodeIterator cloneIterator() {
            return this;
        }

        public boolean isReverse() {
            return false;
        }

        public NodeIterator resetOnce() {
            return this;
        }

        public NodeIterator includeSelf() {
            return this;
        }

        public void setRestartable(boolean isRestartable) {
        }
    };
    private int _treeNodeLimit;
    private int _firstAttributeNode;
    private short[] _type;
    private Hashtable _types = null;
    private String[] _namesArray;
    private int[] _parent;
    private int[] _nextSibling;
    private int[] _offsetOrChild;
    private int[] _lengthOrAttr;
    private char[] _text;
    private String[] _uriArray;
    private String[] _prefixArray;
    private short[] _namespace;
    private short[] _prefix;
    private Hashtable _nsIndex = new Hashtable();
    private BitArray _whitespace;
    private BitArray _dontEscape = null;
    private String _documentURI = null;
    private static int _documentURIIndex = 0;
    private Node[] _nodes;
    private NodeList[] _nodeLists;
    private static NodeList EmptyNodeList;
    private static NamedNodeMap EmptyNamedNodeMap;
    private static final String XML_LANG_ATTRIBUTE = "http://www.w3.org/XML/1998/namespace:@lang";
    private Filter _elementFilter;
    private String _cachedStringValue = null;

    public void setDocumentURI(String uri) {
        this._documentURI = uri;
    }

    public String getDocumentURI() {
        return this._documentURI != null ? this._documentURI : "rtf" + _documentURIIndex++;
    }

    public String getDocumentURI(int node) {
        return this.getDocumentURI();
    }

    public void setupMapping(String[] names, String[] namespaces) {
    }

    /*
     * WARNING - void declaration
     */
    public String lookupNamespace(int node, String prefix) throws TransletException {
        int anode;
        AncestorIterator ancestors = new AncestorIterator();
        if (this.isElement(node)) {
            ancestors.includeSelf();
        }
        ancestors.setStartNode(node);
        while ((anode = ancestors.next()) != 0) {
            int nsnode;
            void var3_4;
            NodeIterator namespaces = new NamespaceIterator().setStartNode((int)var3_4);
            while ((nsnode = namespaces.next()) != 0) {
                void var4_5;
                if (!this._prefixArray[this._prefix[var4_5]].equals(prefix)) continue;
                return this.getNodeValue((int)var4_5);
            }
        }
        throw new TransletException("Namespace prefix '" + prefix + "' is undeclared.");
    }

    public boolean isElement(int node) {
        short type = this._type[node];
        return node < this._firstAttributeNode && type >= 7;
    }

    public boolean isAttribute(int node) {
        short type = this._type[node];
        return node >= this._firstAttributeNode && type >= 7;
    }

    public int getSize() {
        return this._type.length;
    }

    public void setFilter(StripFilter filter) {
    }

    public boolean lessThan(int node1, int node2) {
        if (node1 >= this._firstAttributeNode) {
            node1 = this._parent[node1];
        }
        if (node2 >= this._firstAttributeNode) {
            node2 = this._parent[node2];
        }
        return node2 < this._treeNodeLimit && node1 < node2;
    }

    public Node makeNode(int index) {
        if (this._nodes == null) {
            this._nodes = new Node[this._type.length];
        }
        return this._nodes[index] != null ? this._nodes[index] : new NodeImpl(index);
    }

    public Node makeNode(NodeIterator iter) {
        return this.makeNode(iter.next());
    }

    public NodeList makeNodeList(int index) {
        if (this._nodeLists == null) {
            this._nodeLists = new NodeList[this._type.length];
        }
        return this._nodeLists[index] != null ? this._nodeLists[index] : new NodeListImpl(index);
    }

    public NodeList makeNodeList(NodeIterator iter) {
        return new NodeListImpl(iter);
    }

    private NodeList getEmptyNodeList() {
        return EmptyNodeList != null ? EmptyNodeList : (EmptyNodeList = new NodeListImpl(new int[0]));
    }

    private NamedNodeMap getEmptyNamedNodeMap() {
        return EmptyNamedNodeMap != null ? EmptyNamedNodeMap : (EmptyNamedNodeMap = new NamedNodeMapImpl(new int[0]));
    }

    private Filter getElementFilter() {
        if (this._elementFilter == null) {
            this._elementFilter = new Filter(){

                public boolean test(int node) {
                    return DOMImpl.this.isElement(node);
                }
            };
        }
        return this._elementFilter;
    }

    public Filter getTypeFilter(int type) {
        return new TypeFilter(type);
    }

    public NodeIterator strippingIterator(NodeIterator iterator, short[] mapping, StripFilter filter) {
        return new StrippingIterator(iterator, mapping, filter);
    }

    public NodeIterator getNodeValueIterator(NodeIterator iterator, int type, String value, boolean op) {
        return new NodeValueIterator(iterator, type, value, op);
    }

    public NodeIterator orderNodes(NodeIterator source, int node) {
        return new DupFilterIterator(source);
    }

    private int leftmostDescendant(int node) {
        int current;
        while (this._type[current = node] >= 7 && (node = this._offsetOrChild[node]) != 0) {
        }
        return current;
    }

    private int lastChild(int node) {
        int child;
        if ((this.isElement(node) || node == 1) && (child = this._offsetOrChild[node]) != 0) {
            while ((child = this._nextSibling[node = child]) != 0) {
            }
            return node;
        }
        return 0;
    }

    public int getParent(int node) {
        return this._parent[node];
    }

    public int getElementPosition(int node) {
        int match = 0;
        int curr = this._offsetOrChild[this._parent[node]];
        if (this.isElement(curr)) {
            ++match;
        }
        while (curr != node) {
            if (!this.isElement(curr = this._nextSibling[curr])) continue;
            ++match;
        }
        return match;
    }

    public int getAttributePosition(int attr) {
        int match = 1;
        int curr = this._lengthOrAttr[this._parent[attr]];
        while (curr != attr) {
            curr = this._nextSibling[curr];
            ++match;
        }
        return match;
    }

    public int getTypedPosition(int type, int node) {
        switch (type) {
            case 3: {
                return this.getElementPosition(node);
            }
            case 4: {
                return this.getAttributePosition(node);
            }
            case -1: {
                type = this._type[node];
            }
        }
        int match = 0;
        int curr = this._offsetOrChild[this._parent[node]];
        if (this._type[curr] == type) {
            ++match;
        }
        while (curr != node) {
            if (this._type[curr = this._nextSibling[curr]] != type) continue;
            ++match;
        }
        return match;
    }

    public int getTypedLast(int type, int node) {
        if (type == -1) {
            type = this._type[node];
        }
        int match = 0;
        int curr = this._offsetOrChild[this._parent[node]];
        if (this._type[curr] == type) {
            ++match;
        }
        while (curr != 0) {
            if (this._type[curr = this._nextSibling[curr]] != type) continue;
            ++match;
        }
        return match;
    }

    public NodeIterator getIterator() {
        return new SingletonIterator(1);
    }

    public int getType(int node) {
        return node >= this._type.length ? 0 : this._type[node];
    }

    public int getNamespaceType(int node) {
        short type = this._type[node];
        return type >= 7 ? this._namespace[type - 7] : 0;
    }

    public short[] getTypeArray() {
        return this._type;
    }

    public String getNodeValue(int node) {
        if (node == 0 || node > this._treeNodeLimit) {
            return EMPTYSTRING;
        }
        switch (this._type[node]) {
            case 0: {
                return this.getNodeValue(this._offsetOrChild[node]);
            }
            case 1: 
            case 6: {
                return this.makeStringValue(node);
            }
            case 5: {
                String pistr = this.makeStringValue(node);
                int col = pistr.indexOf(32);
                return col > 0 ? pistr.substring(col + 1) : pistr;
            }
        }
        return node < this._firstAttributeNode ? this.getElementValue(node) : this.makeStringValue(node);
    }

    private String getLocalName(int node) {
        int len;
        int type = this._type[node] - 7;
        String qname = this._namesArray[type];
        String uri = this._uriArray[this._namespace[type]];
        if (uri != null && (len = uri.length()) > 0) {
            return qname.substring(len + 1);
        }
        return qname;
    }

    private Hashtable setupMapping(String[] namesArray) {
        int nNames = namesArray.length;
        Hashtable types = new Hashtable(nNames);
        int i = 0;
        while (i < nNames) {
            types.put(namesArray[i], new Integer(i + 7));
            ++i;
        }
        return types;
    }

    public int getGeneralizedType(String name) {
        Integer type = (Integer)this._types.get(name);
        if (type == null) {
            int code = name.charAt(0) == '@' ? 4 : 3;
            this._types.put(name, new Integer(code));
            return code;
        }
        return type;
    }

    public short[] getMapping(String[] names) {
        int namesLength = names.length;
        int mappingLength = this._namesArray.length + 7;
        short[] result = new short[mappingLength];
        int i = 0;
        while (i < 7) {
            result[i] = (short)i;
            ++i;
        }
        i = 7;
        while (i < mappingLength) {
            int type = i - 7;
            String name = this._namesArray[type];
            String uri = this._uriArray[this._namespace[type]];
            int len = 0;
            if (uri != null && (len = uri.length()) > 0) {
                ++len;
            }
            result[i] = name.length() > 0 && name.charAt(len) == '@' ? 4 : 3;
            ++i;
        }
        i = 0;
        while (i < namesLength) {
            result[this.getGeneralizedType((String)names[i])] = (short)(i + 7);
            ++i;
        }
        return result;
    }

    public short[] getReverseMapping(String[] names) {
        short[] result = new short[names.length + 7];
        int i = 0;
        while (i < 7) {
            result[i] = (short)i;
            ++i;
        }
        i = 0;
        while (i < names.length) {
            result[i + 7] = (short)this.getGeneralizedType(names[i]);
            if (result[i + 7] == 3) {
                result[i + 7] = -1;
            }
            ++i;
        }
        return result;
    }

    public short[] getNamespaceMapping(String[] namespaces) {
        int nsLength = namespaces.length;
        int mappingLength = this._uriArray.length;
        short[] result = new short[mappingLength];
        int i = 0;
        while (i < mappingLength) {
            result[i] = -1;
            ++i;
        }
        i = 0;
        while (i < nsLength) {
            Integer type = (Integer)this._nsIndex.get(namespaces[i]);
            if (type != null) {
                result[type.intValue()] = (short)i;
            }
            ++i;
        }
        return result;
    }

    public short[] getReverseNamespaceMapping(String[] namespaces) {
        int length = namespaces.length;
        short[] result = new short[length];
        int i = 0;
        while (i < length) {
            Integer type = (Integer)this._nsIndex.get(namespaces[i]);
            result[i] = type == null ? -1 : (int)type.shortValue();
            ++i;
        }
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._treeNodeLimit);
        out.writeInt(this._firstAttributeNode);
        out.writeObject(this._documentURI);
        out.writeObject(this._type);
        out.writeObject(this._namespace);
        out.writeObject(this._prefix);
        out.writeObject(this._parent);
        out.writeObject(this._nextSibling);
        out.writeObject(this._offsetOrChild);
        out.writeObject(this._lengthOrAttr);
        out.writeObject(this._text);
        out.writeObject(this._namesArray);
        out.writeObject(this._uriArray);
        out.writeObject(this._prefixArray);
        out.writeObject(this._whitespace);
        if (this._dontEscape != null) {
            out.writeObject(this._dontEscape);
        } else {
            out.writeObject(new BitArray(0));
        }
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._treeNodeLimit = in.readInt();
        this._firstAttributeNode = in.readInt();
        this._documentURI = (String)in.readObject();
        this._type = (short[])in.readObject();
        this._namespace = (short[])in.readObject();
        this._prefix = (short[])in.readObject();
        this._parent = (int[])in.readObject();
        this._nextSibling = (int[])in.readObject();
        this._offsetOrChild = (int[])in.readObject();
        this._lengthOrAttr = (int[])in.readObject();
        this._text = (char[])in.readObject();
        this._namesArray = (String[])in.readObject();
        this._uriArray = (String[])in.readObject();
        this._prefixArray = (String[])in.readObject();
        this._whitespace = (BitArray)in.readObject();
        this._dontEscape = (BitArray)in.readObject();
        if (this._dontEscape.size() == 0) {
            this._dontEscape = null;
        }
        this._types = this.setupMapping(this._namesArray);
    }

    public DOMImpl() {
        this(8192);
    }

    public DOMImpl(int size) {
        this._type = new short[size];
        this._parent = new int[size];
        this._nextSibling = new int[size];
        this._offsetOrChild = new int[size];
        this._lengthOrAttr = new int[size];
        this._text = new char[size * 10];
        this._whitespace = new BitArray(size);
        this._prefix = new short[size];
    }

    public void print(int node, int level) {
        switch (this._type[node]) {
            case 0: {
                this.print(this._offsetOrChild[node], level);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                System.out.print(this.makeStringValue(node));
                break;
            }
            default: {
                String name = this.getNodeName(node);
                System.out.print("<" + name);
                int a = this._lengthOrAttr[node];
                while (a != 0) {
                    System.out.print("\n" + this.getNodeName(a) + "=\"" + this.makeStringValue(a) + "\"");
                    a = this._nextSibling[a];
                }
                System.out.print('>');
                int child = this._offsetOrChild[node];
                while (child != 0) {
                    this.print(child, level + 1);
                    child = this._nextSibling[child];
                }
                System.out.println("</" + name + '>');
            }
        }
    }

    public String getNodeName(int node) {
        String prefix;
        short pi;
        short type = this._type[node];
        switch (type) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return EMPTYSTRING;
            }
            case 2: {
                short index = this._prefix[node];
                return index < this._prefixArray.length ? this._prefixArray[index] : EMPTYSTRING;
            }
            case 5: {
                String pistr = this.makeStringValue(node);
                int col = pistr.indexOf(32);
                return col > -1 ? pistr.substring(0, col) : pistr;
            }
        }
        String name = this.getLocalName(node);
        if (node >= this._firstAttributeNode) {
            name = name.substring(1);
        }
        if ((pi = this._prefix[node]) > 0 && (prefix = this._prefixArray[pi]) != EMPTYSTRING) {
            name = prefix + ':' + name;
        }
        return name;
    }

    public String getNamespaceName(int node) {
        if (this._type[node] == 2) {
            return EMPTYSTRING;
        }
        int type = this.getNamespaceType(node);
        String name = this._uriArray[type];
        return name == null ? EMPTYSTRING : name;
    }

    private String makeStringValue(int node) {
        return new String(this._text, this._offsetOrChild[node], this._lengthOrAttr[node]);
    }

    public int getAttributeNode(int type, int element) {
        int attr = this._lengthOrAttr[element];
        while (attr != 0) {
            if (this._type[attr] == type) {
                return attr;
            }
            attr = this._nextSibling[attr];
        }
        return 0;
    }

    public String getAttributeValue(int type, int element) {
        int attr = this.getAttributeNode(type, element);
        return attr != 0 ? this.makeStringValue(attr) : EMPTYSTRING;
    }

    public boolean hasAttribute(int type, int node) {
        return this.getAttributeNode(type, node) != 0;
    }

    public String getAttributeValue(String name, int element) {
        return this.getAttributeValue(this.getGeneralizedType(name), element);
    }

    private boolean hasChildren(int node) {
        if (node < this._firstAttributeNode) {
            short type = this._type[node];
            return (type >= 7 || type == 0) && this._offsetOrChild[node] != 0;
        }
        return false;
    }

    public NodeIterator getChildren(int node) {
        return this.hasChildren(node) ? new ChildrenIterator() : EMPTYITERATOR;
    }

    public NodeIterator getTypedChildren(int type) {
        return new TypedChildrenIterator(type);
    }

    public NodeIterator getAxisIterator(int axis) {
        NodeIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new SingletonIterator();
                break;
            }
            case 3: {
                iterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                iterator = new DescendantIterator();
                break;
            }
            case 5: {
                iterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                iterator = new FollowingIterator();
                break;
            }
            case 11: {
                iterator = new PrecedingIterator();
                break;
            }
            case 7: {
                iterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                iterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                iterator = new NamespaceIterator();
                break;
            }
            default: {
                BasisLibrary.runTimeError(8, Axis.names[axis]);
            }
        }
        return iterator;
    }

    public NodeIterator getTypedAxisIterator(int axis, int type) {
        if (axis == 3 && type != 3) {
            return new TypedChildrenIterator(type);
        }
        if (type == -1) {
            return EMPTYITERATOR;
        }
        if (type == 3 && axis != 9) {
            return new FilterIterator(this.getAxisIterator(axis), this.getElementFilter());
        }
        switch (axis) {
            case 13: {
                return new TypedSingletonIterator(type);
            }
            case 10: {
                return new ParentIterator().setNodeType(type);
            }
            case 0: {
                return new TypedAncestorIterator(type);
            }
            case 1: {
                return new TypedAncestorIterator(type).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(type);
            }
            case 4: {
                return new TypedDescendantIterator(type);
            }
            case 5: {
                return new TypedDescendantIterator(type).includeSelf();
            }
            case 6: {
                return new TypedFollowingIterator(type);
            }
            case 11: {
                return new TypedPrecedingIterator(type);
            }
            case 7: {
                return new TypedFollowingSiblingIterator(type);
            }
            case 12: {
                return new TypedPrecedingSiblingIterator(type);
            }
            case 9: {
                return type == 3 ? new NamespaceIterator() : new TypedNamespaceIterator(type);
            }
        }
        BasisLibrary.runTimeError(9, Axis.names[axis]);
        return null;
    }

    public NodeIterator getNamespaceAxisIterator(int axis, int ns) {
        if (ns == -1) {
            return EMPTYITERATOR;
        }
        switch (axis) {
            case 3: {
                return new NamespaceChildrenIterator(ns);
            }
            case 2: {
                return new NamespaceAttributeIterator(ns);
            }
        }
        BasisLibrary.runTimeError(9, Axis.names[axis]);
        return null;
    }

    public NodeIterator getTypedDescendantIterator(int type) {
        return type == 3 ? new FilterIterator(new DescendantIterator(), this.getElementFilter()) : new TypedDescendantIterator(type);
    }

    public NodeIterator getNthDescendant(int type, int n, boolean includeself) {
        NodeIteratorBase source;
        NodeIteratorBase nodeIteratorBase = source = type == 3 ? new FilterIterator(new DescendantIterator(), this.getElementFilter()) : new TypedDescendantIterator(type);
        if (includeself) {
            ((NodeIteratorBase)source).includeSelf();
        }
        return new NthDescendantIterator(source, n, type);
    }

    public void characters(int textNode, TransletOutputHandler handler) throws TransletException {
        handler.characters(this._text, this._offsetOrChild[textNode], this._lengthOrAttr[textNode]);
    }

    /*
     * WARNING - void declaration
     */
    public void copy(NodeIterator nodes, TransletOutputHandler handler) throws TransletException {
        int node;
        while ((node = nodes.next()) != 0) {
            void var3_3;
            this.copy((int)var3_3, handler);
        }
    }

    public void copy(TransletOutputHandler handler) throws TransletException {
        this.copy(1, handler);
    }

    public void copy(int node, TransletOutputHandler handler) throws TransletException {
        short type = this._type[node];
        switch (type) {
            case 0: {
                int c = this._offsetOrChild[node];
                while (c != 0) {
                    this.copy(c, handler);
                    c = this._nextSibling[c];
                }
                break;
            }
            case 5: {
                this.copyPI(node, handler);
                break;
            }
            case 6: {
                handler.comment(new String(this._text, this._offsetOrChild[node], this._lengthOrAttr[node]));
                break;
            }
            case 1: {
                boolean last = false;
                boolean escapeBit = false;
                if (this._dontEscape != null && (escapeBit = this._dontEscape.getBit(node))) {
                    last = handler.setEscaping(false);
                }
                handler.characters(this._text, this._offsetOrChild[node], this._lengthOrAttr[node]);
                if (this._dontEscape == null || !escapeBit) break;
                handler.setEscaping(last);
                break;
            }
            case 4: {
                this.shallowCopy(node, handler);
                break;
            }
            case 2: {
                this.shallowCopy(node, handler);
                break;
            }
            default: {
                if (this.isElement(node)) {
                    String name = this.copyElement(node, type, handler);
                    int a = this._lengthOrAttr[node];
                    while (a != 0) {
                        if (this._type[a] != 2) {
                            String uri = this.getNamespaceName(a);
                            if (uri != EMPTYSTRING) {
                                String prefix = this._prefixArray[this._prefix[a]];
                                handler.namespace(prefix, uri);
                            }
                            handler.attribute(this.getNodeName(a), this.makeStringValue(a));
                        } else {
                            handler.namespace(this._prefixArray[this._prefix[a]], this.makeStringValue(a));
                        }
                        a = this._nextSibling[a];
                    }
                    int c = this._offsetOrChild[node];
                    while (c != 0) {
                        this.copy(c, handler);
                        c = this._nextSibling[c];
                    }
                    handler.endElement(name);
                    break;
                }
                String uri = this.getNamespaceName(node);
                if (uri != EMPTYSTRING) {
                    String prefix = this._prefixArray[this._prefix[node]];
                    handler.namespace(prefix, uri);
                }
                handler.attribute(this.getNodeName(node), this.makeStringValue(node));
            }
        }
    }

    private void copyPI(int node, TransletOutputHandler handler) throws TransletException {
        char[] text = this._text;
        int start = this._offsetOrChild[node];
        int length = this._lengthOrAttr[node];
        int i = start;
        while (text[i] != ' ') {
            ++i;
        }
        int len = i - start;
        String target = new String(text, start, len);
        String value = new String(text, i + 1, length - len - 1);
        handler.processingInstruction(target, value);
    }

    public String shallowCopy(int node, TransletOutputHandler handler) throws TransletException {
        short type = this._type[node];
        switch (type) {
            case 0: {
                return EMPTYSTRING;
            }
            case 1: {
                handler.characters(this._text, this._offsetOrChild[node], this._lengthOrAttr[node]);
                return null;
            }
            case 5: {
                this.copyPI(node, handler);
                return null;
            }
            case 6: {
                String comment = new String(this._text, this._offsetOrChild[node], this._lengthOrAttr[node]);
                handler.comment(comment);
                return null;
            }
            case 2: {
                handler.namespace(this._prefixArray[this._prefix[node]], this.makeStringValue(node));
                return null;
            }
        }
        if (this.isElement(node)) {
            return this.copyElement(node, type, handler);
        }
        String uri = this.getNamespaceName(node);
        if (uri != EMPTYSTRING) {
            String prefix = this._prefixArray[this._prefix[node]];
            handler.namespace(prefix, uri);
        }
        handler.attribute(this.getNodeName(node), this.makeStringValue(node));
        return null;
    }

    private String copyElement(int node, int type, TransletOutputHandler handler) throws TransletException {
        String name = this._namesArray[type -= 7];
        short pi = this._prefix[node];
        short ui = this._namespace[type];
        if (pi > 0) {
            String prefix = this._prefixArray[pi];
            String uri = this._uriArray[ui];
            String local = this.getLocalName(node);
            name = prefix.equals(EMPTYSTRING) ? local : prefix + ':' + local;
            handler.startElement(name);
            handler.namespace(prefix, uri);
        } else if (ui > 0) {
            name = this.getLocalName(node);
            handler.startElement(name);
            handler.namespace(EMPTYSTRING, this._uriArray[ui]);
        } else {
            handler.startElement(name);
        }
        int a = this._lengthOrAttr[node];
        while (a != 0) {
            if (this._type[a] == 2) {
                handler.namespace(this._prefixArray[this._prefix[a]], this.makeStringValue(a));
            }
            a = this._nextSibling[a];
        }
        return name;
    }

    public String getStringValue() {
        if (this._cachedStringValue == null) {
            this._cachedStringValue = this.getElementValue(1);
        }
        return this._cachedStringValue;
    }

    public String getElementValue(int element) {
        int child = this._offsetOrChild[element];
        if (child == 0) {
            return EMPTYSTRING;
        }
        if (this._type[child] == 1 && this._nextSibling[child] == 0) {
            return this.makeStringValue(child);
        }
        return this.stringValueAux(new StringBuffer(), element).toString();
    }

    private StringBuffer stringValueAux(StringBuffer buffer, int element) {
        int child = this._offsetOrChild[element];
        while (child != 0) {
            switch (this._type[child]) {
                case 1: {
                    buffer.append(this._text, this._offsetOrChild[child], this._lengthOrAttr[child]);
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.stringValueAux(buffer, child);
                }
            }
            child = this._nextSibling[child];
        }
        return buffer;
    }

    public String getTreeString() {
        StringBuffer buf = new StringBuffer();
        buf = this.getElementString(buf, 1);
        return buf.toString();
    }

    private StringBuffer getElementString(StringBuffer buffer, int element) {
        String name = null;
        if (this.isElement(element) && (name = this.getNodeName(element)) != null) {
            buffer.append('<');
            buffer.append(name);
            int attribute = this._lengthOrAttr[element];
            while (attribute != 0) {
                if (this._type[attribute] != 2) {
                    buffer.append(' ').append(this.getNodeName(attribute)).append("=\"").append(this.getNodeValue(attribute)).append('\"');
                }
                attribute = this._nextSibling[attribute];
            }
            if (this._offsetOrChild[element] == 0) {
                buffer.append("/>");
                return buffer;
            }
            buffer.append('>');
        }
        int child = this._offsetOrChild[element];
        while (child != 0) {
            switch (this._type[child]) {
                case 6: {
                    buffer.append("<!--");
                    buffer.append(this._text, this._offsetOrChild[child], this._lengthOrAttr[child]);
                    buffer.append("-->");
                    break;
                }
                case 1: {
                    buffer.append(this._text, this._offsetOrChild[child], this._lengthOrAttr[child]);
                    break;
                }
                case 5: {
                    buffer.append("<?");
                    buffer.append(this._text, this._offsetOrChild[child], this._lengthOrAttr[child]);
                    buffer.append("?>");
                    break;
                }
                default: {
                    this.getElementString(buffer, child);
                }
            }
            child = this._nextSibling[child];
        }
        if (this.isElement(element) && name != null) {
            buffer.append("</");
            buffer.append(name);
            buffer.append(">");
        }
        return buffer;
    }

    public String getLanguage(int node) {
        Integer langType = (Integer)this._types.get(XML_LANG_ATTRIBUTE);
        if (langType != null) {
            int type = langType;
            while (node != 0) {
                int attr = this._lengthOrAttr[node];
                while (attr != 0) {
                    if (this._type[attr] == type) {
                        return this.getNodeValue(attr);
                    }
                    attr = this._nextSibling[attr];
                }
                node = this.getParent(node);
            }
        }
        return null;
    }

    public DOMBuilder getBuilder() {
        return new DOMBuilderImpl();
    }

    public TransletOutputHandler getOutputDomBuilder() {
        return new SAXAdapter(new DOMBuilderImpl());
    }

    private static final boolean isWhitespaceChar(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    static /* synthetic */ char[] access$2802(DOMImpl x0, char[] x1) {
        x0._text = x1;
        return x1;
    }

    static /* synthetic */ String[] access$3102(DOMImpl x0, String[] x1) {
        x0._namesArray = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1202(DOMImpl x0, short[] x1) {
        x0._namespace = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1102(DOMImpl x0, String[] x1) {
        x0._uriArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1302(DOMImpl x0, String[] x1) {
        x0._prefixArray = x1;
        return x1;
    }

    static /* synthetic */ short[] access$202(DOMImpl x0, short[] x1) {
        x0._type = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1002(DOMImpl x0, int[] x1) {
        x0._parent = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(DOMImpl x0, int[] x1) {
        x0._nextSibling = x1;
        return x1;
    }

    static /* synthetic */ int[] access$702(DOMImpl x0, int[] x1) {
        x0._offsetOrChild = x1;
        return x1;
    }

    static /* synthetic */ int[] access$402(DOMImpl x0, int[] x1) {
        x0._lengthOrAttr = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1402(DOMImpl x0, short[] x1) {
        x0._prefix = x1;
        return x1;
    }

    private final class DOMBuilderImpl
    implements DOMBuilder {
        private static final int ATTR_ARRAY_SIZE = 32;
        private static final int REUSABLE_TEXT_SIZE = 32;
        private static final int INIT_STACK_LENGTH = 64;
        private Hashtable _shortTexts = null;
        private Hashtable _names = null;
        private int _nextNameCode = 7;
        private int _parentStackLength = 64;
        private int[] _parentStack = new int[64];
        private int[] _previousSiblingStack = new int[64];
        private int _sp;
        private int _baseOffset = 0;
        private int _currentOffset = 0;
        private int _currentNode = 0;
        private int _currentAttributeNode = 1;
        private short[] _type2 = new short[32];
        private short[] _prefix2 = new short[32];
        private int[] _parent2 = new int[32];
        private int[] _nextSibling2 = new int[32];
        private int[] _offset = new int[32];
        private int[] _length = new int[32];
        private Hashtable _nsPrefixes = new Hashtable();
        private int _uriCount = 0;
        private int _prefixCount = 0;
        private int _nextNamespace = 0;
        private int _lastNamespace = 0;
        private int[] _xmlSpaceStack = new int[64];
        private int _idx = 1;
        private boolean _preserve = false;
        private static final String XML_STRING = "xml:";
        private static final String XMLSPACE_STRING = "xml:space";
        private static final String PRESERVE_STRING = "preserve";
        private static final String XML_PREFIX = "xml";
        private static final String XMLNS_PREFIX = "xmlns";
        private boolean _escaping = true;
        private boolean _disableEscaping = false;

        public DOMBuilderImpl() {
            this._xmlSpaceStack[0] = 1;
        }

        private String getNamespaceURI(String prefix) {
            Stack stack = (Stack)this._nsPrefixes.get(prefix);
            return stack != null && !stack.empty() ? (String)stack.peek() : DOMImpl.EMPTYSTRING;
        }

        private void xmlSpaceDefine(String val, int node) {
            boolean setting = val.equals(PRESERVE_STRING);
            if (setting != this._preserve) {
                this._xmlSpaceStack[this._idx++] = node;
                this._preserve = setting;
            }
        }

        private void xmlSpaceRevert(int node) {
            if (node == this._xmlSpaceStack[this._idx - 1]) {
                --this._idx;
                this._preserve = !this._preserve;
            }
        }

        private int nextNode() {
            int index;
            if ((index = this._currentNode++) == DOMImpl.this._type.length) {
                this.resizeArrays(DOMImpl.this._type.length * 2, index);
            }
            return index;
        }

        private int nextAttributeNode() {
            int index;
            if ((index = this._currentAttributeNode++) == this._type2.length) {
                this.resizeArrays2(this._type2.length * 2, index);
            }
            return index;
        }

        private void resizeTextArray(int newSize) {
            char[] newText = new char[newSize];
            System.arraycopy(DOMImpl.this._text, 0, newText, 0, this._currentOffset);
            DOMImpl.access$2802(DOMImpl.this, newText);
        }

        private void linkChildren(int node) {
            ((DOMImpl)DOMImpl.this)._parent[node] = this._parentStack[this._sp];
            if (this._previousSiblingStack[this._sp] != 0) {
                ((DOMImpl)DOMImpl.this)._nextSibling[this._previousSiblingStack[this._sp]] = node;
            } else {
                ((DOMImpl)DOMImpl.this)._offsetOrChild[this._parentStack[this._sp]] = node;
            }
            this._previousSiblingStack[this._sp] = node;
        }

        private void linkParent(int node) {
            if (++this._sp >= this._parentStackLength) {
                int length = this._parentStackLength;
                this._parentStackLength = length + 64;
                int[] newParent = new int[this._parentStackLength];
                System.arraycopy(this._parentStack, 0, newParent, 0, length);
                this._parentStack = newParent;
                int[] newSibling = new int[this._parentStackLength];
                System.arraycopy(this._previousSiblingStack, 0, newSibling, 0, length);
                this._previousSiblingStack = newSibling;
            }
            this._parentStack[this._sp] = node;
        }

        private short makeElementNode(String uri, String localname) throws SAXException {
            String name = uri != DOMImpl.EMPTYSTRING ? uri + ':' + localname : localname;
            Integer obj = (Integer)this._names.get(name);
            if (obj == null) {
                obj = new Integer(this._nextNameCode++);
                this._names.put(name, obj);
            }
            return (short)obj.intValue();
        }

        private short makeElementNode(String name, int col) throws SAXException {
            String uri;
            if (col > -1) {
                uri = this.getNamespaceURI(name.substring(0, col));
                name = uri + name.substring(col);
            } else {
                uri = this.getNamespaceURI(DOMImpl.EMPTYSTRING);
                if (!uri.equals(DOMImpl.EMPTYSTRING)) {
                    name = uri + ':' + name;
                }
            }
            Integer obj = (Integer)this._names.get(name);
            if (obj == null) {
                obj = new Integer(this._nextNameCode++);
                this._names.put(name, obj);
            }
            return (short)obj.intValue();
        }

        private short registerPrefix(String prefix) {
            Stack stack = (Stack)this._nsPrefixes.get(prefix);
            if (stack != null) {
                Integer obj = (Integer)stack.elementAt(0);
                return (short)obj.intValue();
            }
            return 0;
        }

        private int maybeReuseText(int length) {
            int base = this._baseOffset;
            if (length <= 32) {
                char[] chars = new char[length];
                System.arraycopy(DOMImpl.this._text, base, chars, 0, length);
                Integer offsetObj = (Integer)this._shortTexts.get(chars);
                if (offsetObj != null) {
                    this._currentOffset = base;
                    return offsetObj;
                }
                this._shortTexts.put(chars, new Integer(base));
            }
            this._baseOffset = this._currentOffset;
            return base;
        }

        private void storeTextRef(int node) {
            int length = this._currentOffset - this._baseOffset;
            ((DOMImpl)DOMImpl.this)._offsetOrChild[node] = this.maybeReuseText(length);
            ((DOMImpl)DOMImpl.this)._lengthOrAttr[node] = length;
        }

        private int makeTextNode(boolean isWhitespace) {
            if (this._currentOffset > this._baseOffset) {
                int node = this.nextNode();
                int limit = this._currentOffset;
                if (isWhitespace) {
                    DOMImpl.this._whitespace.setBit(node);
                } else if (!this._preserve) {
                    int i = this._baseOffset;
                    while (DOMImpl.isWhitespaceChar(DOMImpl.this._text[i++]) && i < limit) {
                    }
                    if (i == limit && DOMImpl.isWhitespaceChar(DOMImpl.this._text[i - 1])) {
                        DOMImpl.this._whitespace.setBit(node);
                    }
                }
                ((DOMImpl)DOMImpl.this)._type[node] = 1;
                this.linkChildren(node);
                this.storeTextRef(node);
                if (this._disableEscaping) {
                    if (DOMImpl.this._dontEscape == null) {
                        DOMImpl.this._dontEscape = new BitArray(DOMImpl.this._whitespace.size());
                    }
                    DOMImpl.this._dontEscape.setBit(node);
                    this._disableEscaping = false;
                }
                return node;
            }
            return -1;
        }

        private void storeAttrValRef(int attributeNode) {
            int length = this._currentOffset - this._baseOffset;
            this._offset[attributeNode] = this.maybeReuseText(length);
            this._length[attributeNode] = length;
        }

        private int makeNamespaceNode(String prefix, String uri) throws SAXException {
            int node = this.nextAttributeNode();
            this._type2[node] = 2;
            this.characters(uri);
            this.storeAttrValRef(node);
            return node;
        }

        private int makeAttributeNode(int parent, Attributes attList, int i) throws SAXException {
            String uri;
            int node = this.nextAttributeNode();
            String qname = attList.getQName(i);
            String localName = attList.getLocalName(i);
            String value = attList.getValue(i);
            StringBuffer namebuf = new StringBuffer(DOMImpl.EMPTYSTRING);
            if (qname.startsWith(XMLSPACE_STRING)) {
                this.xmlSpaceDefine(attList.getValue(i), parent);
            }
            if (localName == null) {
                localName = DOMImpl.EMPTYSTRING;
            }
            if ((uri = attList.getURI(i)) != null && !uri.equals(DOMImpl.EMPTYSTRING)) {
                namebuf.append(uri);
                namebuf.append(':');
            }
            namebuf.append('@');
            namebuf.append(localName.length() > 0 ? localName : qname);
            String name = namebuf.toString();
            Integer obj = (Integer)this._names.get(name);
            if (obj == null) {
                this._type2[node] = (short)this._nextNameCode;
                obj = new Integer(this._nextNameCode++);
                this._names.put(name, obj);
            } else {
                this._type2[node] = (short)obj.intValue();
            }
            int col = qname.lastIndexOf(58);
            if (col > 0) {
                this._prefix2[node] = this.registerPrefix(qname.substring(0, col));
            }
            this.characters(attList.getValue(i));
            this.storeAttrValRef(node);
            return node;
        }

        public void characters(char[] ch, int start, int length) {
            if (this._currentOffset + length > DOMImpl.this._text.length) {
                this.resizeTextArray(Math.max(DOMImpl.this._text.length * 2, this._currentOffset + length));
            }
            System.arraycopy(ch, start, DOMImpl.this._text, this._currentOffset, length);
            this._currentOffset += length;
            this._disableEscaping = !this._escaping;
        }

        public void startDocument() throws SAXException {
            this._shortTexts = new Hashtable();
            this._names = new Hashtable();
            this._sp = 0;
            this._parentStack[0] = 1;
            this._currentNode = 2;
            this._currentAttributeNode = 1;
            this._type2[0] = 2;
            this.startPrefixMapping(DOMImpl.EMPTYSTRING, DOMImpl.EMPTYSTRING);
            this.startPrefixMapping(XML_PREFIX, "http://www.w3.org/XML/1998/namespace");
            ((DOMImpl)DOMImpl.this)._lengthOrAttr[1] = this._nextNamespace;
            this._parent2[this._nextNamespace] = 1;
            this._nextNamespace = 0;
        }

        public void endDocument() {
            this.makeTextNode(false);
            this._shortTexts = null;
            int namesSize = this._nextNameCode - 7;
            DOMImpl.access$3102(DOMImpl.this, new String[namesSize]);
            Enumeration keys = this._names.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                Integer idx = (Integer)this._names.get(name);
                ((DOMImpl)DOMImpl.this)._namesArray[idx.intValue() - 7] = name;
            }
            this._names = null;
            DOMImpl.this._types = DOMImpl.this.setupMapping(DOMImpl.this._namesArray);
            this.resizeTextArray(this._currentOffset);
            DOMImpl.this._firstAttributeNode = this._currentNode;
            this.shiftAttributes(this._currentNode);
            this.resizeArrays(this._currentNode + this._currentAttributeNode, this._currentNode);
            this.appendAttributes();
            DOMImpl.this._treeNodeLimit = this._currentNode + this._currentAttributeNode;
            DOMImpl.access$1202(DOMImpl.this, new short[namesSize]);
            DOMImpl.access$1102(DOMImpl.this, new String[this._uriCount]);
            int i = 0;
            while (i < namesSize) {
                String qname = DOMImpl.this._namesArray[i];
                int col = DOMImpl.this._namesArray[i].lastIndexOf(58);
                if (!qname.startsWith(XML_STRING) && col > -1) {
                    String uri = DOMImpl.this._namesArray[i].substring(0, col);
                    Integer idx = (Integer)DOMImpl.this._nsIndex.get(uri);
                    if (idx != null) {
                        ((DOMImpl)DOMImpl.this)._namespace[i] = idx.shortValue();
                        ((DOMImpl)DOMImpl.this)._uriArray[idx.intValue()] = uri;
                    }
                }
                ++i;
            }
            DOMImpl.access$1302(DOMImpl.this, new String[this._prefixCount]);
            Enumeration p = this._nsPrefixes.keys();
            while (p.hasMoreElements()) {
                String prefix = (String)p.nextElement();
                Stack stack = (Stack)this._nsPrefixes.get(prefix);
                Integer I = (Integer)stack.elementAt(0);
                ((DOMImpl)DOMImpl.this)._prefixArray[I.shortValue()] = prefix;
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            this.makeTextNode(false);
            int node = this.nextNode();
            this.linkChildren(node);
            this.linkParent(node);
            ((DOMImpl)DOMImpl.this)._lengthOrAttr[node] = 0;
            int last = -1;
            int count = attributes.getLength();
            if (this._nextNamespace != 0) {
                ((DOMImpl)DOMImpl.this)._lengthOrAttr[node] = this._nextNamespace;
                while (this._nextNamespace != 0) {
                    this._parent2[this._nextNamespace] = node;
                    last = this._nextNamespace;
                    this._nextNamespace = this._nextSibling2[last];
                    if (this._nextNamespace != 0 || count <= 0) continue;
                    this._nextSibling2[last] = this._currentAttributeNode;
                }
            }
            if (localName == null) {
                localName = DOMImpl.EMPTYSTRING;
            }
            boolean attrsAdded = false;
            if (count > 0) {
                int attr = this._currentAttributeNode;
                if (DOMImpl.this._lengthOrAttr[node] == 0) {
                    ((DOMImpl)DOMImpl.this)._lengthOrAttr[node] = attr;
                }
                int i = 0;
                while (i < count) {
                    if (!attributes.getQName(i).startsWith(XMLNS_PREFIX)) {
                        attr = this.makeAttributeNode(node, attributes, i);
                        this._parent2[attr] = node;
                        this._nextSibling2[attr] = attr + 1;
                        attrsAdded = true;
                    }
                    ++i;
                }
                this._nextSibling2[!attrsAdded && last != -1 ? last : attr] = 0;
            }
            int col = qname.lastIndexOf(58);
            short s = ((DOMImpl)DOMImpl.this)._type[node] = uri != null && localName.length() > 0 ? this.makeElementNode(uri, localName) : this.makeElementNode(qname, col);
            if (col > -1) {
                ((DOMImpl)DOMImpl.this)._prefix[node] = this.registerPrefix(qname.substring(0, col));
            }
        }

        public void endElement(String uri, String localName, String qname) {
            this.makeTextNode(false);
            this.xmlSpaceRevert(this._parentStack[this._sp]);
            this._previousSiblingStack[this._sp--] = 0;
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.makeTextNode(false);
            int node = this.nextNode();
            ((DOMImpl)DOMImpl.this)._type[node] = 5;
            this.linkChildren(node);
            this.characters(target);
            this.characters(" ");
            this.characters(data);
            this.storeTextRef(node);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this._currentOffset + length > DOMImpl.this._text.length) {
                this.resizeTextArray(Math.max(DOMImpl.this._text.length * 2, this._currentOffset + length));
            }
            System.arraycopy(ch, start, DOMImpl.this._text, this._currentOffset, length);
            this._currentOffset += length;
            this.makeTextNode(true);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            Integer idx;
            Stack<Object> stack = (Stack<Object>)this._nsPrefixes.get(prefix);
            if (stack == null) {
                stack = new Stack<Object>();
                stack.push(new Integer(this._prefixCount++));
                this._nsPrefixes.put(prefix, stack);
            }
            if ((idx = (Integer)DOMImpl.this._nsIndex.get(uri)) == null) {
                idx = new Integer(this._uriCount++);
                DOMImpl.this._nsIndex.put(uri, idx);
            }
            stack.push(uri);
            if (!prefix.equals(DOMImpl.EMPTYSTRING) || !uri.equals(DOMImpl.EMPTYSTRING)) {
                this.makeTextNode(false);
                int attr = this.makeNamespaceNode(prefix, uri);
                if (this._nextNamespace == 0) {
                    this._nextNamespace = attr;
                } else {
                    this._nextSibling2[attr - 1] = attr;
                }
                this._nextSibling2[attr] = 0;
                this._prefix2[attr] = ((Integer)stack.elementAt(0)).shortValue();
            }
        }

        public void endPrefixMapping(String prefix) {
            Stack stack = (Stack)this._nsPrefixes.get(prefix);
            if (stack != null && !stack.empty()) {
                stack.pop();
            }
        }

        public void comment(char[] ch, int start, int length) {
            this.makeTextNode(false);
            if (this._currentOffset + length > DOMImpl.this._text.length) {
                this.resizeTextArray(Math.max(DOMImpl.this._text.length * 2, this._currentOffset + length));
            }
            System.arraycopy(ch, start, DOMImpl.this._text, this._currentOffset, length);
            this._currentOffset += length;
            int node = this.makeTextNode(false);
            ((DOMImpl)DOMImpl.this)._type[node] = 6;
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }

        public void startDTD(String name, String publicId, String systemId) {
        }

        public void endDTD() {
        }

        public void startEntity(String name) {
        }

        public void endEntity(String name) {
        }

        private void characters(String string) {
            int length = string.length();
            if (this._currentOffset + length > DOMImpl.this._text.length) {
                this.resizeTextArray(Math.max(DOMImpl.this._text.length * 2, this._currentOffset + length));
            }
            string.getChars(0, length, DOMImpl.this._text, this._currentOffset);
            this._currentOffset += length;
        }

        private void resizeArrays(int newSize, int length) {
            if (length < newSize && newSize == this._currentNode) {
                length = this._currentNode;
            }
            short[] newType = new short[newSize];
            System.arraycopy(DOMImpl.this._type, 0, newType, 0, length);
            DOMImpl.access$202(DOMImpl.this, newType);
            int[] newParent = new int[newSize];
            System.arraycopy(DOMImpl.this._parent, 0, newParent, 0, length);
            DOMImpl.access$1002(DOMImpl.this, newParent);
            int[] newNextSibling = new int[newSize];
            System.arraycopy(DOMImpl.this._nextSibling, 0, newNextSibling, 0, length);
            DOMImpl.access$502(DOMImpl.this, newNextSibling);
            int[] newOffsetOrChild = new int[newSize];
            System.arraycopy(DOMImpl.this._offsetOrChild, 0, newOffsetOrChild, 0, length);
            DOMImpl.access$702(DOMImpl.this, newOffsetOrChild);
            int[] newLengthOrAttr = new int[newSize];
            System.arraycopy(DOMImpl.this._lengthOrAttr, 0, newLengthOrAttr, 0, length);
            DOMImpl.access$402(DOMImpl.this, newLengthOrAttr);
            DOMImpl.this._whitespace.resize(newSize);
            if (DOMImpl.this._dontEscape != null) {
                DOMImpl.this._dontEscape.resize(newSize);
            }
            short[] newPrefix = new short[newSize];
            System.arraycopy(DOMImpl.this._prefix, 0, newPrefix, 0, length);
            DOMImpl.access$1402(DOMImpl.this, newPrefix);
        }

        private void resizeArrays2(int newSize, int length) {
            if (newSize > length) {
                short[] newType = new short[newSize];
                System.arraycopy(this._type2, 0, newType, 0, length);
                this._type2 = newType;
                int[] newParent = new int[newSize];
                System.arraycopy(this._parent2, 0, newParent, 0, length);
                this._parent2 = newParent;
                int[] newNextSibling = new int[newSize];
                System.arraycopy(this._nextSibling2, 0, newNextSibling, 0, length);
                this._nextSibling2 = newNextSibling;
                int[] newOffset = new int[newSize];
                System.arraycopy(this._offset, 0, newOffset, 0, length);
                this._offset = newOffset;
                int[] newLength = new int[newSize];
                System.arraycopy(this._length, 0, newLength, 0, length);
                this._length = newLength;
                short[] newPrefix = new short[newSize];
                System.arraycopy(this._prefix2, 0, newPrefix, 0, length);
                this._prefix2 = newPrefix;
            }
        }

        private void shiftAttributes(int shift) {
            int i = 0;
            int next = 0;
            int limit = this._currentAttributeNode;
            int lastParent = -1;
            i = 0;
            while (i < limit) {
                if (this._parent2[i] != lastParent) {
                    lastParent = this._parent2[i];
                    ((DOMImpl)DOMImpl.this)._lengthOrAttr[lastParent] = i + shift;
                }
                this._nextSibling2[i] = (next = this._nextSibling2[i]) != 0 ? next + shift : 0;
                ++i;
            }
        }

        private void appendAttributes() {
            int len = this._currentAttributeNode;
            if (len > 0) {
                int dst = this._currentNode;
                System.arraycopy(this._type2, 0, DOMImpl.this._type, dst, len);
                System.arraycopy(this._prefix2, 0, DOMImpl.this._prefix, dst, len);
                System.arraycopy(this._parent2, 0, DOMImpl.this._parent, dst, len);
                System.arraycopy(this._nextSibling2, 0, DOMImpl.this._nextSibling, dst, len);
                System.arraycopy(this._offset, 0, DOMImpl.this._offsetOrChild, dst, len);
                System.arraycopy(this._length, 0, DOMImpl.this._lengthOrAttr, dst, len);
            }
        }

        public boolean setEscaping(boolean value) {
            boolean temp = this._escaping;
            this._escaping = value;
            return temp;
        }
    }

    private final class NodeValueIterator
    extends NodeIteratorBase {
        private NodeIterator _source;
        private String _value;
        private boolean _op;
        private final boolean _isReverse;
        private int _returnType = 1;
        private int _pos;

        public NodeValueIterator(NodeIterator source, int returnType, String value, boolean op) {
            this._source = source;
            this._returnType = returnType;
            this._value = value;
            this._op = op;
            this._isReverse = source.isReverse();
        }

        public boolean isReverse() {
            return this._isReverse;
        }

        public void setRestartable(boolean isRestartable) {
            this._isRestartable = isRestartable;
            this._source.setRestartable(isRestartable);
        }

        public NodeIterator cloneIterator() {
            try {
                NodeValueIterator clone = (NodeValueIterator)super.clone();
                clone._source = this._source.cloneIterator();
                clone.setRestartable(false);
                return clone.reset();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError(7, e.toString());
                return null;
            }
        }

        public NodeIterator reset() {
            this._source.reset();
            return this.resetPosition();
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = this._source.next()) != 0) {
                void var1_1;
                String val = DOMImpl.this.getNodeValue((int)var1_1);
                if (this._value.equals(val) != this._op) continue;
                if (this._returnType == 0) {
                    return this.returnNode((int)var1_1);
                }
                return this.returnNode(DOMImpl.this._parent[var1_1]);
            }
            return 0;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._source.setStartNode(this._startNode);
                return this.resetPosition();
            }
            return this;
        }

        public void setMark() {
            this._source.setMark();
            this._pos = this._position;
        }

        public void gotoMark() {
            this._source.gotoMark();
            this._position = this._pos;
        }
    }

    private final class StrippingIterator
    extends NodeIteratorBase {
        private static final int USE_PREDICATE = 0;
        private static final int STRIP_SPACE = 1;
        private static final int PRESERVE_SPACE = 2;
        private StripFilter _filter = null;
        private short[] _mapping = null;
        private final NodeIterator _source;
        private boolean _children = false;
        private int _action = 0;
        private int _last = -1;

        public StrippingIterator(NodeIterator source, short[] mapping, StripFilter filter) {
            this._filter = filter;
            this._mapping = mapping;
            this._source = source;
            if (this._source instanceof ChildrenIterator || this._source instanceof TypedChildrenIterator) {
                this._children = true;
            }
        }

        public void setRestartable(boolean isRestartable) {
            this._isRestartable = isRestartable;
            this._source.setRestartable(isRestartable);
        }

        public NodeIterator setStartNode(int node) {
            if (this._children) {
                this._action = this._filter.stripSpace(DOMImpl.this, node, this._mapping[DOMImpl.this._type[node]]) ? 1 : 2;
            }
            this._source.setStartNode(node);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            block4: while ((node = this._source.next()) != 0) {
                switch (this._action) {
                    case 1: {
                        void var1_1;
                        if (DOMImpl.this._whitespace.getBit((int)var1_1)) continue block4;
                    }
                    case 2: {
                        void var1_1;
                        return this.returnNode((int)var1_1);
                    }
                    default: {
                        void var1_1;
                        if (DOMImpl.this._whitespace.getBit((int)var1_1) && this._filter.stripSpace(DOMImpl.this, (int)var1_1, this._mapping[DOMImpl.this._type[DOMImpl.this._parent[var1_1]]])) continue block4;
                        return this.returnNode((int)var1_1);
                    }
                }
            }
            return 0;
        }

        public NodeIterator reset() {
            this._source.reset();
            return this;
        }

        public void setMark() {
            this._source.setMark();
        }

        public void gotoMark() {
            this._source.gotoMark();
        }

        /*
         * WARNING - void declaration
         */
        public int getLast() {
            int node;
            if (this._last != -1) {
                return this._last;
            }
            int count = this.getPosition();
            this._source.setMark();
            block4: while ((node = this._source.next()) != 0) {
                switch (this._action) {
                    case 1: {
                        void var2_2;
                        if (DOMImpl.this._whitespace.getBit((int)var2_2)) continue block4;
                    }
                    case 2: {
                        ++count;
                        break;
                    }
                    default: {
                        void var2_2;
                        if (DOMImpl.this._whitespace.getBit((int)var2_2) && this._filter.stripSpace(DOMImpl.this, (int)var2_2, this._mapping[DOMImpl.this._type[DOMImpl.this._parent[var2_2]]])) continue block4;
                        ++count;
                    }
                }
            }
            this._source.gotoMark();
            this._last = count;
            return count;
        }
    }

    private final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int result = super.next();
            return DOMImpl.this._type[result] == this._nodeType ? result : 0;
        }
    }

    private class NthDescendantIterator
    extends DescendantIterator {
        final NodeIterator _source;
        final int _pos;
        final int _ourtype;

        public NthDescendantIterator(NodeIterator source, int pos, int type) {
            this._source = source;
            this._ourtype = type;
            this._pos = pos;
        }

        public void setRestartable(boolean isRestartable) {
            this._isRestartable = isRestartable;
            this._source.setRestartable(isRestartable);
        }

        public NodeIterator setStartNode(int node) {
            this._source.setStartNode(node);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = this._source.next()) != 0) {
                void var1_1;
                int parent = DOMImpl.this._parent[var1_1];
                int child = DOMImpl.this._offsetOrChild[parent];
                int pos = 0;
                if (this._ourtype != -1) {
                    do {
                        if (!DOMImpl.this.isElement(child) || DOMImpl.this._type[child] != this._ourtype) continue;
                        ++pos;
                    } while (pos < this._pos && (child = DOMImpl.this._nextSibling[child]) != 0);
                } else {
                    do {
                        if (!DOMImpl.this.isElement(child)) continue;
                        ++pos;
                    } while (pos < this._pos && (child = DOMImpl.this._nextSibling[child]) != 0);
                }
                if (var1_1 != child) continue;
                return (int)var1_1;
            }
            return 0;
        }

        public NodeIterator reset() {
            this._source.reset();
            return this;
        }
    }

    private final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int n;
            int limit = this._limit;
            int type = this._nodeType;
            int node = this._node + 1;
            while (node < limit && DOMImpl.this._type[node] != type) {
                ++node;
            }
            if (node < limit) {
                this._node = node;
                n = this.returnNode(this._node);
            } else {
                n = 0;
            }
            return n;
        }
    }

    private class DescendantIterator
    extends NodeIteratorBase {
        protected int _node;
        protected int _limit;

        private DescendantIterator() {
        }

        public NodeIterator setStartNode(int node) {
            this._startNode = node;
            if (this._isRestartable) {
                this._startNode = this._includeSelf ? node - 1 : node;
                this._node = this._startNode;
                this._limit = !DOMImpl.this.hasChildren(node) ? node + 1 : ((node = DOMImpl.this._nextSibling[node]) == 0 ? DOMImpl.this._treeNodeLimit : DOMImpl.this.leftmostDescendant(node));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            while (++this._node < this._limit) {
                if (DOMImpl.this._type[this._node] <= 1) continue;
                return this.returnNode(this._node);
            }
            return 0;
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int type) {
            this._nodeType = type;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = super.next()) != 0) {
                void var1_1;
                if (DOMImpl.this._type[var1_1] == this._nodeType) {
                    return (int)var1_1;
                }
                --this._position;
            }
            return 0;
        }

        public int getLast() {
            if (this._last > -1) {
                return this._last;
            }
            int count = 1;
            int node = this._startNode;
            do {
                if (DOMImpl.this._type[node] != this._nodeType) continue;
                ++count;
            } while ((node = DOMImpl.this._parent[node]) != 0);
            this._last = count;
            return count;
        }
    }

    private class AncestorIterator
    extends NodeIteratorBase {
        protected int _index;
        protected int _last = -1;

        private AncestorIterator() {
        }

        public final boolean isReverse() {
            return true;
        }

        public int getLast() {
            if (this._last > -1) {
                return this._last;
            }
            int count = 1;
            int node = this._startNode;
            while ((node = DOMImpl.this._parent[node]) != 0) {
                ++count;
            }
            this._last = count;
            return count;
        }

        public NodeIterator cloneIterator() {
            try {
                AncestorIterator clone = (AncestorIterator)super.clone();
                clone.setRestartable(false);
                clone._startNode = this._startNode;
                return clone.reset();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError(7, e.toString());
                return null;
            }
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._last = -1;
                this._startNode = this._includeSelf ? node : (node >= DOMImpl.this._firstAttributeNode ? (node = DOMImpl.this._parent[node]) : DOMImpl.this._parent[node]);
                this._index = this._startNode;
                return this.resetPosition();
            }
            return this;
        }

        public NodeIterator reset() {
            this._index = this._startNode;
            return this.resetPosition();
        }

        public int next() {
            if (this._index >= 0) {
                int node = this._index;
                this._index = this._index == 0 ? -1 : DOMImpl.this._parent[this._index];
                return this.returnNode(node);
            }
            return 0;
        }

        public void setMark() {
            this._markedNode = this._index;
        }

        public void gotoMark() {
            this._index = this._markedNode;
        }
    }

    private final class TypedFollowingIterator
    extends FollowingIterator {
        private final int _nodeType;

        public TypedFollowingIterator(int type) {
            this._nodeType = type;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = super.next()) != 0) {
                void var1_1;
                if (DOMImpl.this._type[var1_1] == this._nodeType) {
                    return (int)var1_1;
                }
                --this._position;
            }
            return 0;
        }
    }

    private class FollowingIterator
    extends NodeIteratorBase {
        protected int _node;

        private FollowingIterator() {
        }

        public NodeIterator setStartNode(int node) {
            int skip = 0;
            if (this._isRestartable) {
                int current;
                if (node >= DOMImpl.this._firstAttributeNode) {
                    skip = 1;
                    node = DOMImpl.this._parent[node];
                    int child = DOMImpl.this._offsetOrChild[node];
                    if (child != 0) {
                        node = child;
                    }
                }
                this._startNode = node;
                while ((node = DOMImpl.this.lastChild(current = node)) != 0) {
                }
                this._node = current - skip;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n;
            int node = this._node + 1;
            if (node < DOMImpl.this._firstAttributeNode) {
                this._node = node;
                n = this.returnNode(this._node);
            } else {
                n = 0;
            }
            return n;
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class TypedPrecedingIterator
    extends PrecedingIterator {
        private final int _nodeType;

        public TypedPrecedingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != 0 && DOMImpl.this._type[node] != this._nodeType) {
                --this._position;
            }
            return node;
        }
    }

    private class PrecedingIterator
    extends NodeIteratorBase {
        private int _node = 0;
        private int _mom = 0;

        private PrecedingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public NodeIterator cloneIterator() {
            try {
                PrecedingIterator clone = (PrecedingIterator)super.clone();
                clone.setRestartable(false);
                return clone.reset();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError(7, e.toString());
                return null;
            }
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = DOMImpl.this._parent[node];
                }
                this._node = this._startNode = node;
                this._mom = DOMImpl.this._parent[this._startNode];
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            while (--this._node > 1) {
                if (this._node < this._mom) {
                    this._mom = DOMImpl.this._parent[this._mom];
                }
                if (this._node == this._mom) continue;
                return this.returnNode(this._node);
            }
            return 0;
        }

        public NodeIterator reset() {
            this._node = this._startNode;
            this._mom = DOMImpl.this._parent[this._startNode];
            return this.resetPosition();
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class TypedPrecedingSiblingIterator
    extends PrecedingSiblingIterator {
        private final int _nodeType;

        public TypedPrecedingSiblingIterator(int type) {
            this._nodeType = type;
        }

        public int next() {
            int node;
            while ((node = super.next()) != 0 && DOMImpl.this._type[node] != this._nodeType) {
                --this._position;
            }
            return node;
        }
    }

    private class PrecedingSiblingIterator
    extends NodeIteratorBase {
        private int _node;
        private int _mom;

        private PrecedingSiblingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = 0;
                }
                int tmp = 0;
                this._startNode = node;
                this._mom = DOMImpl.this._parent[node];
                this._node = DOMImpl.this._offsetOrChild[this._mom];
                while (this._node != node && this._node != 0) {
                    tmp = this._node;
                    this._node = DOMImpl.this._nextSibling[this._node];
                }
                this._node = tmp;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._node == 0) {
                return 0;
            }
            int current = DOMImpl.this._offsetOrChild[this._mom];
            int last = 0;
            while (current != this._node && current != 0) {
                last = current;
                current = DOMImpl.this._nextSibling[current];
            }
            current = this._node;
            this._node = last;
            return this.returnNode(current);
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class TypedNamespaceIterator
    extends NamespaceIterator {
        final int _uriType;

        public TypedNamespaceIterator(int type) {
            this._uriType = type;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = this._ns) != 0) {
                void var1_1;
                this._ns = DOMImpl.this._nextSibling[this._ns];
                while (this._ns == 0 && this._node != 0) {
                    this._node = DOMImpl.this._parent[this._node];
                    this._ns = DOMImpl.this._lengthOrAttr[this._node];
                    while (this._ns != 0 && DOMImpl.this._type[this._ns] != 2) {
                        this._ns = DOMImpl.this._nextSibling[this._ns];
                    }
                }
                if (DOMImpl.this._prefix[var1_1] != this._uriType) continue;
                return this.returnNode((int)var1_1);
            }
            return 0;
        }
    }

    private class NamespaceIterator
    extends NodeIteratorBase {
        protected int _node;
        protected int _ns;

        private NamespaceIterator() {
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (DOMImpl.this.isElement(node)) {
                    this._startNode = this._node = node;
                    this._ns = DOMImpl.this._lengthOrAttr[this._node];
                    while (this._ns != 0 && DOMImpl.this._type[this._ns] != 2) {
                        this._ns = DOMImpl.this._nextSibling[this._ns];
                    }
                } else {
                    this._ns = 0;
                }
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            while (this._node != 0) {
                int node = this._ns;
                this._ns = DOMImpl.this._nextSibling[this._ns];
                while (this._ns == 0 && this._node != 0) {
                    this._node = DOMImpl.this._parent[this._node];
                    this._ns = DOMImpl.this._lengthOrAttr[this._node];
                    while (this._ns != 0 && DOMImpl.this._type[this._ns] != 2) {
                        this._ns = DOMImpl.this._nextSibling[this._ns];
                    }
                }
                if (DOMImpl.this._type[node] != 2) continue;
                return this.returnNode(node);
            }
            return 0;
        }

        public void setMark() {
            this._markedNode = this._ns;
        }

        public void gotoMark() {
            this._ns = this._markedNode;
        }
    }

    private final class TypedAttributeIterator
    extends NodeIteratorBase {
        private final int _nodeType;
        private int _attribute;

        public TypedAttributeIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (!DOMImpl.this.isElement(node)) {
                    this._attribute = 0;
                    return this.resetPosition();
                }
                this._startNode = node;
                node = DOMImpl.this._lengthOrAttr[this._startNode];
                while (node != 0 && DOMImpl.this._type[node] != this._nodeType) {
                    node = DOMImpl.this._nextSibling[node];
                }
                this._attribute = node;
                return this.resetPosition();
            }
            return this;
        }

        public NodeIterator reset() {
            int node = this._startNode;
            node = DOMImpl.this._lengthOrAttr[node];
            while (node != 0 && DOMImpl.this._type[node] != this._nodeType) {
                node = DOMImpl.this._nextSibling[node];
            }
            this._attribute = node;
            return this.resetPosition();
        }

        public int next() {
            int node = this._attribute;
            this._attribute = 0;
            return this.returnNode(node);
        }

        public void setMark() {
            this._markedNode = this._attribute;
        }

        public void gotoMark() {
            this._attribute = this._markedNode;
        }
    }

    private final class AttributeIterator
    extends NodeIteratorBase {
        private int _attribute;

        private AttributeIterator() {
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (DOMImpl.this.isElement(node)) {
                    this._startNode = node;
                    this._attribute = DOMImpl.this._lengthOrAttr[this._startNode];
                    while (DOMImpl.this._type[this._attribute] == 2) {
                        this._attribute = DOMImpl.this._nextSibling[this._attribute];
                    }
                } else {
                    this._attribute = 0;
                }
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._attribute;
            this._attribute = DOMImpl.this._nextSibling[this._attribute];
            return this.returnNode(node);
        }

        public void setMark() {
            this._markedNode = this._attribute;
        }

        public void gotoMark() {
            this._attribute = this._markedNode;
        }
    }

    private final class TypedFollowingSiblingIterator
    extends FollowingSiblingIterator {
        private final int _nodeType;

        public TypedFollowingSiblingIterator(int type) {
            this._nodeType = type;
        }

        /*
         * WARNING - void declaration
         */
        public int next() {
            int node;
            while ((node = super.next()) != 0) {
                void var1_1;
                if (DOMImpl.this._type[var1_1] == this._nodeType) {
                    return (int)var1_1;
                }
                --this._position;
            }
            return 0;
        }
    }

    private class FollowingSiblingIterator
    extends NodeIteratorBase {
        private int _node;

        private FollowingSiblingIterator() {
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = 0;
                }
                this._node = this._startNode = node;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._node = DOMImpl.this._nextSibling[this._node];
            return this.returnNode(this._node);
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class NamespaceAttributeIterator
    extends NodeIteratorBase {
        private final int _nsType;
        private int _attribute;

        public NamespaceAttributeIterator(int nsType) {
            this._nsType = nsType;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                node = DOMImpl.this._lengthOrAttr[this._startNode];
                while (node != 0 && DOMImpl.this.getNamespaceType(node) != this._nsType) {
                    node = DOMImpl.this._nextSibling[node];
                }
                this._attribute = node;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int save;
            int node = save = this._attribute;
            do {
                this._attribute = DOMImpl.this._nextSibling[this._attribute];
            } while (DOMImpl.this._type[this._attribute] == 2);
            this._startNode = node;
            node = DOMImpl.this._lengthOrAttr[this._startNode];
            while (node != 0 && DOMImpl.this.getNamespaceType(node) != this._nsType) {
                node = DOMImpl.this._nextSibling[node];
            }
            this._attribute = node;
            return this.returnNode(save);
        }

        public void setMark() {
            this._markedNode = this._attribute;
        }

        public void gotoMark() {
            this._attribute = this._markedNode;
        }
    }

    private final class NamespaceChildrenIterator
    extends NodeIteratorBase {
        private final int _nsType;
        private int _currentChild;

        public NamespaceChildrenIterator(int type) {
            this._nsType = type;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                int n;
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = 0;
                }
                if (DOMImpl.this.hasChildren(node)) {
                    this._startNode = node;
                    n = DOMImpl.this._offsetOrChild[this._startNode];
                } else {
                    n = 0;
                }
                this._currentChild = n;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentChild;
            while (node != 0) {
                if (DOMImpl.this.getNamespaceType(node) == this._nsType) {
                    this._currentChild = DOMImpl.this._nextSibling[node];
                    return this.returnNode(node);
                }
                node = DOMImpl.this._nextSibling[node];
            }
            return 0;
        }

        public void setMark() {
            this._markedNode = this._currentChild;
        }

        public void gotoMark() {
            this._currentChild = this._markedNode;
        }
    }

    private final class TypedChildrenIterator
    extends NodeIteratorBase {
        private int _nodeType;
        private int _currentChild;

        public TypedChildrenIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                int n;
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = 0;
                }
                if (DOMImpl.this.hasChildren(node)) {
                    this._startNode = node;
                    n = DOMImpl.this._offsetOrChild[this._startNode];
                } else {
                    n = 0;
                }
                this._currentChild = n;
                return this.resetPosition();
            }
            return this;
        }

        public NodeIterator cloneIterator() {
            try {
                TypedChildrenIterator clone = (TypedChildrenIterator)super.clone();
                clone._nodeType = this._nodeType;
                clone.setRestartable(false);
                return clone.reset();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError(7, e.toString());
                return null;
            }
        }

        public NodeIterator reset() {
            this._currentChild = DOMImpl.this.hasChildren(this._startNode) ? DOMImpl.this._offsetOrChild[this._startNode] : 0;
            return this.resetPosition();
        }

        public int next() {
            short[] type = DOMImpl.this._type;
            int nodeType = this._nodeType;
            int[] nextSibling = DOMImpl.this._nextSibling;
            int node = this._currentChild;
            while (node != 0) {
                if (type[node] == nodeType) {
                    this._currentChild = nextSibling[node];
                    return this.returnNode(node);
                }
                node = nextSibling[node];
            }
            return 0;
        }

        public void setMark() {
            this._markedNode = this._currentChild;
        }

        public void gotoMark() {
            this._currentChild = this._markedNode;
        }
    }

    private final class ParentIterator
    extends NodeIteratorBase {
        private int _node;
        private int _nodeType = -1;

        private ParentIterator() {
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = node;
                this._node = DOMImpl.this._parent[this._startNode];
                return this.resetPosition();
            }
            return this;
        }

        public NodeIterator setNodeType(int type) {
            this._nodeType = type;
            return this;
        }

        public int next() {
            int result = this._node;
            result = this._nodeType != -1 && DOMImpl.this._type[this._node] != this._nodeType ? 0 : this._node;
            this._node = 0;
            return this.returnNode(result);
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }
    }

    private final class ChildrenIterator
    extends NodeIteratorBase {
        private int _currentChild;
        private int _last = -1;

        private ChildrenIterator() {
        }

        public NodeIterator setStartNode(int node) {
            if (this._isRestartable) {
                if (node >= DOMImpl.this._firstAttributeNode) {
                    node = 0;
                }
                if (node != this._startNode) {
                    this._last = -1;
                }
                this._startNode = node;
                this._currentChild = this._includeSelf ? -1 : (DOMImpl.this.hasChildren(node) ? DOMImpl.this._offsetOrChild[node] : 0);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int node = this._currentChild;
            if (this._includeSelf && node == -1) {
                node = this._startNode;
                this._currentChild = DOMImpl.this.hasChildren(node) ? DOMImpl.this._offsetOrChild[node] : 0;
                return node;
            }
            this._currentChild = DOMImpl.this._nextSibling[node];
            return this.returnNode(node);
        }

        public void setMark() {
            this._markedNode = this._currentChild;
        }

        public void gotoMark() {
            this._currentChild = this._markedNode;
        }

        public int getLast() {
            if (this._last == -1) {
                this._last = 1;
                int node = DOMImpl.this._offsetOrChild[this._startNode];
                while ((node = DOMImpl.this._nextSibling[node]) != 0) {
                    ++this._last;
                }
            }
            return this._last;
        }
    }

    private final class TypeFilter
    implements Filter {
        private final int _nodeType;

        public TypeFilter(int type) {
            this._nodeType = type;
        }

        public boolean test(int node) {
            return DOMImpl.this._type[node] == this._nodeType;
        }
    }

    private final class NodeImpl
    implements Node {
        private final int _index;

        public NodeImpl(int index) {
            this._index = index;
        }

        public short getNodeType() {
            switch (DOMImpl.this._type[this._index]) {
                case 0: {
                    return 9;
                }
                case 1: {
                    return 3;
                }
                case 5: {
                    return 7;
                }
                case 6: {
                    return 8;
                }
            }
            return this._index < DOMImpl.this._firstAttributeNode ? (short)1 : 2;
        }

        public Node getParentNode() {
            int parent = DOMImpl.this.getParent(this._index);
            return parent > 0 ? DOMImpl.this.makeNode(parent) : null;
        }

        public Node appendChild(Node node) throws DOMException {
            throw new NotSupportedException();
        }

        public Node cloneNode(boolean deep) {
            throw new NotSupportedException();
        }

        public NamedNodeMap getAttributes() {
            if (this.getNodeType() == 1) {
                int attribute = DOMImpl.this._lengthOrAttr[this._index];
                while (DOMImpl.this._type[attribute] == 2) {
                    attribute = DOMImpl.this._nextSibling[attribute];
                }
                if (attribute != 0) {
                    IntegerArray attributes = new IntegerArray(4);
                    do {
                        attributes.add(attribute);
                    } while ((attribute = DOMImpl.this._nextSibling[attribute]) != 0);
                    return new NamedNodeMapImpl(attributes.toIntArray());
                }
                return DOMImpl.this.getEmptyNamedNodeMap();
            }
            return null;
        }

        public NodeList getChildNodes() {
            if (this.hasChildNodes()) {
                IntegerArray children = new IntegerArray(8);
                int child = DOMImpl.this._offsetOrChild[this._index];
                do {
                    children.add(child);
                } while ((child = DOMImpl.this._nextSibling[child]) != 0);
                return new NodeListImpl(children.toIntArray());
            }
            return DOMImpl.this.getEmptyNodeList();
        }

        public Node getFirstChild() {
            return this.hasChildNodes() ? DOMImpl.this.makeNode(DOMImpl.this._offsetOrChild[this._index]) : null;
        }

        public Node getLastChild() {
            return this.hasChildNodes() ? DOMImpl.this.makeNode(DOMImpl.this.lastChild(this._index)) : null;
        }

        public Node getNextSibling() {
            int next = DOMImpl.this._nextSibling[this._index];
            return next != 0 ? DOMImpl.this.makeNode(next) : null;
        }

        public String getNodeName() {
            switch (DOMImpl.this._type[this._index]) {
                case 0: {
                    return "#document";
                }
                case 1: {
                    return "#text";
                }
                case 5: {
                    return "#pi";
                }
                case 6: {
                    return "#comment";
                }
            }
            return DOMImpl.this.getNodeName(this._index);
        }

        public String getNodeValue() throws DOMException {
            return DOMImpl.this.getNodeValue(this._index);
        }

        public Document getOwnerDocument() {
            return null;
        }

        public Node getPreviousSibling() {
            int node = DOMImpl.this._parent[this._index];
            if (node > 0) {
                int prev = -1;
                node = DOMImpl.this._offsetOrChild[node];
                while (node != this._index) {
                    prev = node;
                    node = DOMImpl.this._nextSibling[prev];
                }
                if (prev != -1) {
                    return DOMImpl.this.makeNode(prev);
                }
            }
            return null;
        }

        public boolean hasChildNodes() {
            switch (this.getNodeType()) {
                case 1: 
                case 9: {
                    return DOMImpl.this._offsetOrChild[this._index] != 0;
                }
            }
            return false;
        }

        public Node insertBefore(Node n1, Node n2) throws DOMException {
            throw new NotSupportedException();
        }

        public Node removeChild(Node n) throws DOMException {
            throw new NotSupportedException();
        }

        public Node replaceChild(Node n1, Node n2) throws DOMException {
            throw new NotSupportedException();
        }

        public void setNodeValue(String s) throws DOMException {
            throw new NotSupportedException();
        }

        public void normalize() {
            throw new NotSupportedException();
        }

        public boolean isSupported(String feature, String version2) {
            return false;
        }

        public String getNamespaceURI() {
            return DOMImpl.this._uriArray[DOMImpl.this._namespace[DOMImpl.this._type[this._index] - 7]];
        }

        public String getPrefix() {
            return DOMImpl.this._prefixArray[DOMImpl.this._prefix[this._index]];
        }

        public void setPrefix(String prefix) {
            throw new NotSupportedException();
        }

        public String getLocalName() {
            return DOMImpl.this.getLocalName(this._index);
        }

        public boolean hasAttributes() {
            int attribute = DOMImpl.this._lengthOrAttr[this._index];
            while (DOMImpl.this._type[attribute] == 2) {
                attribute = DOMImpl.this._nextSibling[attribute];
            }
            return attribute != 0;
        }
    }

    private final class NamedNodeMapImpl
    implements NamedNodeMap {
        private final int[] _nodes;

        public NamedNodeMapImpl(int[] nodes) {
            this._nodes = nodes;
        }

        public int getLength() {
            return this._nodes.length;
        }

        public Node getNamedItem(String name) {
            int i = 0;
            while (i < this._nodes.length) {
                if (name.equals(DOMImpl.this.getNodeName(this._nodes[i]))) {
                    return DOMImpl.this.makeNode(this._nodes[i]);
                }
                ++i;
            }
            return null;
        }

        public Node item(int index) {
            return DOMImpl.this.makeNode(this._nodes[index]);
        }

        public Node removeNamedItem(String name) {
            throw new NotSupportedException();
        }

        public Node setNamedItem(Node node) {
            throw new NotSupportedException();
        }

        public Node getNamedItemNS(String uri, String local) {
            return this.getNamedItem(uri + ':' + local);
        }

        public Node setNamedItemNS(Node node) {
            throw new NotSupportedException();
        }

        public Node removeNamedItemNS(String uri, String local) {
            throw new NotSupportedException();
        }
    }

    private final class NodeListImpl
    implements NodeList {
        private final int[] _nodes;

        public NodeListImpl(int node) {
            this._nodes = new int[1];
            this._nodes[0] = node;
        }

        public NodeListImpl(int[] nodes) {
            this._nodes = nodes;
        }

        /*
         * WARNING - void declaration
         */
        public NodeListImpl(NodeIterator iter) {
            int node;
            IntegerArray list = new IntegerArray();
            while ((node = iter.next()) != 0) {
                void var4_4;
                list.add((int)var4_4);
            }
            this._nodes = list.toIntArray();
        }

        public int getLength() {
            return this._nodes.length;
        }

        public Node item(int index) {
            return DOMImpl.this.makeNode(this._nodes[index]);
        }
    }

    private final class NotSupportedException
    extends DOMException {
        public NotSupportedException() {
            super((short)9, "modification not supported");
        }
    }
}

