/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.CurrentNodeListFilter;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.util.IntegerArray;

public final class CurrentNodeListIterator
extends NodeIteratorBase {
    private boolean _docOrder;
    private NodeIterator _source;
    private final CurrentNodeListFilter _filter;
    private IntegerArray _nodes = new IntegerArray();
    private int _current;
    private int _last = -1;
    private final int _currentNode;
    private AbstractTranslet _translet;

    public CurrentNodeListIterator(NodeIterator source, CurrentNodeListFilter filter, int currentNode, AbstractTranslet translet) {
        this(source, !source.isReverse(), filter, currentNode, translet);
    }

    public CurrentNodeListIterator(NodeIterator source, boolean docOrder, CurrentNodeListFilter filter, int currentNode, AbstractTranslet translet) {
        this._source = source;
        this._filter = filter;
        this._translet = translet;
        this._docOrder = docOrder;
        this._currentNode = currentNode;
    }

    public void setRestartable(boolean isRestartable) {
        this._isRestartable = isRestartable;
        this._source.setRestartable(isRestartable);
    }

    public boolean isReverse() {
        return !this._docOrder;
    }

    public NodeIterator cloneIterator() {
        try {
            CurrentNodeListIterator clone = (CurrentNodeListIterator)super.clone();
            clone._nodes = (IntegerArray)this._nodes.clone();
            clone.setRestartable(false);
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError(7, e.toString());
            return null;
        }
    }

    public NodeIterator reset() {
        this._current = 0;
        return this.resetPosition();
    }

    public int next() {
        int last = this._nodes.cardinality();
        int currentNode = this._currentNode;
        AbstractTranslet translet = this._translet;
        int index = this._current;
        while (index < last) {
            int node;
            if (!this._filter.test(node = this._nodes.at(index++), index, last, currentNode, translet, this)) continue;
            this._current = index;
            return this.returnNode(node);
        }
        return 0;
    }

    public NodeIterator setStartNode(int node) {
        NodeIterator retval = this;
        if (this._isRestartable) {
            this._startNode = node;
            this._source.setStartNode(this._startNode);
            this._nodes.clear();
            while ((node = this._source.next()) != 0) {
                this._nodes.add(node);
            }
            this._current = 0;
            retval = this.resetPosition();
        }
        return retval;
    }

    public int getLast() {
        if (this._last == -1) {
            this._last = this.computePositionOfLast();
        }
        return this._last;
    }

    public void setMark() {
        this._source.setMark();
        this._markedNode = this._current;
    }

    public void gotoMark() {
        this._source.gotoMark();
        this._current = this._markedNode;
    }

    private int computePositionOfLast() {
        int last = this._nodes.cardinality();
        int currNode = this._currentNode;
        AbstractTranslet translet = this._translet;
        int lastPosition = 0;
        int index = this._current;
        while (index < last) {
            int nodeIndex;
            if (!this._filter.test(nodeIndex = this._nodes.at(index++), index, last, currNode, translet, this)) continue;
            ++lastPosition;
        }
        return lastPosition;
    }
}

