/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.xalan.xsltc.compiler.ApplyTemplates;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.ForEach;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.CompareGenerator;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSortRecordGenerator;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Sort
extends Instruction {
    private Expression _select;
    private AttributeValue _order;
    private AttributeValue _caseOrder;
    private AttributeValue _dataType;
    private String _data = null;
    public String _lang;
    public String _country;

    Sort() {
    }

    public void parseContents(Parser parser2) {
        SyntaxTreeNode parent = this.getParent();
        if (!(parent instanceof ApplyTemplates) && !(parent instanceof ForEach)) {
            this.reportError(this, parser2, 74, null);
            return;
        }
        this._select = parser2.parseExpression(this, "select", "string(.)");
        String val = this.getAttribute("order");
        if (val.length() == 0) {
            val = "ascending";
        }
        this._order = AttributeValue.create(this, val, parser2);
        val = this.getAttribute("case-order");
        if (val.length() == 0) {
            val = "upper-first";
        }
        this._caseOrder = AttributeValue.create(this, val, parser2);
        val = this.getAttribute("data-type");
        if (val.length() == 0) {
            try {
                Type type = this._select.typeCheck(parser2.getSymbolTable());
                val = type instanceof IntType ? "number" : "text";
            }
            catch (TypeCheckError e) {
                val = "text";
            }
        }
        this._dataType = AttributeValue.create(this, val, parser2);
        val = this.getAttribute("lang");
        if (val != null) {
            try {
                StringTokenizer st = new StringTokenizer(val, "-", false);
                this._lang = st.nextToken();
                this._country = st.nextToken();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type tselect = this._select.typeCheck(stable);
        if (!(tselect instanceof StringType)) {
            this._select = new CastExpr(this._select, Type.String);
        }
        this._order.typeCheck(stable);
        this._caseOrder.typeCheck(stable);
        this._dataType.typeCheck(stable);
        return Type.Void;
    }

    public void translateSortType(ClassGenerator classGen, MethodGenerator methodGen) {
        this._dataType.translate(classGen, methodGen);
    }

    public void translateSortOrder(ClassGenerator classGen, MethodGenerator methodGen) {
        this._order.translate(classGen, methodGen);
    }

    public void translateSelect(ClassGenerator classGen, MethodGenerator methodGen) {
        this._select.translate(classGen, methodGen);
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
    }

    public static void translateSortIterator(ClassGenerator classGen, MethodGenerator methodGen, Expression nodeSet, Vector sortObjects) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int init = cpg.addMethodref("org.apache.xalan.xsltc.dom.SortingIterator", "<init>", "(Lorg/apache/xalan/xsltc/NodeIterator;Lorg/apache/xalan/xsltc/dom/NodeSortRecordFactory;)V");
        il.append(new NEW(cpg.addClass("org.apache.xalan.xsltc.dom.SortingIterator")));
        il.append(InstructionConstants.DUP);
        if (nodeSet == null) {
            int children = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getAxisIterator", "(I)Lorg/apache/xalan/xsltc/NodeIterator;");
            il.append(methodGen.loadDOM());
            il.append(new PUSH(cpg, 3));
            il.append(new INVOKEINTERFACE(children, 2));
        } else {
            nodeSet.translate(classGen, methodGen);
        }
        Sort.compileSortRecordFactory(sortObjects, classGen, methodGen);
        il.append(new INVOKESPECIAL(init));
    }

    public static void compileSortRecordFactory(Vector sortObjects, ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        String initParams = "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V";
        int init = cpg.addMethodref("org/apache/xalan/xsltc/dom/NodeSortRecordFactory", "<init>", "(Lorg/apache/xalan/xsltc/DOM;Ljava/lang/String;Lorg/apache/xalan/xsltc/Translet;[Ljava/lang/String;[Ljava/lang/String;)V");
        String className = Sort.compileSortRecord(sortObjects, classGen, methodGen);
        il.append(new NEW(cpg.addClass("org/apache/xalan/xsltc/dom/NodeSortRecordFactory")));
        il.append(InstructionConstants.DUP);
        il.append(methodGen.loadDOM());
        il.append(new PUSH(cpg, className));
        il.append(classGen.loadTranslet());
        int levels = sortObjects.size();
        il.append(new PUSH(cpg, levels));
        il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
        int level = 0;
        while (level < levels) {
            Sort sort = (Sort)sortObjects.elementAt(level);
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, level));
            sort.translateSortOrder(classGen, methodGen);
            il.append(InstructionConstants.AASTORE);
            ++level;
        }
        il.append(new PUSH(cpg, levels));
        il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
        int level2 = 0;
        while (level2 < levels) {
            Sort sort = (Sort)sortObjects.elementAt(level2);
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, level2));
            sort.translateSortType(classGen, methodGen);
            il.append(InstructionConstants.AASTORE);
            ++level2;
        }
        il.append(new INVOKESPECIAL(init));
    }

    private static String compileSortRecord(Vector sortObjects, ClassGenerator classGen, MethodGenerator methodGen) {
        XSLTC xsltc = ((Sort)sortObjects.firstElement()).getXSLTC();
        String className = xsltc.getHelperClassName();
        NodeSortRecordGenerator sortRecord = new NodeSortRecordGenerator(className, "org.apache.xalan.xsltc.dom.NodeSortRecord", "sort$0.java", 49, new String[0], classGen.getStylesheet());
        ConstantPoolGen cpg = sortRecord.getConstantPool();
        Method clinit = Sort.compileClassInit(sortObjects, sortRecord, cpg, className);
        Method extract = Sort.compileExtract(sortObjects, sortRecord, cpg, className);
        sortRecord.addMethod(clinit);
        sortRecord.addEmptyConstructor(1);
        sortRecord.addMethod(extract);
        int i = 0;
        while (i < sortObjects.size()) {
            if (((Sort)sortObjects.elementAt((int)i))._lang != null) {
                sortRecord.addMethod(Sort.compileGetCollator(sortObjects, sortRecord, cpg, className));
                i = sortObjects.size();
            }
            ++i;
        }
        xsltc.dumpClass(sortRecord.getJavaClass());
        return className;
    }

    private static Method compileClassInit(Vector sortObjects, NodeSortRecordGenerator sortRecord, ConstantPoolGen cpg, String className) {
        InstructionList il = new InstructionList();
        CompareGenerator classInit = new CompareGenerator(9, org.apache.bcel.generic.Type.VOID, new org.apache.bcel.generic.Type[0], new String[0], "<clinit>", className, il, cpg);
        int initLocale = cpg.addMethodref("java/util/Locale", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        int getCollator = cpg.addMethodref("java/text/Collator", "getInstance", "(Ljava/util/Locale;)Ljava/text/Collator;");
        int setStrength = cpg.addMethodref("java/text/Collator", "setStrength", "(I)V");
        int levels = sortObjects.size();
        String language = null;
        String country = null;
        Sort sort = (Sort)sortObjects.elementAt(0);
        int level = 0;
        while (level < levels) {
            if (language == null && sort._lang != null) {
                language = sort._lang;
            }
            if (country == null && sort._country != null) {
                country = sort._country;
            }
            ++level;
        }
        int collator = cpg.addFieldref(className, "_collator", "Ljava/text/Collator;");
        if (language != null) {
            il.append(new NEW(cpg.addClass("java/util/Locale")));
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(cpg, language));
            il.append(new PUSH(cpg, country != null ? country : ""));
            il.append(new INVOKESPECIAL(initLocale));
            il.append(new INVOKESTATIC(getCollator));
            il.append(new PUTSTATIC(collator));
        }
        il.append(new GETSTATIC(collator));
        il.append(new ICONST(2));
        il.append(new INVOKEVIRTUAL(setStrength));
        il.append(InstructionConstants.RETURN);
        classInit.stripAttributes(true);
        classInit.setMaxLocals();
        classInit.setMaxStack();
        classInit.removeNOPs();
        return classInit.getMethod();
    }

    private static Method compileExtract(Vector sortObjects, NodeSortRecordGenerator sortRecord, ConstantPoolGen cpg, String className) {
        InstructionList il = new InstructionList();
        CompareGenerator extractMethod = new CompareGenerator(17, org.apache.bcel.generic.Type.STRING, new org.apache.bcel.generic.Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;"), org.apache.bcel.generic.Type.INT}, new String[]{"dom", "current", "level", "translet", "last"}, "extractValueFromDOM", className, il, cpg);
        int levels = sortObjects.size();
        int[] match = new int[levels];
        InstructionHandle[] target = new InstructionHandle[levels];
        InstructionHandle tblswitch = null;
        if (levels > 1) {
            il.append(new ILOAD(extractMethod.getLocalIndex("level")));
            tblswitch = il.append(new NOP());
        }
        int level = 0;
        while (level < levels) {
            match[level] = level;
            Sort sort = (Sort)sortObjects.elementAt(level);
            target[level] = il.append(InstructionConstants.NOP);
            sort.translateSelect(sortRecord, extractMethod);
            il.append(InstructionConstants.ARETURN);
            ++level;
        }
        if (levels > 1) {
            InstructionHandle defaultTarget = il.append(new PUSH(cpg, ""));
            il.insert(tblswitch, new TABLESWITCH(match, target, defaultTarget));
            il.append(InstructionConstants.ARETURN);
        }
        extractMethod.stripAttributes(true);
        extractMethod.setMaxLocals();
        extractMethod.setMaxStack();
        extractMethod.removeNOPs();
        return extractMethod.getMethod();
    }

    private static Method compileGetCollator(Vector sortObjects, NodeSortRecordGenerator sortRecord, ConstantPoolGen cpg, String className) {
        InstructionList il = new InstructionList();
        MethodGenerator getCollator = new MethodGenerator(17, Util.getJCRefType("Ljava/text/Collator;"), new org.apache.bcel.generic.Type[0], new String[0], "getCollator", className, il, cpg);
        int collator = cpg.addFieldref(className, "collator", "Ljava/text/Collator;");
        il.append(new GETSTATIC(collator));
        il.append(InstructionConstants.ARETURN);
        getCollator.stripAttributes(true);
        getCollator.setMaxLocals();
        getCollator.setMaxStack();
        getCollator.removeNOPs();
        return getCollator.getMethod();
    }
}

