/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AbsoluteLocationPath;
import org.apache.xalan.xsltc.compiler.BooleanExpr;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.EqualityExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FilterExpr;
import org.apache.xalan.xsltc.compiler.FilterParentPath;
import org.apache.xalan.xsltc.compiler.KeyCall;
import org.apache.xalan.xsltc.compiler.LastCall;
import org.apache.xalan.xsltc.compiler.ParentLocationPath;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.PositionCall;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Step;
import org.apache.xalan.xsltc.compiler.StepPattern;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UnionPathExpr;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.VariableRefBase;
import org.apache.xalan.xsltc.compiler.util.BooleanType;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.FilterGenerator;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NumberType;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.ResultTreeType;
import org.apache.xalan.xsltc.compiler.util.TestGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Predicate
extends Expression {
    private Expression _exp = null;
    private String _className;
    private boolean _nthPositionFilter = false;
    private boolean _nthDescendant = false;
    private boolean _canOptimize = true;
    private int _ptype = -1;
    private Expression _value = null;
    private Step _step = null;

    public Predicate(Expression exp) {
        this._exp = exp;
        this._exp.setParent(this);
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        this._exp.setParser(parser2);
    }

    public boolean isNthDescendant() {
        return this._nthDescendant;
    }

    public boolean isNthPositionFilter() {
        return this._nthPositionFilter;
    }

    public void dontOptimize() {
        this._canOptimize = false;
    }

    protected final boolean isClosureBoundary() {
        return true;
    }

    public int getPosType() {
        if (this._ptype == -1) {
            SyntaxTreeNode parent = this.getParent();
            if (parent instanceof StepPattern) {
                this._ptype = ((StepPattern)parent).getNodeType();
            } else if (parent instanceof AbsoluteLocationPath) {
                AbsoluteLocationPath path = (AbsoluteLocationPath)parent;
                Expression exp = path.getPath();
                if (exp instanceof Step) {
                    this._ptype = ((Step)exp).getNodeType();
                }
            } else if (parent instanceof VariableRefBase) {
                VariableRefBase ref = (VariableRefBase)parent;
                VariableBase var = ref.getVariable();
                Expression exp = var.getExpression();
                if (exp instanceof Step) {
                    this._ptype = ((Step)exp).getNodeType();
                }
            } else if (parent instanceof Step) {
                this._ptype = ((Step)parent).getNodeType();
            }
        }
        return this._ptype;
    }

    public boolean parentIsPattern() {
        return this.getParent() instanceof Pattern;
    }

    public Expression getExpr() {
        return this._exp;
    }

    public String toString() {
        if (this.isNthPositionFilter()) {
            return "pred([" + this._exp + "]," + this.getPosType() + ")";
        }
        return "pred(" + this._exp + ')';
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type texp = this._exp.typeCheck(stable);
        if (texp instanceof ReferenceType) {
            texp = Type.Real;
            this._exp = new CastExpr(this._exp, texp);
        }
        if (texp instanceof ResultTreeType) {
            this._exp = new CastExpr(this._exp, Type.Boolean);
            this._exp = new CastExpr(this._exp, Type.Real);
            texp = this._exp.typeCheck(stable);
        }
        if (texp instanceof NumberType) {
            if (!(texp instanceof IntType)) {
                this._exp = new CastExpr(this._exp, Type.Int);
            }
            SyntaxTreeNode parent = this.getParent();
            if (this._exp instanceof LastCall || parent instanceof Pattern || parent instanceof FilterExpr) {
                QName position = this.getParser().getQName("position");
                PositionCall positionCall = new PositionCall(position);
                positionCall.setParser(this.getParser());
                positionCall.setParent(this);
                this._exp = new EqualityExpr(0, positionCall, this._exp);
                if (this._exp.typeCheck(stable) != Type.Boolean) {
                    this._exp = new CastExpr(this._exp, Type.Boolean);
                }
                if (parent instanceof Pattern) {
                    this._nthPositionFilter = true;
                } else if (parent instanceof FilterExpr) {
                    FilterExpr filter = (FilterExpr)parent;
                    Expression fexp = filter.getExpr();
                    if (fexp instanceof KeyCall) {
                        this._canOptimize = false;
                    } else if (fexp instanceof VariableRefBase) {
                        this._canOptimize = false;
                    } else if (fexp instanceof ParentLocationPath) {
                        this._canOptimize = false;
                    } else if (fexp instanceof UnionPathExpr) {
                        this._canOptimize = false;
                    } else if (this._exp.hasPositionCall() && this._exp.hasLastCall()) {
                        this._canOptimize = false;
                    } else if (filter.getParent() instanceof FilterParentPath) {
                        this._canOptimize = false;
                    }
                    if (this._canOptimize) {
                        this._nthPositionFilter = true;
                    }
                }
                this._type = Type.Boolean;
                return this._type;
            }
            if (parent != null && parent instanceof Step && (parent = parent.getParent()) != null && parent instanceof AbsoluteLocationPath) {
                this._nthDescendant = true;
                this._type = Type.NodeSet;
                return this._type;
            }
            this._nthPositionFilter = true;
            this._type = Type.NodeSet;
            return this._type;
        }
        if (texp instanceof BooleanType) {
            if (this._exp.hasPositionCall()) {
                this._nthPositionFilter = true;
            }
        } else {
            this._exp = new CastExpr(this._exp, Type.Boolean);
        }
        this._nthPositionFilter = false;
        this._type = Type.Boolean;
        return this._type;
    }

    private void compileFilter(ClassGenerator classGen, MethodGenerator methodGen) {
        this._className = this.getXSLTC().getHelperClassName();
        FilterGenerator filterGen = new FilterGenerator(this._className, "java.lang.Object", this.toString(), 33, new String[]{"org.apache.xalan.xsltc.dom.CurrentNodeListFilter"}, classGen.getStylesheet());
        InstructionList il = new InstructionList();
        ConstantPoolGen cpg = filterGen.getConstantPool();
        TestGenerator testGen = new TestGenerator(17, org.apache.bcel.generic.Type.BOOLEAN, new org.apache.bcel.generic.Type[]{org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, org.apache.bcel.generic.Type.INT, Util.getJCRefType("Lorg/apache/xalan/xsltc/runtime/AbstractTranslet;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/NodeIterator;")}, new String[]{"node", "position", "last", "current", "translet", "iterator"}, "test", this._className, il, cpg);
        LocalVariableGen local = testGen.addLocalVariable("document", Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), null, null);
        String className = classGen.getClassName();
        il.append(filterGen.loadTranslet());
        il.append(new CHECKCAST(cpg.addClass(className)));
        il.append(new GETFIELD(cpg.addFieldref(className, "_dom", "Lorg/apache/xalan/xsltc/DOM;")));
        il.append(new ASTORE(local.getIndex()));
        testGen.setDomIndex(local.getIndex());
        this._exp.translate(filterGen, testGen);
        il.append(InstructionConstants.IRETURN);
        testGen.stripAttributes(true);
        testGen.setMaxLocals();
        testGen.setMaxStack();
        testGen.removeNOPs();
        filterGen.addEmptyConstructor(1);
        filterGen.addMethod(testGen.getMethod());
        this.getXSLTC().dumpClass(filterGen.getJavaClass());
    }

    public boolean isBooleanTest() {
        return this._exp instanceof BooleanExpr;
    }

    public boolean isNodeValueTest() {
        if (!this._canOptimize) {
            return false;
        }
        return this.getStep() != null && this.getCompareValue() != null;
    }

    public Expression getCompareValue() {
        if (this._value != null) {
            return this._value;
        }
        if (this._exp == null) {
            return null;
        }
        if (this._exp instanceof EqualityExpr) {
            EqualityExpr exp = (EqualityExpr)this._exp;
            Expression left = exp.getLeft();
            Expression right = exp.getRight();
            Type tleft = left.getType();
            Type tright = right.getType();
            if (left instanceof CastExpr) {
                left = ((CastExpr)left).getExpr();
            }
            if (right instanceof CastExpr) {
                right = ((CastExpr)right).getExpr();
            }
            try {
                if (tleft == Type.String && !(left instanceof Step)) {
                    this._value = exp.getLeft();
                }
                if (left instanceof VariableRefBase) {
                    this._value = new CastExpr(left, Type.String);
                }
                if (this._value != null) {
                    return this._value;
                }
            }
            catch (TypeCheckError e) {
                // empty catch block
            }
            try {
                if (tright == Type.String && !(right instanceof Step)) {
                    this._value = exp.getRight();
                }
                if (right instanceof VariableRefBase) {
                    this._value = new CastExpr(right, Type.String);
                }
                if (this._value != null) {
                    return this._value;
                }
            }
            catch (TypeCheckError e) {
                // empty catch block
            }
        }
        return null;
    }

    public Step getStep() {
        if (this._step != null) {
            return this._step;
        }
        if (this._exp == null) {
            return null;
        }
        if (this._exp instanceof EqualityExpr) {
            EqualityExpr exp = (EqualityExpr)this._exp;
            Expression left = exp.getLeft();
            Expression right = exp.getRight();
            if (left instanceof CastExpr) {
                left = ((CastExpr)left).getExpr();
            }
            if (left instanceof Step) {
                this._step = (Step)left;
            }
            if (right instanceof CastExpr) {
                right = ((CastExpr)right).getExpr();
            }
            if (right instanceof Step) {
                this._step = (Step)right;
            }
        }
        return this._step;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this._nthPositionFilter || this._nthDescendant) {
            this._exp.translate(classGen, methodGen);
        } else if (this.isNodeValueTest() && this.getParent() instanceof Step) {
            this._value.translate(classGen, methodGen);
            il.append(new CHECKCAST(cpg.addClass("java.lang.String")));
            il.append(new PUSH(cpg, ((EqualityExpr)this._exp).getOp()));
        } else {
            this.translateFilter(classGen, methodGen);
        }
    }

    public void translateFilter(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        this.compileFilter(classGen, methodGen);
        il.append(new NEW(cpg.addClass(this._className)));
        il.append(InstructionConstants.DUP);
        il.append(new INVOKESPECIAL(cpg.addMethodref(this._className, "<init>", "()V")));
    }
}

