/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class CallTemplate
extends Instruction {
    private QName _name;

    CallTemplate() {
    }

    public void display(int indent) {
        this.indent(indent);
        System.out.print("CallTemplate");
        Util.println(" name " + this._name);
        this.displayContents(indent + 4);
    }

    public boolean hasWithParams() {
        return this.elementCount() > 0;
    }

    public void parseContents(Parser parser2) {
        this._name = parser2.getQNameIgnoreDefaultNs(this.getAttribute("name"));
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Template template = stable.lookupTemplate(this._name);
        if (template == null) {
            ErrorMsg err = new ErrorMsg(2, (Object)this._name, this);
            throw new TypeCheckError(err);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        Stylesheet stylesheet = classGen.getStylesheet();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (stylesheet.hasLocalParams() || this.hasContents()) {
            int push = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "pushParamFrame", "()V");
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(push));
            this.translateContents(classGen, methodGen);
        }
        String className = stylesheet.getClassName();
        String methodName = Util.escape(this._name.toString());
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadIterator());
        il.append(methodGen.loadHandler());
        il.append(methodGen.loadCurrentNode());
        il.append(new INVOKEVIRTUAL(cpg.addMethodref(className, methodName, "(Lorg/apache/xalan/xsltc/DOM;Lorg/apache/xalan/xsltc/NodeIterator;Lorg/apache/xalan/xsltc/TransletOutputHandler;I)V")));
        if (stylesheet.hasLocalParams() || this.hasContents()) {
            int pop = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "popParamFrame", "()V");
            il.append(classGen.loadTranslet());
            il.append(new INVOKEVIRTUAL(pop));
        }
    }
}

