/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.output.OutputBase;
import org.apache.xalan.xsltc.runtime.output.SAXOutput;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXHTMLOutput
extends SAXOutput {
    public SAXHTMLOutput(ContentHandler handler, String encoding) throws IOException {
        super(handler, encoding);
    }

    public SAXHTMLOutput(ContentHandler handler, LexicalHandler lex, String encoding) throws IOException {
        super(handler, lex, encoding);
    }

    public void endDocument() throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            this._saxHandler.endDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void startElement(String elementName) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            if (this._lexHandler != null) {
                if (this._doctypeSystem != null || this._doctypePublic != null) {
                    this._lexHandler.startDTD(elementName, this._doctypePublic, this._doctypeSystem);
                }
                this._lexHandler = null;
            }
            ++this._depth;
            this._elementName = elementName;
            this._attributes.clear();
            this._startTagOpen = true;
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endElement(String elementName) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            this._saxHandler.endElement("", "", elementName);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        String patchedName = OutputBase.patchName(name);
        String localName = OutputBase.getLocalName(patchedName);
        int index = this._attributes.getIndex(name);
        if (!this._startTagOpen) {
            BasisLibrary.runTimeError(10, name);
        }
        if (index >= 0) {
            this._attributes.setAttribute(index, "", "", name, "CDATA", value);
        } else {
            this._attributes.addAttribute("", "", name, "CDATA", value);
        }
    }

    public void characters(char[] ch, int off, int len) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            this._saxHandler.characters(ch, off, len);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    protected void closeStartTag() throws TransletException {
        try {
            this._startTagOpen = false;
            this._saxHandler.startElement(null, this._elementName, this._elementName, this._attributes);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }
}

